/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui;

import com.airhacks.afterburner.injection.Injector;
import javafx.scene.control.Alert;
import javafx.scene.image.Image;
import javafx.scene.input.KeyEvent;
import javafx.stage.Modality;
import javafx.stage.Stage;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.keyboard.KeyBinding;
import org.jabref.gui.keyboard.KeyBindingRepository;

public class FXDialog
extends Alert {
    public FXDialog(Alert.AlertType type, String title, Image image, boolean isModal) {
        this(type, title, isModal);
        this.setDialogIcon(image);
    }

    public FXDialog(Alert.AlertType type, String title, Image image) {
        this(type, title, true);
        this.setDialogIcon(image);
    }

    public FXDialog(Alert.AlertType type, String title, boolean isModal) {
        this(type, isModal);
        this.setTitle(title);
    }

    public FXDialog(Alert.AlertType type, String title) {
        this(type);
        this.setTitle(title);
    }

    public FXDialog(Alert.AlertType type, boolean isModal) {
        super(type);
        this.setDialogIcon(IconTheme.getJabRefImage());
        Stage dialogWindow = this.getDialogWindow();
        dialogWindow.setOnCloseRequest(evt -> this.close());
        if (isModal) {
            this.initModality(Modality.APPLICATION_MODAL);
        } else {
            this.initModality(Modality.NONE);
        }
        dialogWindow.getScene().setOnKeyPressed(event -> {
            KeyBindingRepository keyBindingRepository = (KeyBindingRepository)Injector.instantiateModelOrService(KeyBindingRepository.class);
            if (keyBindingRepository.checkKeyCombinationEquality(KeyBinding.CLOSE, (KeyEvent)event)) {
                dialogWindow.close();
            }
        });
    }

    public FXDialog(Alert.AlertType type) {
        this(type, true);
    }

    private void setDialogIcon(Image image) {
        Stage fxDialogWindow = this.getDialogWindow();
        fxDialogWindow.getIcons().add((Object)image);
    }

    private Stage getDialogWindow() {
        return (Stage)this.getDialogPane().getScene().getWindow();
    }
}

