/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui;

import com.tobiasdiez.easybind.EasyBind;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.geometry.Pos;
import javafx.print.PrinterJob;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceDialog;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextInputDialog;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Duration;
import javafx.util.StringConverter;
import org.controlsfx.control.Notifications;
import org.controlsfx.control.TaskProgressView;
import org.controlsfx.control.textfield.CustomPasswordField;
import org.controlsfx.dialog.ExceptionDialog;
import org.controlsfx.dialog.ProgressDialog;
import org.jabref.gui.DialogService;
import org.jabref.gui.FXDialog;
import org.jabref.gui.StateManager;
import org.jabref.gui.help.ErrorConsoleAction;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.util.BackgroundTask;
import org.jabref.gui.util.BaseDialog;
import org.jabref.gui.util.DirectoryDialogConfiguration;
import org.jabref.gui.util.FileDialogConfiguration;
import org.jabref.gui.util.UiTaskExecutor;
import org.jabref.gui.util.ZipFileChooser;
import org.jabref.logic.l10n.Localization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JabRefDialogService
implements DialogService {
    public static final int DIALOG_SIZE_LIMIT = 300;
    private static final Duration TOAST_MESSAGE_DISPLAY_TIME = Duration.millis((double)3000.0);
    private static final Logger LOGGER = LoggerFactory.getLogger(JabRefDialogService.class);
    private final Window mainWindow;

    public JabRefDialogService(Window mainWindow) {
        this.mainWindow = mainWindow;
    }

    private FXDialog createDialog(Alert.AlertType type, String title, String content) {
        FXDialog alert = new FXDialog(type, title, true);
        alert.setHeaderText(null);
        alert.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
        alert.setResizable(true);
        TextArea area = new TextArea(content);
        alert.getDialogPane().setContent((Node)area);
        alert.initOwner(this.mainWindow);
        return alert;
    }

    private FXDialog createDialogWithOptOut(Alert.AlertType type, String title, String content, final String optOutMessage, final Consumer<Boolean> optOutAction) {
        FXDialog alert = new FXDialog(type, title, true);
        alert.getDialogPane().applyCss();
        Node graphic = alert.getDialogPane().getGraphic();
        alert.setDialogPane(new DialogPane(this){

            protected Node createDetailsButton() {
                CheckBox optOut = new CheckBox();
                optOut.setText(optOutMessage);
                optOut.setOnAction(e -> optOutAction.accept(optOut.isSelected()));
                return optOut;
            }
        });
        alert.getDialogPane().setExpandableContent((Node)new Group());
        alert.getDialogPane().setExpanded(true);
        alert.getDialogPane().setGraphic(graphic);
        alert.setHeaderText(null);
        alert.setContentText(content);
        alert.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
        alert.initOwner(this.mainWindow);
        return alert;
    }

    public static String shortenDialogMessage(String dialogMessage) {
        if (dialogMessage.length() < 300) {
            return dialogMessage.trim();
        }
        return (dialogMessage.substring(0, Math.min(dialogMessage.length(), 300)) + "...").trim();
    }

    private <T> ChoiceDialog<T> createChoiceDialog(String title, String content, String okButtonLabel, T defaultChoice, Collection<T> choices) {
        ChoiceDialog choiceDialog = new ChoiceDialog(defaultChoice, choices);
        ((Stage)choiceDialog.getDialogPane().getScene().getWindow()).getIcons().add((Object)IconTheme.getJabRefImage());
        ButtonType okButtonType = new ButtonType(okButtonLabel, ButtonBar.ButtonData.OK_DONE);
        choiceDialog.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.CANCEL, okButtonType});
        choiceDialog.setHeaderText(title);
        choiceDialog.setTitle(title);
        choiceDialog.setContentText(content);
        choiceDialog.initOwner(this.mainWindow);
        return choiceDialog;
    }

    @Override
    public <T> Optional<T> showChoiceDialogAndWait(String title, String content, String okButtonLabel, T defaultChoice, Collection<T> choices) {
        return this.createChoiceDialog(title, content, okButtonLabel, defaultChoice, choices).showAndWait();
    }

    @Override
    public <T> Optional<T> showEditableChoiceDialogAndWait(String title, String content, String okButtonLabel, T defaultChoice, Collection<T> choices, StringConverter<T> converter) {
        ChoiceDialog<T> choiceDialog = this.createChoiceDialog(title, content, okButtonLabel, defaultChoice, choices);
        ComboBox comboBox = (ComboBox)choiceDialog.getDialogPane().lookup(".combo-box");
        comboBox.setEditable(true);
        comboBox.setConverter(converter);
        EasyBind.subscribe((ObservableValue)comboBox.getEditor().textProperty(), text -> comboBox.setValue(converter.fromString(text)));
        return choiceDialog.showAndWait();
    }

    @Override
    public Optional<String> showInputDialogAndWait(String title, String content) {
        TextInputDialog inputDialog = new TextInputDialog();
        inputDialog.setHeaderText(title);
        inputDialog.setContentText(content);
        inputDialog.initOwner(this.mainWindow);
        return inputDialog.showAndWait();
    }

    @Override
    public Optional<String> showInputDialogWithDefaultAndWait(String title, String content, String defaultValue) {
        TextInputDialog inputDialog = new TextInputDialog(defaultValue);
        inputDialog.setHeaderText(title);
        inputDialog.setContentText(content);
        inputDialog.initOwner(this.mainWindow);
        return inputDialog.showAndWait();
    }

    @Override
    public void showInformationDialogAndWait(String title, String content) {
        FXDialog alert = this.createDialog(Alert.AlertType.INFORMATION, title, content);
        alert.showAndWait();
    }

    @Override
    public void showWarningDialogAndWait(String title, String content) {
        FXDialog alert = this.createDialog(Alert.AlertType.WARNING, title, content);
        alert.showAndWait();
    }

    @Override
    public void showErrorDialogAndWait(String title, String content) {
        FXDialog alert = this.createDialog(Alert.AlertType.ERROR, title, content);
        alert.showAndWait();
    }

    @Override
    public void showErrorDialogAndWait(String message, Throwable exception) {
        ExceptionDialog exceptionDialog = new ExceptionDialog(exception);
        exceptionDialog.getDialogPane().setMaxWidth(this.mainWindow.getWidth() / 2.0);
        exceptionDialog.setHeaderText(message);
        exceptionDialog.initOwner(this.mainWindow);
        exceptionDialog.showAndWait();
    }

    @Override
    public void showErrorDialogAndWait(String title, String content, Throwable exception) {
        ExceptionDialog exceptionDialog = new ExceptionDialog(exception);
        exceptionDialog.setHeaderText(title);
        exceptionDialog.setContentText(content);
        exceptionDialog.initOwner(this.mainWindow);
        exceptionDialog.showAndWait();
    }

    @Override
    public void showErrorDialogAndWait(String message) {
        FXDialog alert = this.createDialog(Alert.AlertType.ERROR, Localization.lang("Error Occurred", new Object[0]), message);
        alert.showAndWait();
    }

    @Override
    public boolean showConfirmationDialogAndWait(String title, String content) {
        FXDialog alert = this.createDialog(Alert.AlertType.CONFIRMATION, title, content);
        return alert.showAndWait().filter(buttonType -> buttonType == ButtonType.OK).isPresent();
    }

    @Override
    public boolean showConfirmationDialogAndWait(String title, String content, String okButtonLabel) {
        FXDialog alert = this.createDialog(Alert.AlertType.CONFIRMATION, title, content);
        ButtonType okButtonType = new ButtonType(okButtonLabel, ButtonBar.ButtonData.OK_DONE);
        alert.getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.CANCEL, okButtonType});
        return alert.showAndWait().filter(buttonType -> buttonType == okButtonType).isPresent();
    }

    @Override
    public boolean showConfirmationDialogAndWait(String title, String content, String okButtonLabel, String cancelButtonLabel) {
        FXDialog alert = this.createDialog(Alert.AlertType.CONFIRMATION, title, content);
        ButtonType okButtonType = new ButtonType(okButtonLabel, ButtonBar.ButtonData.OK_DONE);
        ButtonType cancelButtonType = new ButtonType(cancelButtonLabel, ButtonBar.ButtonData.NO);
        alert.getButtonTypes().setAll((Object[])new ButtonType[]{okButtonType, cancelButtonType});
        return alert.showAndWait().filter(buttonType -> buttonType == okButtonType).isPresent();
    }

    @Override
    public boolean showConfirmationDialogWithOptOutAndWait(String title, String content, String optOutMessage, Consumer<Boolean> optOutAction) {
        FXDialog alert = this.createDialogWithOptOut(Alert.AlertType.CONFIRMATION, title, content, optOutMessage, optOutAction);
        alert.getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.YES, ButtonType.NO});
        return alert.showAndWait().filter(buttonType -> buttonType == ButtonType.YES).isPresent();
    }

    @Override
    public boolean showConfirmationDialogWithOptOutAndWait(String title, String content, String okButtonLabel, String cancelButtonLabel, String optOutMessage, Consumer<Boolean> optOutAction) {
        FXDialog alert = this.createDialogWithOptOut(Alert.AlertType.CONFIRMATION, title, content, optOutMessage, optOutAction);
        ButtonType okButtonType = new ButtonType(okButtonLabel, ButtonBar.ButtonData.YES);
        ButtonType cancelButtonType = new ButtonType(cancelButtonLabel, ButtonBar.ButtonData.NO);
        alert.getButtonTypes().setAll((Object[])new ButtonType[]{okButtonType, cancelButtonType});
        return alert.showAndWait().filter(buttonType -> buttonType == okButtonType).isPresent();
    }

    @Override
    public Optional<ButtonType> showCustomButtonDialogAndWait(Alert.AlertType type, String title, String content, ButtonType ... buttonTypes) {
        FXDialog alert = this.createDialog(type, title, content);
        alert.getButtonTypes().setAll((Object[])buttonTypes);
        return alert.showAndWait();
    }

    @Override
    public Optional<ButtonType> showCustomDialogAndWait(String title, DialogPane contentPane, ButtonType ... buttonTypes) {
        FXDialog alert = new FXDialog(Alert.AlertType.NONE, title);
        alert.setDialogPane(contentPane);
        alert.getButtonTypes().setAll((Object[])buttonTypes);
        alert.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
        alert.setResizable(true);
        alert.initOwner(this.mainWindow);
        return alert.showAndWait();
    }

    @Override
    public <R> Optional<R> showCustomDialogAndWait(Dialog<R> dialog) {
        if (dialog.getOwner() == null) {
            dialog.initOwner(this.mainWindow);
        }
        return dialog.showAndWait();
    }

    @Override
    public Optional<String> showPasswordDialogAndWait(String title, String header, String content) {
        Dialog dialog = new Dialog();
        dialog.setTitle(title);
        dialog.setHeaderText(header);
        CustomPasswordField passwordField = new CustomPasswordField();
        HBox box = new HBox();
        box.setSpacing(10.0);
        box.getChildren().addAll((Object[])new Node[]{new Label(content), passwordField});
        dialog.setTitle(title);
        dialog.getDialogPane().setContent((Node)box);
        dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CANCEL, ButtonType.OK});
        dialog.setResultConverter(dialogButton -> {
            if (dialogButton == ButtonType.OK) {
                return passwordField.getText();
            }
            return null;
        });
        return dialog.showAndWait();
    }

    private <V> ProgressDialog createProgressDialog(String title, String content, Task<V> task) {
        ProgressDialog progressDialog = new ProgressDialog(task);
        progressDialog.setHeaderText(null);
        progressDialog.setTitle(title);
        progressDialog.setContentText(content);
        progressDialog.setGraphic(null);
        ((Stage)progressDialog.getDialogPane().getScene().getWindow()).getIcons().add((Object)IconTheme.getJabRefImage());
        progressDialog.setOnCloseRequest(evt -> task.cancel());
        DialogPane dialogPane = progressDialog.getDialogPane();
        dialogPane.getButtonTypes().add((Object)ButtonType.CANCEL);
        Button cancelButton = (Button)dialogPane.lookupButton(ButtonType.CANCEL);
        cancelButton.setOnAction(evt -> {
            task.cancel();
            progressDialog.close();
        });
        progressDialog.initOwner(this.mainWindow);
        return progressDialog;
    }

    @Override
    public <V> void showProgressDialog(String title, String content, Task<V> task) {
        ProgressDialog progressDialog = this.createProgressDialog(title, content, task);
        progressDialog.show();
    }

    @Override
    public <V> void showProgressDialogAndWait(String title, String content, Task<V> task) {
        ProgressDialog progressDialog = this.createProgressDialog(title, content, task);
        progressDialog.showAndWait();
    }

    @Override
    public <V> Optional<ButtonType> showBackgroundProgressDialogAndWait(String title, String content, StateManager stateManager) {
        TaskProgressView taskProgressView = new TaskProgressView();
        EasyBind.bindContent((List)taskProgressView.getTasks(), stateManager.getBackgroundTasks());
        taskProgressView.setRetainTasks(false);
        taskProgressView.setGraphicFactory(BackgroundTask::getIcon);
        Label message = new Label(content);
        VBox box = new VBox(new Node[]{taskProgressView, message});
        DialogPane contentPane = new DialogPane();
        contentPane.setContent((Node)box);
        FXDialog alert = new FXDialog(Alert.AlertType.WARNING, title);
        alert.setDialogPane(contentPane);
        alert.getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.YES, ButtonType.CANCEL});
        alert.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
        alert.setResizable(true);
        alert.initOwner(this.mainWindow);
        stateManager.getAnyTasksThatWillNotBeRecoveredRunning().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                alert.setResult(ButtonType.YES);
                alert.close();
            }
        });
        return alert.showAndWait();
    }

    @Override
    public void notify(String message) {
        LOGGER.info(message);
        UiTaskExecutor.runInJavaFXThread(() -> Notifications.create().text(message).position(Pos.BOTTOM_CENTER).hideAfter(TOAST_MESSAGE_DISPLAY_TIME).owner((Object)this.mainWindow).threshold(5, Notifications.create().title(Localization.lang("Last notification", new Object[0])).text("(" + Localization.lang("Check the event log to see all notifications", new Object[0]) + ")\n\n" + message).onAction(e -> {
            ErrorConsoleAction ec = new ErrorConsoleAction();
            ec.execute();
        })).hideCloseButton().show());
    }

    @Override
    public Optional<Path> showFileSaveDialog(FileDialogConfiguration fileDialogConfiguration) {
        FileChooser chooser = this.getConfiguredFileChooser(fileDialogConfiguration);
        File file = chooser.showSaveDialog(this.mainWindow);
        Optional.ofNullable(chooser.getSelectedExtensionFilter()).ifPresent(fileDialogConfiguration::setSelectedExtensionFilter);
        return Optional.ofNullable(file).map(File::toPath);
    }

    @Override
    public Optional<Path> showFileOpenDialog(FileDialogConfiguration fileDialogConfiguration) {
        FileChooser chooser = this.getConfiguredFileChooser(fileDialogConfiguration);
        File file = chooser.showOpenDialog(this.mainWindow);
        Optional.ofNullable(chooser.getSelectedExtensionFilter()).ifPresent(fileDialogConfiguration::setSelectedExtensionFilter);
        return Optional.ofNullable(file).map(File::toPath);
    }

    @Override
    public Optional<Path> showDirectorySelectionDialog(DirectoryDialogConfiguration directoryDialogConfiguration) {
        DirectoryChooser chooser = this.getConfiguredDirectoryChooser(directoryDialogConfiguration);
        File file = chooser.showDialog(this.mainWindow);
        return Optional.ofNullable(file).map(File::toPath);
    }

    @Override
    public List<Path> showFileOpenDialogAndGetMultipleFiles(FileDialogConfiguration fileDialogConfiguration) {
        FileChooser chooser = this.getConfiguredFileChooser(fileDialogConfiguration);
        List files = chooser.showOpenMultipleDialog(this.mainWindow);
        return files != null ? files.stream().map(File::toPath).collect(Collectors.toList()) : Collections.emptyList();
    }

    private DirectoryChooser getConfiguredDirectoryChooser(DirectoryDialogConfiguration directoryDialogConfiguration) {
        DirectoryChooser chooser = new DirectoryChooser();
        directoryDialogConfiguration.getInitialDirectory().map(Path::toFile).ifPresent(arg_0 -> ((DirectoryChooser)chooser).setInitialDirectory(arg_0));
        return chooser;
    }

    private FileChooser getConfiguredFileChooser(FileDialogConfiguration fileDialogConfiguration) {
        FileChooser chooser = new FileChooser();
        chooser.getExtensionFilters().addAll(fileDialogConfiguration.getExtensionFilters());
        chooser.setSelectedExtensionFilter(fileDialogConfiguration.getDefaultExtension());
        chooser.setInitialFileName(fileDialogConfiguration.getInitialFileName());
        fileDialogConfiguration.getInitialDirectory().map(Path::toFile).ifPresent(arg_0 -> ((FileChooser)chooser).setInitialDirectory(arg_0));
        return chooser;
    }

    @Override
    public boolean showPrintDialog(PrinterJob job) {
        return job.showPrintDialog(this.mainWindow);
    }

    @Override
    public Optional<Path> showFileOpenFromArchiveDialog(Path archivePath) throws IOException {
        Optional optional;
        block8: {
            FileSystem zipFile = FileSystems.newFileSystem(archivePath, (ClassLoader)null);
            try {
                optional = new ZipFileChooser(zipFile).showAndWait();
                if (zipFile == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (zipFile != null) {
                        try {
                            zipFile.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoClassDefFoundError exc) {
                    throw new IOException("Could not instantiate ZIP-archive reader.", exc);
                }
            }
            zipFile.close();
        }
        return optional;
    }

    @Override
    public void showCustomDialog(BaseDialog<?> aboutDialogView) {
        if (aboutDialogView.getOwner() == null) {
            aboutDialogView.initOwner(this.mainWindow);
        }
        aboutDialogView.show();
    }
}

