/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.autocompleter;

import javafx.util.StringConverter;
import org.jabref.gui.autocompleter.AutoCompleteFirstNameMode;
import org.jabref.gui.autocompleter.AutoCompletePreferences;
import org.jabref.model.entry.Author;
import org.jabref.model.entry.AuthorList;

public class PersonNameStringConverter
extends StringConverter<Author> {
    private final boolean autoCompFF;
    private final boolean autoCompLF;
    private final AutoCompleteFirstNameMode autoCompleteFirstNameMode;

    public PersonNameStringConverter(boolean autoCompFF, boolean autoCompLF, AutoCompleteFirstNameMode autoCompleteFirstNameMode) {
        this.autoCompFF = autoCompFF;
        this.autoCompLF = autoCompLF;
        this.autoCompleteFirstNameMode = autoCompleteFirstNameMode;
    }

    public PersonNameStringConverter(AutoCompletePreferences preferences) {
        switch (preferences.getNameFormat()) {
            case FIRST_LAST: {
                this.autoCompFF = true;
                this.autoCompLF = false;
                break;
            }
            case LAST_FIRST: {
                this.autoCompFF = false;
                this.autoCompLF = true;
                break;
            }
            default: {
                this.autoCompFF = true;
                this.autoCompLF = true;
            }
        }
        this.autoCompleteFirstNameMode = preferences.getFirstNameMode();
    }

    public String toString(Author author) {
        if (this.autoCompLF) {
            switch (this.autoCompleteFirstNameMode) {
                case ONLY_ABBREVIATED: {
                    return author.getFamilyGiven(true);
                }
                case ONLY_FULL: {
                    return author.getFamilyGiven(false);
                }
                case BOTH: {
                    return author.getFamilyGiven(true);
                }
            }
        }
        if (this.autoCompFF) {
            switch (this.autoCompleteFirstNameMode) {
                case ONLY_ABBREVIATED: {
                    return author.getGivenFamily(true);
                }
                case ONLY_FULL: {
                    return author.getGivenFamily(false);
                }
                case BOTH: {
                    return author.getGivenFamily(true);
                }
            }
        }
        return author.getNamePrefixAndFamilyName();
    }

    public Author fromString(String string) {
        return AuthorList.parse(string).getAuthor(0);
    }
}

