/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.autocompleter;

import com.google.common.base.Equivalence;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.controlsfx.control.textfield.AutoCompletionBinding;

public abstract class SuggestionProvider<T> {
    public final Collection<T> provideSuggestions(AutoCompletionBinding.ISuggestionRequest request) {
        if (!request.getUserText().isEmpty()) {
            Comparator<T> comparator = this.getComparator();
            Equivalence<T> equivalence = this.getEquivalence();
            return this.getSource().filter(candidate -> this.isMatch(candidate, request)).map(arg_0 -> equivalence.wrap(arg_0)).distinct().limit(10L).map(Equivalence.Wrapper::get).sorted(comparator).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    protected abstract Equivalence<T> getEquivalence();

    public List<T> getPossibleSuggestions() {
        Comparator<T> comparator = this.getComparator().reversed();
        Equivalence<T> equivalence = this.getEquivalence();
        return this.getSource().map(arg_0 -> equivalence.wrap(arg_0)).distinct().map(Equivalence.Wrapper::get).sorted(comparator).collect(Collectors.toList());
    }

    protected abstract Comparator<T> getComparator();

    protected abstract boolean isMatch(T var1, AutoCompletionBinding.ISuggestionRequest var2);

    public abstract Stream<T> getSource();
}

