/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.collab.metedatachange;

import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.VBox;
import org.jabref.gui.collab.DatabaseChangeDetailsView;
import org.jabref.gui.collab.metedatachange.MetadataChange;
import org.jabref.logic.bibtex.comparator.MetaDataDiff;
import org.jabref.logic.citationkeypattern.GlobalCitationKeyPatterns;
import org.jabref.logic.l10n.Localization;

public final class MetadataChangeDetailsView
extends DatabaseChangeDetailsView {
    public MetadataChangeDetailsView(MetadataChange metadataChange, GlobalCitationKeyPatterns globalCitationKeyPatterns) {
        VBox container = new VBox(15.0);
        Label header = new Label(Localization.lang("The following metadata changed:", new Object[0]));
        header.getStyleClass().add((Object)"sectionHeader");
        container.getChildren().add((Object)header);
        for (MetaDataDiff.Difference diff : metadataChange.getMetaDataDiff().getDifferences(globalCitationKeyPatterns)) {
            container.getChildren().add((Object)new Label(this.getDifferenceString(diff.differenceType())));
            container.getChildren().add((Object)new Label(diff.originalObject().toString()));
            container.getChildren().add((Object)new Label(diff.newObject().toString()));
        }
        ScrollPane scrollPane = new ScrollPane((Node)container);
        this.setAllAnchorsAndAttachChild((Node)scrollPane);
    }

    private String getDifferenceString(MetaDataDiff.DifferenceType changeType) {
        return switch (changeType) {
            default -> throw new MatchException(null, null);
            case MetaDataDiff.DifferenceType.PROTECTED -> Localization.lang("Library protection", new Object[0]);
            case MetaDataDiff.DifferenceType.GROUPS -> Localization.lang("Modified groups tree", new Object[0]);
            case MetaDataDiff.DifferenceType.ENCODING -> Localization.lang("Library encoding", new Object[0]);
            case MetaDataDiff.DifferenceType.SAVE_SORT_ORDER -> Localization.lang("Save sort order", new Object[0]);
            case MetaDataDiff.DifferenceType.KEY_PATTERNS -> Localization.lang("Key patterns", new Object[0]);
            case MetaDataDiff.DifferenceType.USER_FILE_DIRECTORY -> Localization.lang("User-specific file directory", new Object[0]);
            case MetaDataDiff.DifferenceType.LATEX_FILE_DIRECTORY -> Localization.lang("LaTeX file directory", new Object[0]);
            case MetaDataDiff.DifferenceType.DEFAULT_KEY_PATTERN -> Localization.lang("Default pattern", new Object[0]);
            case MetaDataDiff.DifferenceType.SAVE_ACTIONS -> Localization.lang("Save actions", new Object[0]);
            case MetaDataDiff.DifferenceType.MODE -> Localization.lang("Library mode", new Object[0]);
            case MetaDataDiff.DifferenceType.GENERAL_FILE_DIRECTORY -> Localization.lang("General file directory", new Object[0]);
            case MetaDataDiff.DifferenceType.CONTENT_SELECTOR -> Localization.lang("Content selectors", new Object[0]);
        };
    }
}

