/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.commonfxcontrols;

import java.util.Collection;
import java.util.Comparator;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import org.jabref.gui.commonfxcontrols.CitationKeyPatternsPanelItemModel;
import org.jabref.logic.citationkeypattern.AbstractCitationKeyPatterns;
import org.jabref.logic.citationkeypattern.CitationKeyPattern;
import org.jabref.logic.citationkeypattern.CitationKeyPatternPreferences;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.BibEntryType;
import org.jabref.model.entry.types.EntryType;

public class CitationKeyPatternsPanelViewModel {
    public static final String ENTRY_TYPE_DEFAULT_NAME = "default";
    public static Comparator<CitationKeyPatternsPanelItemModel> defaultOnTopComparator = (o1, o2) -> {
        String itemTwoName;
        String itemOneName = o1.getEntryType().getName();
        if (itemOneName.equals(itemTwoName = o2.getEntryType().getName())) {
            return 0;
        }
        if (itemOneName.equals(ENTRY_TYPE_DEFAULT_NAME)) {
            return -1;
        }
        if (itemTwoName.equals(ENTRY_TYPE_DEFAULT_NAME)) {
            return 1;
        }
        return 0;
    };
    private final ListProperty<CitationKeyPatternsPanelItemModel> patternListProperty = new SimpleListProperty();
    private final ObjectProperty<CitationKeyPatternsPanelItemModel> defaultItemProperty = new SimpleObjectProperty();
    private final CitationKeyPatternPreferences keyPatternPreferences;

    public CitationKeyPatternsPanelViewModel(CitationKeyPatternPreferences keyPatternPreferences) {
        this.keyPatternPreferences = keyPatternPreferences;
    }

    public void setValues(Collection<BibEntryType> entryTypeList, AbstractCitationKeyPatterns initialKeyPattern) {
        String defaultPattern = initialKeyPattern.getDefaultValue() == null || initialKeyPattern.getDefaultValue().equals(CitationKeyPattern.NULL_CITATION_KEY_PATTERN) ? "" : initialKeyPattern.getDefaultValue().stringRepresentation();
        this.defaultItemProperty.setValue((Object)new CitationKeyPatternsPanelItemModel(new DefaultEntryType(), defaultPattern));
        this.patternListProperty.setValue(FXCollections.observableArrayList());
        this.patternListProperty.add((Object)((CitationKeyPatternsPanelItemModel)this.defaultItemProperty.getValue()));
        entryTypeList.stream().map(BibEntryType::getType).forEach(entryType -> {
            String pattern = initialKeyPattern.isDefaultValue((EntryType)entryType) ? "" : initialKeyPattern.getPatterns().get(entryType).stringRepresentation();
            this.patternListProperty.add((Object)new CitationKeyPatternsPanelItemModel((EntryType)entryType, pattern));
        });
    }

    public void setItemToDefaultPattern(CitationKeyPatternsPanelItemModel item) {
        item.setPattern(this.keyPatternPreferences.getDefaultPattern());
    }

    public void resetAll() {
        this.patternListProperty.forEach(item -> item.setPattern(""));
        ((CitationKeyPatternsPanelItemModel)this.defaultItemProperty.getValue()).setPattern(this.keyPatternPreferences.getDefaultPattern());
    }

    public ListProperty<CitationKeyPatternsPanelItemModel> patternListProperty() {
        return this.patternListProperty;
    }

    public ObjectProperty<CitationKeyPatternsPanelItemModel> defaultKeyPatternProperty() {
        return this.defaultItemProperty;
    }

    public static class DefaultEntryType
    implements EntryType {
        @Override
        public String getName() {
            return CitationKeyPatternsPanelViewModel.ENTRY_TYPE_DEFAULT_NAME;
        }

        @Override
        public String getDisplayName() {
            return Localization.lang("Default pattern", new Object[0]);
        }
    }
}

