/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.copyfiles;

import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import org.jabref.gui.DialogService;
import org.jabref.gui.StateManager;
import org.jabref.gui.actions.ActionHelper;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.copyfiles.CopyFilesDialogView;
import org.jabref.gui.copyfiles.CopyFilesResultItemViewModel;
import org.jabref.gui.copyfiles.CopyFilesResultListDependency;
import org.jabref.gui.copyfiles.CopyFilesTask;
import org.jabref.gui.util.DirectoryDialogConfiguration;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.preferences.PreferencesService;

public class CopyFilesAction
extends SimpleCommand {
    private final DialogService dialogService;
    private final PreferencesService preferencesService;
    private final StateManager stateManager;
    private final TaskExecutor taskExecutor;

    public CopyFilesAction(DialogService dialogService, PreferencesService preferencesService, StateManager stateManager, TaskExecutor taskExecutor) {
        this.dialogService = dialogService;
        this.preferencesService = preferencesService;
        this.stateManager = stateManager;
        this.taskExecutor = taskExecutor;
        this.executable.bind((ObservableValue)ActionHelper.needsDatabase(stateManager).and((ObservableBooleanValue)ActionHelper.needsEntriesSelected(stateManager)));
    }

    private void showDialog(List<CopyFilesResultItemViewModel> data) {
        if (data.isEmpty()) {
            this.dialogService.showInformationDialogAndWait(Localization.lang("Copy linked files to folder...", new Object[0]), Localization.lang("No linked files found for export.", new Object[0]));
            return;
        }
        this.dialogService.showCustomDialogAndWait(new CopyFilesDialogView(new CopyFilesResultListDependency(data)));
    }

    public void execute() {
        BibDatabaseContext database = this.stateManager.getActiveDatabase().orElseThrow(() -> new NullPointerException("Database null"));
        ObservableList<BibEntry> entries = this.stateManager.getSelectedEntries();
        DirectoryDialogConfiguration dirDialogConfiguration = new DirectoryDialogConfiguration.Builder().withInitialDirectory(this.preferencesService.getExportPreferences().getExportWorkingDirectory()).build();
        Optional<Path> exportPath = this.dialogService.showDirectorySelectionDialog(dirDialogConfiguration);
        exportPath.ifPresent(path -> {
            CopyFilesTask exportTask = new CopyFilesTask(database, (List<BibEntry>)entries, (Path)path, this.preferencesService);
            this.dialogService.showProgressDialog(Localization.lang("Copy linked files to folder...", new Object[0]), Localization.lang("Copy linked files to folder...", new Object[0]), exportTask);
            this.taskExecutor.execute(exportTask);
            exportTask.setOnSucceeded(e -> this.showDialog((List)exportTask.getValue()));
        });
    }
}

