/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.desktop.os;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.harawata.appdirs.AppDirsFactory;
import org.jabref.architecture.AllowedToUseAwt;
import org.jabref.gui.DialogService;
import org.jabref.logic.util.BuildInfo;
import org.jabref.logic.util.OS;
import org.jabref.model.strings.StringUtil;
import org.jabref.preferences.FilePreferences;
import org.slf4j.LoggerFactory;

@AllowedToUseAwt(value="Because of moveToTrash() is not available elsewhere.")
public abstract class NativeDesktop {
    public abstract void openFile(String var1, String var2, FilePreferences var3) throws IOException;

    public abstract void openFileWithApplication(String var1, String var2) throws IOException;

    public abstract void openFolderAndSelectFile(Path var1) throws IOException;

    public abstract void openConsole(String var1, DialogService var2) throws IOException;

    public abstract String detectProgramPath(String var1, String var2);

    public abstract Path getApplicationDirectory();

    public Path getDefaultFileChooserDirectory() {
        Path userDirectory = this.getUserDirectory();
        Path documents = userDirectory.resolve("Documents");
        if (!Files.exists(documents, new LinkOption[0])) {
            return userDirectory;
        }
        return documents;
    }

    public Path getUserDirectory() {
        return Path.of(System.getProperty("user.home"), new String[0]);
    }

    public Path getLogDirectory() {
        return Path.of(AppDirsFactory.getInstance().getUserDataDir("jabref", "logs", "org.jabref"), new String[0]).resolve(new BuildInfo().version.toString());
    }

    public Path getBackupDirectory() {
        return Path.of(AppDirsFactory.getInstance().getUserDataDir("jabref", "backups", "org.jabref"), new String[0]);
    }

    public Path getFulltextIndexBaseDirectory() {
        return Path.of(AppDirsFactory.getInstance().getUserDataDir("jabref", "lucene" + File.separator + "99", "org.jabref"), new String[0]);
    }

    public Path getSslDirectory() {
        return Path.of(AppDirsFactory.getInstance().getUserDataDir("jabref", "ssl", "org.jabref"), new String[0]);
    }

    public String getHostName() {
        String hostName = System.getenv("HOSTNAME");
        if (StringUtil.isBlank(hostName)) {
            hostName = System.getenv("COMPUTERNAME");
        }
        if (StringUtil.isBlank(hostName)) {
            try {
                hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                LoggerFactory.getLogger(OS.class).info("Hostname not found. Using \"localhost\" as fallback.", (Throwable)e);
                hostName = "localhost";
            }
        }
        return hostName;
    }

    public void moveToTrash(Path path) {
        Desktop.getDesktop().moveToTrash(path.toFile());
    }

    public boolean moveToTrashSupported() {
        return Desktop.getDesktop().isSupported(Desktop.Action.MOVE_TO_TRASH);
    }
}

