/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.edit;

import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import org.jabref.gui.ClipBoardManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.JabRefDialogService;
import org.jabref.gui.StateManager;
import org.jabref.gui.actions.ActionHelper;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.actions.StandardActions;
import org.jabref.logic.journals.JournalAbbreviationRepository;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.layout.Layout;
import org.jabref.logic.layout.LayoutHelper;
import org.jabref.logic.push.CitationCommandString;
import org.jabref.logic.util.OS;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.StandardField;
import org.jabref.preferences.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyMoreAction
extends SimpleCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(CopyMoreAction.class);
    private final StandardActions action;
    private final DialogService dialogService;
    private final StateManager stateManager;
    private final ClipBoardManager clipBoardManager;
    private final PreferencesService preferencesService;
    private final JournalAbbreviationRepository abbreviationRepository;

    public CopyMoreAction(StandardActions action, DialogService dialogService, StateManager stateManager, ClipBoardManager clipBoardManager, PreferencesService preferencesService, JournalAbbreviationRepository abbreviationRepository) {
        this.action = action;
        this.dialogService = dialogService;
        this.stateManager = stateManager;
        this.clipBoardManager = clipBoardManager;
        this.preferencesService = preferencesService;
        this.abbreviationRepository = abbreviationRepository;
        this.executable.bind((ObservableValue)ActionHelper.needsEntriesSelected(stateManager));
    }

    public void execute() {
        if (this.stateManager.getActiveDatabase().isEmpty() || this.stateManager.getSelectedEntries().isEmpty()) {
            return;
        }
        switch (this.action) {
            case COPY_TITLE: {
                this.copyTitle();
                break;
            }
            case COPY_KEY: {
                this.copyKey();
                break;
            }
            case COPY_CITE_KEY: {
                this.copyCiteKey();
                break;
            }
            case COPY_KEY_AND_TITLE: {
                this.copyKeyAndTitle();
                break;
            }
            case COPY_KEY_AND_LINK: {
                this.copyKeyAndLink();
                break;
            }
            case COPY_DOI: 
            case COPY_DOI_URL: {
                this.copyDoi();
                break;
            }
            default: {
                LOGGER.info("Unknown copy command.");
            }
        }
    }

    private void copyTitle() {
        ObservableList<BibEntry> selectedBibEntries = this.stateManager.getSelectedEntries();
        List titles = selectedBibEntries.stream().filter(bibEntry -> bibEntry.getTitle().isPresent()).map(bibEntry -> bibEntry.getTitle().get()).collect(Collectors.toList());
        if (titles.isEmpty()) {
            this.dialogService.notify(Localization.lang("None of the selected entries have titles.", new Object[0]));
            return;
        }
        String copiedTitles = String.join((CharSequence)"\n", titles);
        this.clipBoardManager.setContent(copiedTitles);
        if (titles.size() == selectedBibEntries.size()) {
            this.dialogService.notify(Localization.lang("Copied '%0' to clipboard.", JabRefDialogService.shortenDialogMessage(copiedTitles)));
        } else {
            this.dialogService.notify(Localization.lang("Warning: %0 out of %1 entries have undefined title.", Integer.toString(selectedBibEntries.size() - titles.size()), Integer.toString(selectedBibEntries.size())));
        }
    }

    private void copyDoi() {
        ObservableList<BibEntry> entries = this.stateManager.getSelectedEntries();
        if (this.action == StandardActions.COPY_DOI_URL) {
            this.copyDoiList(entries.stream().filter(entry -> entry.getDOI().isPresent()).map(entry -> entry.getDOI().get().getURIAsASCIIString()).collect(Collectors.toList()), entries.size());
        } else {
            this.copyDoiList(entries.stream().filter(entry -> entry.getDOI().isPresent()).map(entry -> entry.getDOI().get().getDOI()).collect(Collectors.toList()), entries.size());
        }
    }

    private void copyDoiList(List<String> dois, int size) {
        if (dois.isEmpty()) {
            this.dialogService.notify(Localization.lang("None of the selected entries have DOIs.", new Object[0]));
            return;
        }
        String copiedDois = String.join((CharSequence)",", dois);
        this.clipBoardManager.setContent(copiedDois);
        if (dois.size() == size) {
            this.dialogService.notify(Localization.lang("Copied '%0' to clipboard.", JabRefDialogService.shortenDialogMessage(copiedDois)));
        } else {
            this.dialogService.notify(Localization.lang("Warning: %0 out of %1 entries have undefined DOIs.", Integer.toString(size - dois.size()), Integer.toString(size)));
        }
    }

    private void doCopyKey(Function<List<String>, String> mapKeyList) {
        ObservableList<BibEntry> entries = this.stateManager.getSelectedEntries();
        List keys = entries.stream().filter(entry -> entry.getCitationKey().isPresent()).map(entry -> entry.getCitationKey().get()).collect(Collectors.toList());
        if (keys.isEmpty()) {
            this.dialogService.notify(Localization.lang("None of the selected entries have citation keys.", new Object[0]));
            return;
        }
        String clipBoardContent = mapKeyList.apply(keys);
        this.clipBoardManager.setContent(clipBoardContent);
        if (keys.size() == entries.size()) {
            this.dialogService.notify(Localization.lang("Copied '%0' to clipboard.", JabRefDialogService.shortenDialogMessage(clipBoardContent)));
        } else {
            this.dialogService.notify(Localization.lang("Warning: %0 out of %1 entries have undefined citation key.", Integer.toString(entries.size() - keys.size()), Integer.toString(entries.size())));
        }
    }

    private void copyCiteKey() {
        this.doCopyKey(keys -> {
            CitationCommandString citeCommand = this.preferencesService.getExternalApplicationsPreferences().getCiteCommand();
            return citeCommand.prefix() + String.join((CharSequence)citeCommand.delimiter(), keys) + citeCommand.suffix();
        });
    }

    private void copyKey() {
        this.doCopyKey(keys -> String.join((CharSequence)this.preferencesService.getExternalApplicationsPreferences().getCiteCommand().delimiter(), keys));
    }

    private void copyKeyAndTitle() {
        Layout layout;
        ObservableList<BibEntry> entries = this.stateManager.getSelectedEntries();
        StringReader layoutString = new StringReader("\\citationkey - \\begin{title}\\format[RemoveBrackets]{\\title}\\end{title}\n");
        try {
            layout = new LayoutHelper(layoutString, this.preferencesService.getLayoutFormatterPreferences(), this.abbreviationRepository).getLayoutFromText();
        }
        catch (IOException e) {
            LOGGER.info("Could not get layout.", (Throwable)e);
            return;
        }
        StringBuilder keyAndTitle = new StringBuilder();
        int entriesWithKeys = 0;
        for (BibEntry entry : entries) {
            if (!entry.hasCitationKey()) continue;
            ++entriesWithKeys;
            this.stateManager.getActiveDatabase().map(BibDatabaseContext::getDatabase).ifPresent(bibDatabase -> keyAndTitle.append(layout.doLayout(entry, (BibDatabase)bibDatabase)));
        }
        if (entriesWithKeys == 0) {
            this.dialogService.notify(Localization.lang("None of the selected entries have citation keys.", new Object[0]));
            return;
        }
        this.clipBoardManager.setContent(keyAndTitle.toString());
        if (entriesWithKeys == entries.size()) {
            this.dialogService.notify(Localization.lang("Copied '%0' to clipboard.", JabRefDialogService.shortenDialogMessage(keyAndTitle.toString())));
        } else {
            this.dialogService.notify(Localization.lang("Warning: %0 out of %1 entries have undefined citation key.", Integer.toString(entries.size() - entriesWithKeys), Integer.toString(entries.size())));
        }
    }

    private void copyKeyAndLink() {
        ObservableList<BibEntry> entries = this.stateManager.getSelectedEntries();
        StringBuilder keyAndLink = new StringBuilder();
        StringBuilder fallbackString = new StringBuilder();
        List<BibEntry> entriesWithKey = entries.stream().filter(BibEntry::hasCitationKey).toList();
        if (entriesWithKey.isEmpty()) {
            this.dialogService.notify(Localization.lang("None of the selected entries have citation keys.", new Object[0]));
            return;
        }
        for (BibEntry entry : entriesWithKey) {
            String url;
            String key = entry.getCitationKey().orElse("");
            if (LOGGER.isDebugEnabled() && key.isEmpty()) {
                LOGGER.debug("entry {} had no citation key, but it should have had one", (Object)entry);
            }
            keyAndLink.append((url = entry.getField(StandardField.URL).orElse("")).isEmpty() ? key : "<a href=\"%s\">%s</a>".formatted(url, key));
            keyAndLink.append(OS.NEWLINE);
            fallbackString.append(url.isEmpty() ? key : "%s - %s".formatted(key, url));
            fallbackString.append(OS.NEWLINE);
        }
        this.clipBoardManager.setHtmlContent(keyAndLink.toString(), fallbackString.toString());
        if (entriesWithKey.size() == entries.size()) {
            this.dialogService.notify(Localization.lang("Copied '%0' to clipboard.", JabRefDialogService.shortenDialogMessage(keyAndLink.toString())));
        } else {
            this.dialogService.notify(Localization.lang("Warning: %0 out of %1 entries have undefined citation key.", Long.toString(entries.size() - entriesWithKey.size()), Integer.toString(entries.size())));
        }
    }
}

