/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.edit;

import com.airhacks.afterburner.injection.Injector;
import java.util.List;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import org.jabref.gui.DialogService;
import org.jabref.gui.StateManager;
import org.jabref.gui.actions.ActionHelper;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.edit.ManageKeywordsDialog;
import org.jabref.gui.util.BindingsHelper;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.BibEntry;

public class ManageKeywordsAction
extends SimpleCommand {
    private final StateManager stateManager;

    public ManageKeywordsAction(StateManager stateManager) {
        this.stateManager = stateManager;
        this.executable.bind((ObservableValue)ActionHelper.needsDatabase(stateManager).and((ObservableBooleanValue)ActionHelper.needsEntriesSelected(stateManager)));
        this.statusMessage.bind(BindingsHelper.ifThenElse((ObservableValue<Boolean>)this.executable, "", Localization.lang("Select at least one entry to manage keywords.", new Object[0])));
    }

    public void execute() {
        DialogService dialogService = (DialogService)Injector.instantiateModelOrService(DialogService.class);
        dialogService.showCustomDialogAndWait(new ManageKeywordsDialog((List<BibEntry>)this.stateManager.getSelectedEntries()));
    }
}

