/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.edit.automaticfiededitor;

import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.swing.undo.UndoManager;
import org.jabref.gui.AbstractViewModel;
import org.jabref.gui.StateManager;
import org.jabref.gui.edit.automaticfiededitor.AutomaticFieldEditorTab;
import org.jabref.gui.edit.automaticfiededitor.copyormovecontent.CopyOrMoveFieldContentTabView;
import org.jabref.gui.edit.automaticfiededitor.editfieldcontent.EditFieldContentTabView;
import org.jabref.gui.edit.automaticfiededitor.renamefield.RenameFieldTabView;
import org.jabref.gui.undo.NamedCompound;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.BibEntry;

public class AutomaticFieldEditorViewModel
extends AbstractViewModel {
    public static final String NAMED_COMPOUND_EDITS = "EDIT_FIELDS";
    private final ObservableList<AutomaticFieldEditorTab> fieldEditorTabs = FXCollections.observableArrayList();
    private final NamedCompound dialogEdits = new NamedCompound("EDIT_FIELDS");
    private final UndoManager undoManager;

    public AutomaticFieldEditorViewModel(List<BibEntry> selectedEntries, BibDatabase database, UndoManager undoManager, StateManager stateManager) {
        this.undoManager = undoManager;
        this.fieldEditorTabs.addAll((Object[])new AutomaticFieldEditorTab[]{new EditFieldContentTabView(database, stateManager), new CopyOrMoveFieldContentTabView(database, stateManager), new RenameFieldTabView(database, stateManager)});
    }

    public NamedCompound getDialogEdits() {
        return this.dialogEdits;
    }

    public ObservableList<AutomaticFieldEditorTab> getFieldEditorTabs() {
        return this.fieldEditorTabs;
    }

    public void saveChanges() {
        this.dialogEdits.end();
        this.undoManager.addEdit(this.dialogEdits);
    }

    public void cancelChanges() {
        this.dialogEdits.end();
        this.dialogEdits.undo();
    }
}

