/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.edit.automaticfiededitor.renamefield;

import de.saxsys.mvvmfx.utils.validation.FunctionBasedValidator;
import de.saxsys.mvvmfx.utils.validation.ValidationMessage;
import de.saxsys.mvvmfx.utils.validation.ValidationStatus;
import de.saxsys.mvvmfx.utils.validation.Validator;
import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import org.jabref.gui.StateManager;
import org.jabref.gui.edit.automaticfiededitor.AbstractAutomaticFieldEditorTabViewModel;
import org.jabref.gui.edit.automaticfiededitor.LastAutomaticFieldEditorEdit;
import org.jabref.gui.edit.automaticfiededitor.MoveFieldValueAction;
import org.jabref.gui.undo.NamedCompound;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.FieldFactory;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.strings.StringUtil;

public class RenameFieldViewModel
extends AbstractAutomaticFieldEditorTabViewModel {
    public static final int TAB_INDEX = 2;
    private final StringProperty newFieldName = new SimpleStringProperty("");
    private final ObjectProperty<Field> selectedField = new SimpleObjectProperty((Object)StandardField.AUTHOR);
    private final List<BibEntry> selectedEntries;
    private final Validator fieldValidator;
    private final Validator fieldNameValidator;
    private final BooleanBinding canRename;

    public RenameFieldViewModel(List<BibEntry> selectedEntries, BibDatabase database, StateManager stateManager) {
        super(database, stateManager);
        this.selectedEntries = selectedEntries;
        this.fieldValidator = new FunctionBasedValidator(this.selectedField, field -> StringUtil.isNotBlank(field.getName()), ValidationMessage.error((String)"Field cannot be empty"));
        this.fieldNameValidator = new FunctionBasedValidator((ObservableValue)this.newFieldName, fieldName -> {
            if (StringUtil.isBlank(fieldName)) {
                return ValidationMessage.error((String)"Field name cannot be empty");
            }
            if (StringUtil.containsWhitespace(fieldName)) {
                return ValidationMessage.error((String)"Field name cannot have whitespace characters");
            }
            return null;
        });
        this.canRename = Bindings.and((ObservableBooleanValue)this.fieldValidationStatus().validProperty(), (ObservableBooleanValue)this.fieldNameValidationStatus().validProperty());
    }

    public ValidationStatus fieldValidationStatus() {
        return this.fieldValidator.getValidationStatus();
    }

    public ValidationStatus fieldNameValidationStatus() {
        return this.fieldNameValidator.getValidationStatus();
    }

    public BooleanBinding canRenameProperty() {
        return this.canRename;
    }

    public String getNewFieldName() {
        return (String)this.newFieldName.get();
    }

    public StringProperty newFieldNameProperty() {
        return this.newFieldName;
    }

    public void setNewFieldName(String newName) {
        this.newFieldNameProperty().set((Object)newName);
    }

    public Field getSelectedField() {
        return (Field)this.selectedField.get();
    }

    public ObjectProperty<Field> selectedFieldProperty() {
        return this.selectedField;
    }

    public void selectField(Field field) {
        this.selectedFieldProperty().set((Object)field);
    }

    public void renameField() {
        NamedCompound renameEdit = new NamedCompound("RENAME_EDIT");
        int affectedEntriesCount = 0;
        if (this.fieldNameValidationStatus().isValid()) {
            affectedEntriesCount = new MoveFieldValueAction((Field)this.selectedField.get(), FieldFactory.parseField((String)this.newFieldName.get()), this.selectedEntries, renameEdit, false).executeAndGetAffectedEntriesCount();
            if (renameEdit.hasEdits()) {
                renameEdit.end();
            }
        }
        this.stateManager.setLastAutomaticFieldEditorEdit(new LastAutomaticFieldEditorEdit(affectedEntriesCount, 2, renameEdit));
    }
}

