/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.entryeditor;

import com.tobiasdiez.easybind.EasyBind;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.SequencedSet;
import java.util.stream.Collectors;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Tooltip;
import javax.swing.undo.UndoManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.StateManager;
import org.jabref.gui.autocompleter.SuggestionProviders;
import org.jabref.gui.entryeditor.FieldsEditorTab;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.theme.ThemeManager;
import org.jabref.gui.undo.RedoAction;
import org.jabref.gui.undo.UndoAction;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.journals.JournalAbbreviationRepository;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.pdf.search.IndexingTaskManager;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.database.BibDatabaseMode;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.BibEntryType;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.model.entry.field.Field;
import org.jabref.preferences.PreferencesService;

public class DeprecatedFieldsTab
extends FieldsEditorTab {
    public static final String NAME = "Deprecated fields";
    private final BibEntryTypesManager entryTypesManager;

    public DeprecatedFieldsTab(BibDatabaseContext databaseContext, SuggestionProviders suggestionProviders, UndoManager undoManager, UndoAction undoAction, RedoAction redoAction, DialogService dialogService, PreferencesService preferences, StateManager stateManager, ThemeManager themeManager, IndexingTaskManager indexingTaskManager, BibEntryTypesManager entryTypesManager, TaskExecutor taskExecutor, JournalAbbreviationRepository journalAbbreviationRepository) {
        super(false, databaseContext, suggestionProviders, undoManager, undoAction, redoAction, dialogService, preferences, stateManager, themeManager, taskExecutor, journalAbbreviationRepository, indexingTaskManager);
        this.entryTypesManager = entryTypesManager;
        this.setText(Localization.lang(NAME, new Object[0]));
        EasyBind.subscribe((ObservableValue)preferences.getWorkspacePreferences().showAdvancedHintsProperty(), advancedHints -> {
            if (advancedHints.booleanValue()) {
                this.setTooltip(new Tooltip(Localization.lang("Shows fields having a successor in biblatex.\nFor instance, the publication month should be part of the date field.\nUse the Cleanup Entries functionality to convert the entry to biblatex.", new Object[0])));
            } else {
                this.setTooltip(new Tooltip(Localization.lang("Shows fields having a successor in biblatex.", new Object[0])));
            }
        });
        this.setGraphic(IconTheme.JabRefIcons.OPTIONAL.getGraphicNode());
    }

    @Override
    protected SequencedSet<Field> determineFieldsToShow(BibEntry entry) {
        BibDatabaseMode mode = this.databaseContext.getMode();
        Optional<BibEntryType> entryType = this.entryTypesManager.enrich(entry.getType(), mode);
        if (entryType.isPresent()) {
            return entryType.get().getDeprecatedFields(mode).stream().filter(field -> !entry.getField((Field)field).isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        return new LinkedHashSet<Field>();
    }
}

