/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.entryeditor;

import com.airhacks.afterburner.views.ViewLoader;
import com.tobiasdiez.easybind.EasyBind;
import com.tobiasdiez.easybind.Subscription;
import jakarta.inject.Inject;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.input.DataFormat;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.BorderPane;
import org.jabref.gui.DialogService;
import org.jabref.gui.LibraryTab;
import org.jabref.gui.StateManager;
import org.jabref.gui.citationkeypattern.GenerateCitationKeySingleAction;
import org.jabref.gui.cleanup.CleanupSingleAction;
import org.jabref.gui.entryeditor.CommentsTab;
import org.jabref.gui.entryeditor.DeprecatedFieldsTab;
import org.jabref.gui.entryeditor.DetailOptionalFieldsTab;
import org.jabref.gui.entryeditor.EntryEditorPreferences;
import org.jabref.gui.entryeditor.EntryEditorTab;
import org.jabref.gui.entryeditor.FieldsEditorTab;
import org.jabref.gui.entryeditor.ImportantOptionalFieldsTab;
import org.jabref.gui.entryeditor.LatexCitationsTab;
import org.jabref.gui.entryeditor.MathSciNetTab;
import org.jabref.gui.entryeditor.OffersPreview;
import org.jabref.gui.entryeditor.OtherFieldsTab;
import org.jabref.gui.entryeditor.PreviewTab;
import org.jabref.gui.entryeditor.RelatedArticlesTab;
import org.jabref.gui.entryeditor.RequiredFieldsTab;
import org.jabref.gui.entryeditor.SciteTab;
import org.jabref.gui.entryeditor.SourceTab;
import org.jabref.gui.entryeditor.UserDefinedFieldsTab;
import org.jabref.gui.entryeditor.citationrelationtab.CitationRelationsTab;
import org.jabref.gui.entryeditor.fileannotationtab.FileAnnotationTab;
import org.jabref.gui.entryeditor.fileannotationtab.FulltextSearchResultsTab;
import org.jabref.gui.externalfiles.ExternalFilesEntryLinker;
import org.jabref.gui.help.HelpAction;
import org.jabref.gui.importer.GrobidOptInDialogHelper;
import org.jabref.gui.keyboard.KeyBinding;
import org.jabref.gui.keyboard.KeyBindingRepository;
import org.jabref.gui.menus.ChangeEntryTypeMenu;
import org.jabref.gui.mergeentries.FetchAndMergeEntry;
import org.jabref.gui.theme.ThemeManager;
import org.jabref.gui.undo.CountingUndoManager;
import org.jabref.gui.undo.RedoAction;
import org.jabref.gui.undo.UndoAction;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.gui.util.UiTaskExecutor;
import org.jabref.logic.bibtex.TypedBibEntry;
import org.jabref.logic.help.HelpFile;
import org.jabref.logic.importer.EntryBasedFetcher;
import org.jabref.logic.importer.WebFetchers;
import org.jabref.logic.importer.fileformat.PdfMergeMetadataImporter;
import org.jabref.logic.journals.JournalAbbreviationRepository;
import org.jabref.logic.util.BuildInfo;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.model.entry.field.Field;
import org.jabref.model.util.DirectoryMonitorManager;
import org.jabref.model.util.FileUpdateMonitor;
import org.jabref.preferences.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntryEditor
extends BorderPane {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntryEditor.class);
    private final LibraryTab libraryTab;
    private final BibDatabaseContext databaseContext;
    private final EntryEditorPreferences entryEditorPreferences;
    private final ExternalFilesEntryLinker fileLinker;
    private final DirectoryMonitorManager directoryMonitorManager;
    private final UndoAction undoAction;
    private final RedoAction redoAction;
    private Subscription typeSubscription;
    private BibEntry currentlyEditedEntry;
    private SourceTab sourceTab;
    @FXML
    private TabPane tabbed;
    @FXML
    private Button typeChangeButton;
    @FXML
    private Button fetcherButton;
    @FXML
    private Label typeLabel;
    @Inject
    private BuildInfo buildInfo;
    @Inject
    private DialogService dialogService;
    @Inject
    private TaskExecutor taskExecutor;
    @Inject
    private PreferencesService preferencesService;
    @Inject
    private StateManager stateManager;
    @Inject
    private ThemeManager themeManager;
    @Inject
    private FileUpdateMonitor fileMonitor;
    @Inject
    private CountingUndoManager undoManager;
    @Inject
    private BibEntryTypesManager bibEntryTypesManager;
    @Inject
    private KeyBindingRepository keyBindingRepository;
    @Inject
    private JournalAbbreviationRepository journalAbbreviationRepository;
    private final List<EntryEditorTab> allPossibleTabs;
    private final Collection<OffersPreview> previewTabs;

    public EntryEditor(LibraryTab libraryTab, UndoAction undoAction, RedoAction redoAction) {
        this.libraryTab = libraryTab;
        this.databaseContext = libraryTab.getBibDatabaseContext();
        this.directoryMonitorManager = libraryTab.getDirectoryMonitorManager();
        this.undoAction = undoAction;
        this.redoAction = redoAction;
        ViewLoader.view((Object)((Object)this)).root((Object)this).load();
        this.entryEditorPreferences = this.preferencesService.getEntryEditorPreferences();
        this.fileLinker = new ExternalFilesEntryLinker(this.preferencesService.getFilePreferences(), this.databaseContext, this.dialogService);
        this.setupKeyBindings();
        this.allPossibleTabs = this.createTabs();
        this.previewTabs = this.allPossibleTabs.stream().filter(OffersPreview.class::isInstance).map(OffersPreview.class::cast).toList();
        this.setupDragAndDrop(libraryTab);
        EasyBind.subscribe((ObservableValue)this.tabbed.getSelectionModel().selectedItemProperty(), tab -> {
            EntryEditorTab activeTab = (EntryEditorTab)((Object)tab);
            if (activeTab != null) {
                activeTab.notifyAboutFocus(this.currentlyEditedEntry);
            }
        });
        EasyBind.listen((ObservableValue)this.preferencesService.getPreviewPreferences().showPreviewAsExtraTabProperty(), (obs, oldValue, newValue) -> this.adaptVisibleTabs());
    }

    private void setupDragAndDrop(LibraryTab libraryTab) {
        this.setOnDragOver(event -> {
            if (event.getDragboard().hasFiles()) {
                event.acceptTransferModes(new TransferMode[]{TransferMode.COPY, TransferMode.MOVE, TransferMode.LINK});
            }
            event.consume();
        });
        this.setOnDragDropped(event -> {
            BibEntry entry = this.getCurrentlyEditedEntry();
            boolean success = false;
            if (event.getDragboard().hasContent(DataFormat.FILES)) {
                List<Path> draggedFiles = event.getDragboard().getFiles().stream().map(File::toPath).collect(Collectors.toList());
                switch (event.getTransferMode()) {
                    case COPY: {
                        LOGGER.debug("Mode COPY");
                        this.fileLinker.copyFilesToFileDirAndAddToEntry(entry, draggedFiles, libraryTab.getIndexingTaskManager());
                        break;
                    }
                    case MOVE: {
                        LOGGER.debug("Mode MOVE");
                        this.fileLinker.moveFilesToFileDirRenameAndAddToEntry(entry, draggedFiles, libraryTab.getIndexingTaskManager());
                        break;
                    }
                    case LINK: {
                        LOGGER.debug("Mode LINK");
                        this.fileLinker.addFilesToEntry(entry, draggedFiles);
                    }
                }
                success = true;
            }
            event.setDropCompleted(success);
            event.consume();
        });
    }

    private void setupKeyBindings() {
        this.addEventHandler(KeyEvent.KEY_PRESSED, event -> {
            Optional<KeyBinding> keyBinding = this.keyBindingRepository.mapToKeyBinding((KeyEvent)event);
            if (keyBinding.isPresent()) {
                switch (keyBinding.get()) {
                    case ENTRY_EDITOR_NEXT_PANEL: 
                    case ENTRY_EDITOR_NEXT_PANEL_2: {
                        this.tabbed.getSelectionModel().selectNext();
                        event.consume();
                        break;
                    }
                    case ENTRY_EDITOR_PREVIOUS_PANEL: 
                    case ENTRY_EDITOR_PREVIOUS_PANEL_2: {
                        this.tabbed.getSelectionModel().selectPrevious();
                        event.consume();
                        break;
                    }
                    case ENTRY_EDITOR_NEXT_ENTRY: {
                        this.libraryTab.selectNextEntry();
                        event.consume();
                        break;
                    }
                    case ENTRY_EDITOR_PREVIOUS_ENTRY: {
                        this.libraryTab.selectPreviousEntry();
                        event.consume();
                        break;
                    }
                    case HELP: {
                        new HelpAction(HelpFile.ENTRY_EDITOR, this.dialogService, this.preferencesService.getFilePreferences()).execute();
                        event.consume();
                        break;
                    }
                    case CLOSE: {
                        this.tabbed.requestFocus();
                        break;
                    }
                    case OPEN_CLOSE_ENTRY_EDITOR: {
                        this.close();
                        event.consume();
                        break;
                    }
                }
            }
        });
    }

    @FXML
    public void close() {
        this.libraryTab.entryEditorClosing();
    }

    @FXML
    private void deleteEntry() {
        this.libraryTab.delete(this.currentlyEditedEntry);
    }

    @FXML
    void generateCiteKeyButton() {
        GenerateCitationKeySingleAction action = new GenerateCitationKeySingleAction(this.getCurrentlyEditedEntry(), this.databaseContext, this.dialogService, this.preferencesService, this.undoManager);
        action.execute();
    }

    @FXML
    void generateCleanupButton() {
        CleanupSingleAction action = new CleanupSingleAction(this.getCurrentlyEditedEntry(), this.preferencesService, this.dialogService, this.stateManager, this.undoManager);
        action.execute();
    }

    @FXML
    private void navigateToPreviousEntry() {
        this.libraryTab.selectPreviousEntry();
    }

    @FXML
    private void navigateToNextEntry() {
        this.libraryTab.selectNextEntry();
    }

    private List<EntryEditorTab> createTabs() {
        LinkedList<EntryEditorTab> tabs = new LinkedList<EntryEditorTab>();
        tabs.add(new PreviewTab(this.databaseContext, this.dialogService, this.preferencesService, this.stateManager, this.themeManager, this.libraryTab.getIndexingTaskManager(), this.taskExecutor));
        tabs.add(new RequiredFieldsTab(this.databaseContext, this.libraryTab.getSuggestionProviders(), this.undoManager, this.undoAction, this.redoAction, this.dialogService, this.preferencesService, this.stateManager, this.themeManager, this.libraryTab.getIndexingTaskManager(), this.bibEntryTypesManager, this.taskExecutor, this.journalAbbreviationRepository));
        tabs.add(new ImportantOptionalFieldsTab(this.databaseContext, this.libraryTab.getSuggestionProviders(), this.undoManager, this.undoAction, this.redoAction, this.dialogService, this.preferencesService, this.stateManager, this.themeManager, this.libraryTab.getIndexingTaskManager(), this.bibEntryTypesManager, this.taskExecutor, this.journalAbbreviationRepository));
        tabs.add(new DetailOptionalFieldsTab(this.databaseContext, this.libraryTab.getSuggestionProviders(), this.undoManager, this.undoAction, this.redoAction, this.dialogService, this.preferencesService, this.stateManager, this.themeManager, this.libraryTab.getIndexingTaskManager(), this.bibEntryTypesManager, this.taskExecutor, this.journalAbbreviationRepository));
        tabs.add(new DeprecatedFieldsTab(this.databaseContext, this.libraryTab.getSuggestionProviders(), this.undoManager, this.undoAction, this.redoAction, this.dialogService, this.preferencesService, this.stateManager, this.themeManager, this.libraryTab.getIndexingTaskManager(), this.bibEntryTypesManager, this.taskExecutor, this.journalAbbreviationRepository));
        tabs.add(new OtherFieldsTab(this.databaseContext, this.libraryTab.getSuggestionProviders(), this.undoManager, this.undoAction, this.redoAction, this.dialogService, this.preferencesService, this.stateManager, this.themeManager, this.libraryTab.getIndexingTaskManager(), this.bibEntryTypesManager, this.taskExecutor, this.journalAbbreviationRepository));
        tabs.add(new CommentsTab(this.preferencesService, this.databaseContext, this.libraryTab.getSuggestionProviders(), this.undoManager, this.undoAction, this.redoAction, this.dialogService, this.stateManager, this.themeManager, this.libraryTab.getIndexingTaskManager(), this.taskExecutor, this.journalAbbreviationRepository));
        Map<String, Set<Field>> entryEditorTabList = this.getAdditionalUserConfiguredTabs();
        for (Map.Entry<String, Set<Field>> tab : entryEditorTabList.entrySet()) {
            tabs.add(new UserDefinedFieldsTab(tab.getKey(), tab.getValue(), this.databaseContext, this.libraryTab.getSuggestionProviders(), this.undoManager, this.undoAction, this.redoAction, this.dialogService, this.preferencesService, this.stateManager, this.themeManager, this.libraryTab.getIndexingTaskManager(), this.taskExecutor, this.journalAbbreviationRepository));
        }
        tabs.add(new MathSciNetTab());
        tabs.add(new FileAnnotationTab(this.libraryTab.getAnnotationCache()));
        tabs.add(new SciteTab(this.preferencesService, this.taskExecutor, this.dialogService));
        tabs.add(new CitationRelationsTab(this.dialogService, this.databaseContext, this.undoManager, this.stateManager, this.fileMonitor, this.preferencesService, this.libraryTab, this.taskExecutor));
        tabs.add(new RelatedArticlesTab(this.buildInfo, this.databaseContext, this.preferencesService, this.dialogService, this.taskExecutor));
        this.sourceTab = new SourceTab(this.databaseContext, this.undoManager, this.preferencesService.getFieldPreferences(), this.preferencesService.getImportFormatPreferences(), this.fileMonitor, this.dialogService, this.stateManager, this.bibEntryTypesManager, this.keyBindingRepository);
        tabs.add(this.sourceTab);
        tabs.add(new LatexCitationsTab(this.databaseContext, this.preferencesService, this.dialogService, this.directoryMonitorManager));
        tabs.add(new FulltextSearchResultsTab(this.stateManager, this.preferencesService, this.dialogService, this.taskExecutor));
        return tabs;
    }

    private Map<String, Set<Field>> getAdditionalUserConfiguredTabs() {
        HashMap<String, Set<Field>> entryEditorTabList = new HashMap<String, Set<Field>>((Map<String, Set<Field>>)this.entryEditorPreferences.getEntryEditorTabs());
        entryEditorTabList.remove("Preview");
        entryEditorTabList.remove("Required fields");
        entryEditorTabList.remove("Optional fields");
        entryEditorTabList.remove("Optional fields 2");
        entryEditorTabList.remove("Deprecated fields");
        entryEditorTabList.remove("Other fields");
        entryEditorTabList.remove("Comments");
        entryEditorTabList.remove("MathSciNet Review");
        entryEditorTabList.remove("File annotations");
        entryEditorTabList.remove("Citation information");
        entryEditorTabList.remove("Citation relations");
        entryEditorTabList.remove("Related articles");
        entryEditorTabList.remove("LaTeX Citations");
        entryEditorTabList.remove("Search results");
        return entryEditorTabList;
    }

    private void adaptVisibleTabs() {
        List<EntryEditorTab> toBeRemoved = this.allPossibleTabs.stream().filter(tab -> !tab.shouldShow(this.currentlyEditedEntry)).toList();
        this.tabbed.getTabs().removeAll(toBeRemoved);
        List visibleTabs = this.allPossibleTabs.stream().filter(tab -> tab.shouldShow(this.currentlyEditedEntry)).collect(Collectors.toList());
        for (int i = 0; i < visibleTabs.size(); ++i) {
            Tab toBeAdded = (Tab)visibleTabs.get(i);
            Tab shown = null;
            if (i < this.tabbed.getTabs().size()) {
                shown = (Tab)this.tabbed.getTabs().get(i);
            }
            if (toBeAdded.equals(shown)) continue;
            this.tabbed.getTabs().add(i, (Object)toBeAdded);
        }
    }

    public BibEntry getCurrentlyEditedEntry() {
        return this.currentlyEditedEntry;
    }

    public void setCurrentlyEditedEntry(BibEntry currentlyEditedEntry) {
        this.currentlyEditedEntry = Objects.requireNonNull(currentlyEditedEntry);
        if (this.typeSubscription != null) {
            this.typeSubscription.unsubscribe();
        }
        this.typeSubscription = EasyBind.subscribe(this.currentlyEditedEntry.typeProperty(), type -> {
            this.typeLabel.setText(new TypedBibEntry(currentlyEditedEntry, this.databaseContext.getMode()).getTypeForDisplay());
            this.adaptVisibleTabs();
            this.getSelectedTab().notifyAboutFocus(currentlyEditedEntry);
        });
        this.adaptVisibleTabs();
        this.setupToolBar();
        if (this.entryEditorPreferences.showSourceTabByDefault()) {
            this.tabbed.getSelectionModel().select((Object)this.sourceTab);
        }
        this.getSelectedTab().notifyAboutFocus(currentlyEditedEntry);
    }

    private EntryEditorTab getSelectedTab() {
        return (EntryEditorTab)((Object)this.tabbed.getSelectionModel().getSelectedItem());
    }

    private void setupToolBar() {
        TypedBibEntry typedEntry = new TypedBibEntry(this.currentlyEditedEntry, this.databaseContext.getMode());
        this.typeLabel.setText(typedEntry.getTypeForDisplay());
        ContextMenu typeMenu = new ChangeEntryTypeMenu(Collections.singletonList(this.currentlyEditedEntry), this.databaseContext, this.undoManager, this.bibEntryTypesManager).asContextMenu();
        this.typeLabel.setOnMouseClicked(event -> typeMenu.show((Node)this.typeLabel, Side.RIGHT, 0.0, 0.0));
        this.typeChangeButton.setOnMouseClicked(event -> typeMenu.show((Node)this.typeChangeButton, Side.RIGHT, 0.0, 0.0));
        ContextMenu fetcherMenu = new ContextMenu();
        SortedSet<EntryBasedFetcher> entryBasedFetchers = WebFetchers.getEntryBasedFetchers(this.preferencesService.getImporterPreferences(), this.preferencesService.getImportFormatPreferences(), this.preferencesService.getFilePreferences(), this.databaseContext);
        for (EntryBasedFetcher fetcher : entryBasedFetchers) {
            MenuItem fetcherMenuItem = new MenuItem(fetcher.getName());
            if (fetcher instanceof PdfMergeMetadataImporter.EntryBasedFetcherWrapper) {
                fetcherMenuItem.setOnAction(event -> {
                    GrobidOptInDialogHelper.showAndWaitIfUserIsUndecided(this.dialogService, this.preferencesService.getGrobidPreferences());
                    PdfMergeMetadataImporter.EntryBasedFetcherWrapper pdfMergeMetadataImporter = new PdfMergeMetadataImporter.EntryBasedFetcherWrapper(this.preferencesService.getImportFormatPreferences(), this.preferencesService.getFilePreferences(), this.databaseContext);
                    this.fetchAndMerge(pdfMergeMetadataImporter);
                });
            } else {
                fetcherMenuItem.setOnAction(event -> this.fetchAndMerge(fetcher));
            }
            fetcherMenu.getItems().add((Object)fetcherMenuItem);
        }
        this.fetcherButton.setOnMouseClicked(event -> fetcherMenu.show((Node)this.fetcherButton, Side.RIGHT, 0.0, 0.0));
    }

    private void fetchAndMerge(EntryBasedFetcher fetcher) {
        new FetchAndMergeEntry(this.libraryTab.getBibDatabaseContext(), this.taskExecutor, this.preferencesService, this.dialogService, this.undoManager).fetchAndMerge(this.currentlyEditedEntry, fetcher);
    }

    public void setFocusToField(Field field) {
        UiTaskExecutor.runInJavaFXThread(() -> {
            for (Tab tab : this.tabbed.getTabs()) {
                FieldsEditorTab fieldsEditorTab;
                if (!(tab instanceof FieldsEditorTab) || !(fieldsEditorTab = (FieldsEditorTab)tab).getShownFields().contains(field)) continue;
                this.tabbed.getSelectionModel().select((Object)tab);
                fieldsEditorTab.requestFocus(field);
            }
        });
    }

    public void nextPreviewStyle() {
        this.previewTabs.forEach(OffersPreview::nextPreviewStyle);
    }

    public void previousPreviewStyle() {
        this.previewTabs.forEach(OffersPreview::previousPreviewStyle);
    }
}

