/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.entryeditor;

import com.tobiasdiez.easybind.EasyBind;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import org.jabref.gui.DialogService;
import org.jabref.gui.entryeditor.EntryEditorTab;
import org.jabref.gui.entryeditor.LatexCitationsTabViewModel;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.texparser.CitationsDisplay;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.util.DirectoryMonitorManager;
import org.jabref.preferences.PreferencesService;

public class LatexCitationsTab
extends EntryEditorTab {
    public static final String NAME = "LaTeX Citations";
    private final LatexCitationsTabViewModel viewModel;
    private final GridPane searchPane;
    private final ProgressIndicator progressIndicator;
    private final CitationsDisplay citationsDisplay;

    public LatexCitationsTab(BibDatabaseContext databaseContext, PreferencesService preferencesService, DialogService dialogService, DirectoryMonitorManager directoryMonitorManager) {
        this.viewModel = new LatexCitationsTabViewModel(databaseContext, preferencesService, dialogService, directoryMonitorManager);
        this.searchPane = new GridPane();
        this.progressIndicator = new ProgressIndicator();
        this.citationsDisplay = new CitationsDisplay();
        this.setText(Localization.lang(NAME, new Object[0]));
        this.setTooltip(new Tooltip(Localization.lang("Search citations for this entry in LaTeX files", new Object[0])));
        this.setGraphic(IconTheme.JabRefIcons.LATEX_CITATIONS.getGraphicNode());
        this.setSearchPane();
    }

    private void setSearchPane() {
        this.progressIndicator.setMaxSize(100.0, 100.0);
        this.citationsDisplay.basePathProperty().bindBidirectional(this.viewModel.directoryProperty());
        this.citationsDisplay.setItems(this.viewModel.getCitationList());
        RowConstraints mainRow = new RowConstraints();
        mainRow.setVgrow(Priority.ALWAYS);
        RowConstraints bottomRow = new RowConstraints(40.0);
        bottomRow.setVgrow(Priority.NEVER);
        ColumnConstraints column = new ColumnConstraints();
        column.setPercentWidth(100.0);
        column.setHalignment(HPos.CENTER);
        this.searchPane.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{column});
        this.searchPane.getRowConstraints().setAll((Object[])new RowConstraints[]{mainRow, bottomRow});
        this.searchPane.setId("citationsPane");
        this.setContent((Node)this.searchPane);
        HBox latexDirectoryBox = this.getLatexDirectoryBox();
        VBox citationsPane = this.getCitationsPane();
        VBox notFoundPane = this.getNotFoundPane();
        VBox errorPane = this.getErrorPane();
        EasyBind.subscribe(this.viewModel.statusProperty(), status -> {
            this.searchPane.getChildren().clear();
            switch (status) {
                case IN_PROGRESS: {
                    this.searchPane.add((Node)this.progressIndicator, 0, 0);
                    break;
                }
                case CITATIONS_FOUND: {
                    this.searchPane.add((Node)citationsPane, 0, 0);
                    break;
                }
                case NO_RESULTS: {
                    this.searchPane.add((Node)notFoundPane, 0, 0);
                    break;
                }
                case ERROR: {
                    this.searchPane.add((Node)errorPane, 0, 0);
                }
            }
            this.searchPane.add((Node)latexDirectoryBox, 0, 1);
        });
    }

    private HBox getLatexDirectoryBox() {
        Text latexDirectoryText = new Text(Localization.lang("Current search directory:", new Object[0]));
        Text latexDirectoryPath = new Text();
        latexDirectoryPath.textProperty().bind((ObservableValue)this.viewModel.directoryProperty().asString());
        latexDirectoryPath.setStyle("-fx-font-family:monospace;-fx-font-weight: bold;");
        Button latexDirectoryButton = new Button(Localization.lang("Set LaTeX file directory", new Object[0]));
        latexDirectoryButton.setGraphic(IconTheme.JabRefIcons.LATEX_FILE_DIRECTORY.getGraphicNode());
        latexDirectoryButton.setOnAction(event -> this.viewModel.setLatexDirectory());
        HBox latexDirectoryBox = new HBox(10.0, new Node[]{latexDirectoryText, latexDirectoryPath, latexDirectoryButton});
        latexDirectoryBox.setAlignment(Pos.CENTER);
        return latexDirectoryBox;
    }

    private VBox getCitationsPane() {
        VBox citationsBox = new VBox(30.0, new Node[]{this.citationsDisplay});
        VBox.setVgrow((Node)this.citationsDisplay, (Priority)Priority.ALWAYS);
        citationsBox.setStyle("-fx-padding: 0;");
        return citationsBox;
    }

    private VBox getNotFoundPane() {
        Label titleLabel = new Label(Localization.lang("No citations found", new Object[0]));
        titleLabel.getStyleClass().add((Object)"heading");
        Text notFoundText = new Text(Localization.lang("No LaTeX files containing this entry were found.", new Object[0]));
        notFoundText.getStyleClass().add((Object)"description");
        VBox notFoundBox = new VBox(30.0, new Node[]{titleLabel, notFoundText});
        notFoundBox.setStyle("-fx-padding: 30 0 0 30;");
        return notFoundBox;
    }

    private VBox getErrorPane() {
        Label titleLabel = new Label(Localization.lang("Error", new Object[0]));
        titleLabel.setStyle("-fx-font-size: 1.5em;-fx-font-weight: bold;-fx-text-fill: -fx-accent;");
        Text errorMessageText = new Text();
        errorMessageText.textProperty().bind((ObservableValue)this.viewModel.searchErrorProperty());
        VBox errorMessageBox = new VBox(30.0, new Node[]{titleLabel, errorMessageText});
        errorMessageBox.setStyle("-fx-padding: 30 0 0 30;");
        return errorMessageBox;
    }

    @Override
    protected void bindToEntry(BibEntry entry) {
        this.viewModel.bindToEntry(entry);
    }

    @Override
    public boolean shouldShow(BibEntry entry) {
        return this.viewModel.shouldShow();
    }
}

