/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.entryeditor.citationrelationtab.semanticscholar;

import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jabref.gui.entryeditor.citationrelationtab.semanticscholar.AuthorResponse;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.types.StandardEntryType;

public class PaperDetails {
    private String paperId;
    private String title;
    private String year;
    @SerializedName(value="abstract")
    private String abstr;
    private String url;
    private int citationCount;
    private int referenceCount;
    private List<AuthorResponse> authors;
    private List<String> publicationTypes;
    private Map<String, String> externalIds;

    public String getPaperId() {
        return this.paperId;
    }

    public void setPaperId(String paperId) {
        this.paperId = paperId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getYear() {
        return this.year;
    }

    public void setYear(String year) {
        this.year = year;
    }

    public String getAbstract() {
        return this.abstr;
    }

    public void setAbstract(String abstr) {
        this.abstr = abstr;
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public int getCitationCount() {
        return this.citationCount;
    }

    public void setCitationCount(int citationCount) {
        this.citationCount = citationCount;
    }

    public int getReferenceCount() {
        return this.referenceCount;
    }

    public void setReferenceCount(int referenceCount) {
        this.referenceCount = referenceCount;
    }

    public List<AuthorResponse> getAuthors() {
        return this.authors;
    }

    public String getPublicationType() {
        if (this.publicationTypes == null || this.publicationTypes.isEmpty()) {
            return "Misc";
        }
        if (this.publicationTypes.contains("Conference")) {
            return "InProceedings";
        }
        if (this.publicationTypes.contains("JournalArticle")) {
            return "Article";
        }
        return switch (this.publicationTypes.getFirst()) {
            case "Review" -> "Misc";
            case "CaseReport" -> "Report";
            case "ClinicalTrial" -> "Report";
            case "Dataset" -> "Dataset";
            case "Editorial" -> "Misc";
            case "LettersAndComments" -> "Misc";
            case "MetaAnalysis" -> "Article";
            case "News" -> "Misc";
            case "Study" -> "Article";
            case "Book" -> "Book";
            case "BookSection" -> "InBook";
            default -> "Misc";
        };
    }

    public String getDOI() {
        if (this.externalIds != null) {
            if (this.externalIds.containsKey("DOI")) {
                return this.externalIds.get("DOI");
            }
            if (this.externalIds.containsKey("ArXiv")) {
                return "10.48550/arXiv." + this.externalIds.get("ArXiv");
            }
        }
        return "";
    }

    public BibEntry toBibEntry() {
        BibEntry bibEntry = new BibEntry();
        bibEntry.setField(StandardField.TITLE, this.getTitle());
        if (this.getYear() != null) {
            bibEntry.setField(StandardField.YEAR, this.getYear());
        }
        String authors = this.getAuthors().stream().map(AuthorResponse::getName).collect(Collectors.joining(" and "));
        bibEntry.setField(StandardField.AUTHOR, authors);
        bibEntry.setType(StandardEntryType.valueOf(this.getPublicationType()));
        if (this.getDOI() != null) {
            bibEntry.setField(StandardField.DOI, this.getDOI());
        }
        if (this.getURL() != null) {
            bibEntry.setField(StandardField.URL, this.getURL());
        }
        if (this.getAbstract() != null) {
            bibEntry.setField(StandardField.ABSTRACT, this.getAbstract());
        }
        return bibEntry;
    }

    public String toString() {
        return "PaperDetails{paperId='" + this.paperId + "', title='" + this.title + "', year='" + this.year + "', citationCount=" + this.citationCount + ", referenceCount=" + this.referenceCount + "}";
    }
}

