/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.exporter;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.DialogPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import org.jabref.gui.DialogService;
import org.jabref.gui.LibraryTab;
import org.jabref.gui.autosaveandbackup.AutosaveManager;
import org.jabref.gui.autosaveandbackup.BackupManager;
import org.jabref.gui.maintable.columns.MainTableColumn;
import org.jabref.gui.util.FileDialogConfiguration;
import org.jabref.logic.exporter.AtomicFileWriter;
import org.jabref.logic.exporter.BibDatabaseWriter;
import org.jabref.logic.exporter.BibWriter;
import org.jabref.logic.exporter.BibtexDatabaseWriter;
import org.jabref.logic.exporter.SaveException;
import org.jabref.logic.exporter.SelfContainedSaveConfiguration;
import org.jabref.logic.l10n.Encodings;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.pdf.search.PdfIndexerManager;
import org.jabref.logic.shared.DatabaseLocation;
import org.jabref.logic.shared.prefs.SharedDatabasePreferences;
import org.jabref.logic.util.StandardFileType;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.database.event.ChangePropagation;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.model.metadata.SaveOrder;
import org.jabref.model.metadata.SelfContainedSaveOrder;
import org.jabref.preferences.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaveDatabaseAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(SaveDatabaseAction.class);
    private final LibraryTab libraryTab;
    private final DialogService dialogService;
    private final PreferencesService preferences;
    private final BibEntryTypesManager entryTypesManager;

    public SaveDatabaseAction(LibraryTab libraryTab, DialogService dialogService, PreferencesService preferences, BibEntryTypesManager entryTypesManager) {
        this.libraryTab = libraryTab;
        this.dialogService = dialogService;
        this.preferences = preferences;
        this.entryTypesManager = entryTypesManager;
    }

    public boolean save() {
        return this.save(this.libraryTab.getBibDatabaseContext(), SaveDatabaseMode.NORMAL);
    }

    public boolean save(SaveDatabaseMode mode) {
        return this.save(this.libraryTab.getBibDatabaseContext(), mode);
    }

    public void saveAs() {
        this.askForSavePath().ifPresent(this::saveAs);
    }

    public boolean saveAs(Path file) {
        return this.saveAs(file, SaveDatabaseMode.NORMAL);
    }

    private SelfContainedSaveOrder getSaveOrder() {
        return this.libraryTab.getBibDatabaseContext().getMetaData().getSaveOrder().map(so -> {
            if (so.getOrderType() == SaveOrder.OrderType.TABLE) {
                ObservableList sortOrder = this.libraryTab.getMainTable().getSortOrder();
                return new SelfContainedSaveOrder(SaveOrder.OrderType.SPECIFIED, sortOrder.stream().filter(col -> col instanceof MainTableColumn).map(column -> ((MainTableColumn)((Object)((Object)column))).getModel()).flatMap(model -> model.getSortCriteria().stream()).toList());
            }
            return SelfContainedSaveOrder.of(so);
        }).orElse(SaveOrder.getDefaultSaveOrder());
    }

    public void saveSelectedAsPlain() {
        this.askForSavePath().ifPresent(path -> {
            try {
                this.saveDatabase((Path)path, true, StandardCharsets.UTF_8, BibDatabaseWriter.SaveType.PLAIN_BIBTEX, this.getSaveOrder());
                this.preferences.getGuiPreferences().getFileHistory().newFile((Path)path);
                this.dialogService.notify(Localization.lang("Saved selected to '%0'.", path.toString()));
            }
            catch (SaveException ex) {
                LOGGER.error("A problem occurred when trying to save the file", (Throwable)ex);
                this.dialogService.showErrorDialogAndWait(Localization.lang("Save library", new Object[0]), Localization.lang("Could not save file.", new Object[0]), ex);
            }
        });
    }

    boolean saveAs(Path file, SaveDatabaseMode mode) {
        boolean saveResult;
        BibDatabaseContext context = this.libraryTab.getBibDatabaseContext();
        Optional<Path> databasePath = context.getDatabasePath();
        if (databasePath.isPresent()) {
            AutosaveManager.shutdown(context);
            BackupManager.shutdown(context, this.preferences.getFilePreferences().getBackupDirectory(), this.preferences.getFilePreferences().shouldCreateBackup());
            PdfIndexerManager.shutdownIndexer(context);
        }
        if (context.getLocation() == DatabaseLocation.SHARED) {
            new SharedDatabasePreferences(context.getDatabase().generateSharedDatabaseID()).putAllDBMSConnectionProperties(context.getDBMSSynchronizer().getConnectionProperties());
        }
        if (saveResult = this.save(file, mode)) {
            context.setDatabasePath(file);
            this.libraryTab.updateTabTitle(false);
            this.libraryTab.resetChangeMonitor();
            this.libraryTab.installAutosaveManagerAndBackupManager();
            this.preferences.getGuiPreferences().getFileHistory().newFile(file);
        }
        return saveResult;
    }

    private Optional<Path> askForSavePath() {
        Path savePath;
        FileDialogConfiguration fileDialogConfiguration = new FileDialogConfiguration.Builder().addExtensionFilter(StandardFileType.BIBTEX_DB).withDefaultExtension(StandardFileType.BIBTEX_DB).withInitialDirectory(this.preferences.getFilePreferences().getWorkingDirectory()).build();
        Optional<Path> selectedPath = this.dialogService.showFileSaveDialog(fileDialogConfiguration);
        selectedPath.ifPresent(path -> this.preferences.getFilePreferences().setWorkingDirectory(path.getParent()));
        if (selectedPath.isPresent() && !(savePath = selectedPath.get()).getFileName().toString().toLowerCase().endsWith(".bib")) {
            if (!Files.notExists(savePath = Path.of(savePath.toString() + ".bib", new String[0]), new LinkOption[0]) && !this.dialogService.showConfirmationDialogAndWait(Localization.lang("Overwrite file", new Object[0]), Localization.lang("'%0' exists. Overwrite file?", savePath.getFileName()))) {
                return Optional.empty();
            }
            selectedPath = Optional.of(savePath);
        }
        return selectedPath;
    }

    private boolean save(BibDatabaseContext bibDatabaseContext, SaveDatabaseMode mode) {
        Optional<Path> databasePath = bibDatabaseContext.getDatabasePath();
        if (databasePath.isEmpty()) {
            Optional<Path> savePath = this.askForSavePath();
            return savePath.filter(path -> this.saveAs((Path)path, mode)).isPresent();
        }
        return this.save(databasePath.get(), mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean save(Path targetPath, SaveDatabaseMode mode) {
        if (mode == SaveDatabaseMode.NORMAL && this.libraryTab.getBibDatabaseContext().getEntries().size() > 2000) {
            this.dialogService.notify("%s...".formatted(Localization.lang("Saving library", new Object[0])));
        }
        LibraryTab libraryTab = this.libraryTab;
        synchronized (libraryTab) {
            if (this.libraryTab.isSaving()) {
                return true;
            }
            this.libraryTab.setSaving(true);
        }
        try {
            Charset encoding = this.libraryTab.getBibDatabaseContext().getMetaData().getEncoding().orElse(StandardCharsets.UTF_8);
            this.libraryTab.getBibDatabaseContext().getMetaData().setEncoding(encoding, ChangePropagation.DO_NOT_POST_EVENT);
            boolean success = this.saveDatabase(targetPath, false, encoding, BibDatabaseWriter.SaveType.WITH_JABREF_META_DATA, this.getSaveOrder());
            if (success) {
                this.libraryTab.getUndoManager().markUnchanged();
                this.libraryTab.resetChangedProperties();
            }
            this.dialogService.notify(Localization.lang("Library saved", new Object[0]));
            boolean bl = success;
            return bl;
        }
        catch (SaveException ex) {
            LOGGER.error("A problem occurred when trying to save the file %s".formatted(targetPath), (Throwable)ex);
            this.dialogService.showErrorDialogAndWait(Localization.lang("Save library", new Object[0]), Localization.lang("Could not save file.", new Object[0]), ex);
            boolean bl = false;
            return bl;
        }
        finally {
            this.libraryTab.setSaving(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveDatabase(Path file, boolean selectedOnly, Charset encoding, BibDatabaseWriter.SaveType saveType, SelfContainedSaveOrder saveOrder) throws SaveException {
        BibDatabaseContext bibDatabaseContext;
        SelfContainedSaveConfiguration saveConfiguration = new SelfContainedSaveConfiguration(saveOrder, (Boolean)false, saveType, (Boolean)this.preferences.getLibraryPreferences().shouldAlwaysReformatOnSave());
        BibDatabaseContext bibDatabaseContext2 = bibDatabaseContext = this.libraryTab.getBibDatabaseContext();
        synchronized (bibDatabaseContext2) {
            try (AtomicFileWriter fileWriter = new AtomicFileWriter(file, encoding, saveConfiguration.shouldMakeBackup());){
                BibWriter bibWriter = new BibWriter(fileWriter, bibDatabaseContext.getDatabase().getNewLineSeparator());
                BibtexDatabaseWriter databaseWriter = new BibtexDatabaseWriter(bibWriter, saveConfiguration, this.preferences.getFieldPreferences(), this.preferences.getCitationKeyPatternPreferences(), this.entryTypesManager);
                if (selectedOnly) {
                    databaseWriter.savePartOfDatabase(bibDatabaseContext, this.libraryTab.getSelectedEntries());
                } else {
                    databaseWriter.saveDatabase(bibDatabaseContext);
                }
                this.libraryTab.registerUndoableChanges(databaseWriter.getSaveActionsFieldChanges());
                if (fileWriter.hasEncodingProblems()) {
                    this.saveWithDifferentEncoding(file, selectedOnly, encoding, fileWriter.getEncodingProblems(), saveType, saveOrder);
                }
            }
            catch (UnsupportedCharsetException ex) {
                throw new SaveException(Localization.lang("Character encoding '%0' is not supported.", encoding.displayName()), ex);
            }
            catch (IOException ex) {
                throw new SaveException("Problems saving: " + String.valueOf(ex), ex);
            }
            return true;
        }
    }

    private void saveWithDifferentEncoding(Path file, boolean selectedOnly, Charset encoding, Set<Character> encodingProblems, BibDatabaseWriter.SaveType saveType, SelfContainedSaveOrder saveOrder) throws SaveException {
        Optional<Charset> newEncoding;
        DialogPane pane = new DialogPane();
        VBox vbox = new VBox();
        vbox.getChildren().addAll((Object[])new Node[]{new Text(Localization.lang("The chosen encoding '%0' could not encode the following characters:", encoding.displayName())), new Text(encodingProblems.stream().map(Object::toString).collect(Collectors.joining("."))), new Text(Localization.lang("What do you want to do?", new Object[0]))});
        pane.setContent((Node)vbox);
        ButtonType tryDifferentEncoding = new ButtonType(Localization.lang("Try different encoding", new Object[0]), ButtonBar.ButtonData.OTHER);
        ButtonType ignore = new ButtonType(Localization.lang("Ignore", new Object[0]), ButtonBar.ButtonData.APPLY);
        boolean saveWithDifferentEncoding = this.dialogService.showCustomDialogAndWait(Localization.lang("Save library", new Object[0]), pane, ignore, tryDifferentEncoding).filter(buttonType -> buttonType.equals(tryDifferentEncoding)).isPresent();
        if (saveWithDifferentEncoding && (newEncoding = this.dialogService.showChoiceDialogAndWait(Localization.lang("Save library", new Object[0]), Localization.lang("Select new encoding", new Object[0]), Localization.lang("Save library", new Object[0]), encoding, Encodings.getCharsets())).isPresent()) {
            this.libraryTab.getBibDatabaseContext().getMetaData().setEncoding(newEncoding.get(), ChangePropagation.DO_NOT_POST_EVENT);
            this.saveDatabase(file, selectedOnly, newEncoding.get(), saveType, saveOrder);
        }
    }

    public static enum SaveDatabaseMode {
        SILENT,
        NORMAL;

    }
}

