/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.exporter;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import org.jabref.gui.DialogService;
import org.jabref.gui.StateManager;
import org.jabref.gui.actions.ActionHelper;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.fieldeditors.WriteMetadataToSinglePdfAction;
import org.jabref.gui.util.BackgroundTask;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.bibtex.FieldPreferences;
import org.jabref.logic.journals.JournalAbbreviationRepository;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.io.FileUtil;
import org.jabref.logic.xmp.XmpPreferences;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.preferences.FilePreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteMetadataToLinkedPdfsAction
extends SimpleCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(WriteMetadataToLinkedPdfsAction.class);
    private final StateManager stateManager;
    private final BibEntryTypesManager entryTypesManager;
    private final FieldPreferences fieldPreferences;
    private final DialogService dialogService;
    private final TaskExecutor taskExecutor;
    private final FilePreferences filePreferences;
    private final XmpPreferences xmpPreferences;
    private final JournalAbbreviationRepository abbreviationRepository;

    public WriteMetadataToLinkedPdfsAction(DialogService dialogService, FieldPreferences fieldPreferences, FilePreferences filePreferences, XmpPreferences xmpPreferences, BibEntryTypesManager entryTypesManager, JournalAbbreviationRepository abbreviationRepository, TaskExecutor taskExecutor, StateManager stateManager) {
        this.stateManager = stateManager;
        this.entryTypesManager = entryTypesManager;
        this.fieldPreferences = fieldPreferences;
        this.dialogService = dialogService;
        this.taskExecutor = taskExecutor;
        this.filePreferences = filePreferences;
        this.xmpPreferences = xmpPreferences;
        this.abbreviationRepository = abbreviationRepository;
        this.executable.bind((ObservableValue)ActionHelper.needsDatabase(stateManager));
    }

    public void execute() {
        BibDatabaseContext databaseContext = this.stateManager.getActiveDatabase().get();
        if (this.stateManager.getActiveDatabase().isEmpty()) {
            return;
        }
        ObservableList<BibEntry> entries = this.stateManager.getSelectedEntries();
        if (entries.isEmpty()) {
            entries = databaseContext.getDatabase().getEntries();
            if (entries.isEmpty()) {
                LOGGER.warn("No entry selected for fulltext download.");
                this.dialogService.notify(Localization.lang("This operation requires one or more entries to be selected.", new Object[0]));
                return;
            }
            boolean confirm = this.dialogService.showConfirmationDialogAndWait(Localization.lang("Write metadata to PDF files", new Object[0]), Localization.lang("Write metadata for all PDFs in current library?", new Object[0]));
            if (!confirm) {
                return;
            }
        }
        this.dialogService.notify(Localization.lang("Writing metadata...", new Object[0]));
        new WriteMetaDataTask(databaseContext, (List<BibEntry>)entries, this.abbreviationRepository, this.entryTypesManager, this.fieldPreferences, this.filePreferences, this.xmpPreferences, this.stateManager, this.dialogService).executeWith(this.taskExecutor);
    }

    private static class WriteMetaDataTask
    extends BackgroundTask<Void> {
        private final BibDatabaseContext databaseContext;
        private final List<BibEntry> entries;
        private final JournalAbbreviationRepository abbreviationRepository;
        private final BibEntryTypesManager entryTypesManager;
        private final FieldPreferences fieldPreferences;
        private final FilePreferences filePreferences;
        private final XmpPreferences xmpPreferences;
        private final StateManager stateManager;
        private final DialogService dialogService;
        private final List<Path> failedWrittenFiles = new ArrayList<Path>();
        private int skipped = 0;
        private int entriesChanged = 0;
        private int errors = 0;

        public WriteMetaDataTask(BibDatabaseContext databaseContext, List<BibEntry> entries, JournalAbbreviationRepository abbreviationRepository, BibEntryTypesManager entryTypesManager, FieldPreferences fieldPreferences, FilePreferences filePreferences, XmpPreferences xmpPreferences, StateManager stateManager, DialogService dialogService) {
            this.databaseContext = databaseContext;
            this.entries = entries;
            this.abbreviationRepository = abbreviationRepository;
            this.entryTypesManager = entryTypesManager;
            this.fieldPreferences = fieldPreferences;
            this.filePreferences = filePreferences;
            this.xmpPreferences = xmpPreferences;
            this.stateManager = stateManager;
            this.dialogService = dialogService;
            this.updateMessage(Localization.lang("Writing metadata...", new Object[0]));
        }

        @Override
        protected Void call() throws Exception {
            if (this.stateManager.getActiveDatabase().isEmpty()) {
                return null;
            }
            for (int i = 0; i < this.entries.size(); ++i) {
                BibEntry entry = this.entries.get(i);
                this.updateProgress(i, this.entries.size());
                List<Path> files = entry.getFiles().stream().map(file -> file.findIn(this.stateManager.getActiveDatabase().get(), this.filePreferences)).filter(Optional::isPresent).map(Optional::get).filter(FileUtil::isPDFFile).toList();
                if (files.isEmpty()) {
                    LOGGER.debug("Skipped empty entry '{}'", (Object)entry.getCitationKey().orElse(entry.getAuthorTitleYear(16)));
                    ++this.skipped;
                } else {
                    for (Path file2 : files) {
                        this.updateMessage(Localization.lang("Writing metadata to %0", file2.getFileName()));
                        if (Files.exists(file2, new LinkOption[0])) {
                            try {
                                WriteMetadataToSinglePdfAction.writeMetadataToFile(file2, entry, this.databaseContext, this.abbreviationRepository, this.entryTypesManager, this.fieldPreferences, this.filePreferences, this.xmpPreferences);
                                ++this.entriesChanged;
                            }
                            catch (Exception e) {
                                LOGGER.error("Error while writing XMP data to pdf '{}'", (Object)file2, (Object)e);
                                this.failedWrittenFiles.add(file2);
                                ++this.errors;
                            }
                            continue;
                        }
                        LOGGER.debug("Skipped non existing pdf '{}'", (Object)file2);
                        ++this.skipped;
                    }
                }
                this.updateMessage(Localization.lang("Processing...", new Object[0]));
            }
            this.updateMessage(Localization.lang("Finished", new Object[0]));
            this.dialogService.notify(Localization.lang("Finished writing metadata for library %0 (%1 succeeded, %2 skipped, %3 errors).", this.databaseContext.getDatabasePath().map(Path::toString).orElse("undefined"), String.valueOf(this.entriesChanged), String.valueOf(this.skipped), String.valueOf(this.errors)));
            if (!this.failedWrittenFiles.isEmpty()) {
                LOGGER.error("Failed to write XMP data to PDFs:\n" + String.valueOf(this.failedWrittenFiles));
            }
            return null;
        }
    }
}

