/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.externalfiles;

import java.net.URL;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import org.jabref.gui.DialogService;
import org.jabref.gui.StateManager;
import org.jabref.gui.actions.ActionHelper;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.fieldeditors.LinkedFileViewModel;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.importer.FulltextFetchers;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.LinkedFile;
import org.jabref.preferences.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadFullTextAction
extends SimpleCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(DownloadFullTextAction.class);
    private static final int WARNING_LIMIT = 5;
    private final DialogService dialogService;
    private final StateManager stateManager;
    private final PreferencesService preferences;
    private final TaskExecutor taskExecutor;

    public DownloadFullTextAction(DialogService dialogService, StateManager stateManager, PreferencesService preferences, TaskExecutor taskExecutor) {
        this.dialogService = dialogService;
        this.stateManager = stateManager;
        this.preferences = preferences;
        this.taskExecutor = taskExecutor;
        this.executable.bind((ObservableValue)ActionHelper.needsEntriesSelected(stateManager));
    }

    public void execute() {
        boolean confirmDownload;
        if (this.stateManager.getActiveDatabase().isEmpty()) {
            return;
        }
        final ObservableList<BibEntry> entries = this.stateManager.getSelectedEntries();
        if (entries.isEmpty()) {
            LOGGER.debug("No entry selected for fulltext download.");
            return;
        }
        this.dialogService.notify(Localization.lang("Looking for full text document...", new Object[0]));
        if (entries.size() >= 5 && !(confirmDownload = this.dialogService.showConfirmationDialogAndWait(Localization.lang("Download full text documents", new Object[0]), Localization.lang("You are about to download full text documents for %0 entries.", String.valueOf(this.stateManager.getSelectedEntries().size())) + "\n" + Localization.lang("JabRef will send at least one request per entry to a publisher.", new Object[0]) + "\n" + Localization.lang("Do you still want to continue?", new Object[0]), Localization.lang("Download full text documents", new Object[0]), Localization.lang("Cancel", new Object[0])))) {
            this.dialogService.notify(Localization.lang("Operation canceled.", new Object[0]));
            return;
        }
        Task<Map<BibEntry, Optional<URL>>> findFullTextsTask = new Task<Map<BibEntry, Optional<URL>>>(){

            protected Map<BibEntry, Optional<URL>> call() {
                ConcurrentHashMap<BibEntry, Optional<URL>> downloads = new ConcurrentHashMap<BibEntry, Optional<URL>>();
                int count = 0;
                for (BibEntry entry : entries) {
                    FulltextFetchers fetchers = new FulltextFetchers(DownloadFullTextAction.this.preferences.getImportFormatPreferences(), DownloadFullTextAction.this.preferences.getImporterPreferences());
                    downloads.put(entry, fetchers.findFullTextPDF(entry));
                    this.updateProgress(++count, entries.size());
                }
                return downloads;
            }
        };
        findFullTextsTask.setOnSucceeded(arg_0 -> this.lambda$execute$0((Task)findFullTextsTask, arg_0));
        this.dialogService.showProgressDialog(Localization.lang("Download full text documents", new Object[0]), Localization.lang("Looking for full text document...", new Object[0]), findFullTextsTask);
        this.taskExecutor.execute(findFullTextsTask);
    }

    private void downloadFullTexts(Map<BibEntry, Optional<URL>> downloads, BibDatabaseContext databaseContext) {
        for (Map.Entry<BibEntry, Optional<URL>> download : downloads.entrySet()) {
            BibEntry entry = download.getKey();
            Optional<URL> result = download.getValue();
            if (result.isPresent()) {
                this.addLinkedFileFromURL(databaseContext, result.get(), entry);
                continue;
            }
            this.dialogService.notify(Localization.lang("No full text document found for entry %0.", entry.getCitationKey().orElse(Localization.lang("undefined", new Object[0]))));
        }
    }

    private void addLinkedFileFromURL(BibDatabaseContext databaseContext, URL url, BibEntry entry) {
        LinkedFile newLinkedFile = new LinkedFile(url, "");
        if (!entry.getFiles().contains(newLinkedFile)) {
            LinkedFileViewModel onlineFile = new LinkedFileViewModel(newLinkedFile, entry, databaseContext, this.taskExecutor, this.dialogService, this.preferences);
            onlineFile.download(true);
        } else {
            this.dialogService.notify(Localization.lang("Full text document for entry %0 already linked.", entry.getCitationKey().orElse(Localization.lang("undefined", new Object[0]))));
        }
    }

    private /* synthetic */ void lambda$execute$0(Task findFullTextsTask, WorkerStateEvent value) {
        this.downloadFullTexts((Map)findFullTextsTask.getValue(), this.stateManager.getActiveDatabase().get());
    }
}

