/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.externalfiles;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.jabref.gui.externalfiles.DateRange;
import org.jabref.gui.externalfiles.ExternalFileSorter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileFilterUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileFilterUtils.class);

    public static LocalDateTime getFileTime(Path path) {
        FileTime lastEditedTime;
        try {
            lastEditedTime = Files.getLastModifiedTime(path, new LinkOption[0]);
        }
        catch (IOException e) {
            LOGGER.error("Could not retrieve file time", (Throwable)e);
            return LocalDateTime.now();
        }
        LocalDateTime localDateTime = lastEditedTime.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        return localDateTime;
    }

    public boolean isDuringLastDay(LocalDateTime fileEditTime) {
        LocalDateTime NOW = LocalDateTime.now(ZoneId.systemDefault());
        return fileEditTime.isAfter(NOW.minusHours(24L));
    }

    public boolean isDuringLastWeek(LocalDateTime fileEditTime) {
        LocalDateTime NOW = LocalDateTime.now(ZoneId.systemDefault());
        return fileEditTime.isAfter(NOW.minusDays(7L));
    }

    public boolean isDuringLastMonth(LocalDateTime fileEditTime) {
        LocalDateTime NOW = LocalDateTime.now(ZoneId.systemDefault());
        return fileEditTime.isAfter(NOW.minusDays(30L));
    }

    public boolean isDuringLastYear(LocalDateTime fileEditTime) {
        LocalDateTime NOW = LocalDateTime.now(ZoneId.systemDefault());
        return fileEditTime.isAfter(NOW.minusDays(365L));
    }

    public static boolean filterByDate(Path path, DateRange filter) {
        FileFilterUtils fileFilter = new FileFilterUtils();
        LocalDateTime fileTime = FileFilterUtils.getFileTime(path);
        boolean isInDateRange = switch (filter) {
            default -> throw new MatchException(null, null);
            case DateRange.DAY -> fileFilter.isDuringLastDay(fileTime);
            case DateRange.WEEK -> fileFilter.isDuringLastWeek(fileTime);
            case DateRange.MONTH -> fileFilter.isDuringLastMonth(fileTime);
            case DateRange.YEAR -> fileFilter.isDuringLastYear(fileTime);
            case DateRange.ALL_TIME -> true;
        };
        return isInDateRange;
    }

    public List<Path> sortByDateAscending(List<Path> files) {
        return files.stream().sorted(Comparator.comparingLong(file -> FileFilterUtils.getFileTime(file).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli())).collect(Collectors.toList());
    }

    public List<Path> sortByDateDescending(List<Path> files) {
        return files.stream().sorted(Comparator.comparingLong(file -> -FileFilterUtils.getFileTime(file).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli())).collect(Collectors.toList());
    }

    public static List<Path> sortByDate(List<Path> files, ExternalFileSorter sortType) {
        FileFilterUtils fileFilter = new FileFilterUtils();
        List<Path> sortedFiles = switch (sortType) {
            default -> throw new MatchException(null, null);
            case ExternalFileSorter.DEFAULT -> files;
            case ExternalFileSorter.DATE_ASCENDING -> fileFilter.sortByDateDescending(files);
            case ExternalFileSorter.DATE_DESCENDING -> fileFilter.sortByDateAscending(files);
        };
        return sortedFiles;
    }
}

