/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.externalfiles;

import com.airhacks.afterburner.views.ViewLoader;
import com.tobiasdiez.easybind.EasyBind;
import de.saxsys.mvvmfx.utils.commands.Command;
import de.saxsys.mvvmfx.utils.validation.visualization.ControlsFxVisualizer;
import jakarta.inject.Inject;
import java.nio.file.Path;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Accordion;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBoxTreeItem;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.layout.VBox;
import javax.swing.undo.UndoManager;
import org.controlsfx.control.CheckTreeView;
import org.controlsfx.validation.decoration.ValidationDecoration;
import org.jabref.gui.DialogService;
import org.jabref.gui.StateManager;
import org.jabref.gui.actions.ActionFactory;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.actions.StandardActions;
import org.jabref.gui.externalfiles.DateRange;
import org.jabref.gui.externalfiles.ExternalFileSorter;
import org.jabref.gui.externalfiles.FileExtensionViewModel;
import org.jabref.gui.externalfiles.ImportFilesResultItemViewModel;
import org.jabref.gui.externalfiles.UnlinkedFilesDialogViewModel;
import org.jabref.gui.icon.JabRefIcon;
import org.jabref.gui.theme.ThemeManager;
import org.jabref.gui.util.BaseDialog;
import org.jabref.gui.util.FileNodeViewModel;
import org.jabref.gui.util.IconValidationDecorator;
import org.jabref.gui.util.RecursiveTreeItem;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.gui.util.ValueTableCellFactory;
import org.jabref.gui.util.ViewModelListCellFactory;
import org.jabref.gui.util.ViewModelTreeCellFactory;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.util.FileUpdateMonitor;
import org.jabref.preferences.PreferencesService;

public class UnlinkedFilesDialogView
extends BaseDialog<Void> {
    @FXML
    private TextField directoryPathField;
    @FXML
    private ComboBox<FileExtensionViewModel> fileTypeCombo;
    @FXML
    private ComboBox<DateRange> fileDateCombo;
    @FXML
    private ComboBox<ExternalFileSorter> fileSortCombo;
    @FXML
    private CheckTreeView<FileNodeViewModel> unlinkedFilesList;
    @FXML
    private Button scanButton;
    @FXML
    private Button exportButton;
    @FXML
    private Button importButton;
    @FXML
    private Label progressText;
    @FXML
    private Accordion accordion;
    @FXML
    private ProgressIndicator progressDisplay;
    @FXML
    private VBox progressPane;
    @FXML
    private TableView<ImportFilesResultItemViewModel> importResultTable;
    @FXML
    private TableColumn<ImportFilesResultItemViewModel, JabRefIcon> colStatus;
    @FXML
    private TableColumn<ImportFilesResultItemViewModel, String> colMessage;
    @FXML
    private TableColumn<ImportFilesResultItemViewModel, String> colFile;
    @FXML
    private TitledPane filePane;
    @FXML
    private TitledPane resultPane;
    @Inject
    private PreferencesService preferencesService;
    @Inject
    private DialogService dialogService;
    @Inject
    private StateManager stateManager;
    @Inject
    private UndoManager undoManager;
    @Inject
    private TaskExecutor taskExecutor;
    @Inject
    private FileUpdateMonitor fileUpdateMonitor;
    @Inject
    private ThemeManager themeManager;
    private final ControlsFxVisualizer validationVisualizer = new ControlsFxVisualizer();
    private UnlinkedFilesDialogViewModel viewModel;
    private BibDatabaseContext bibDatabaseContext;

    public UnlinkedFilesDialogView() {
        this.setTitle(Localization.lang("Search for unlinked local files", new Object[0]));
        ViewLoader.view((Object)((Object)this)).load().setAsDialogPane((Dialog)this);
        this.setResultConverter(button -> {
            if (button == ButtonType.CANCEL) {
                this.viewModel.cancelTasks();
            }
            return null;
        });
        this.themeManager.updateFontStyle(this.getDialogPane().getScene());
    }

    @FXML
    private void initialize() {
        this.viewModel = new UnlinkedFilesDialogViewModel(this.dialogService, this.undoManager, this.fileUpdateMonitor, this.preferencesService, this.stateManager, this.taskExecutor);
        this.bibDatabaseContext = this.stateManager.getActiveDatabase().orElseThrow(() -> new NullPointerException("No active library"));
        this.progressDisplay.progressProperty().bind((ObservableValue)this.viewModel.progressValueProperty());
        this.progressText.textProperty().bind((ObservableValue)this.viewModel.progressTextProperty());
        this.progressPane.managedProperty().bind((ObservableValue)this.viewModel.taskActiveProperty());
        this.progressPane.visibleProperty().bind((ObservableValue)this.viewModel.taskActiveProperty());
        this.accordion.disableProperty().bind((ObservableValue)this.viewModel.taskActiveProperty());
        this.viewModel.treeRootProperty().addListener(observable -> {
            this.scanButton.setDefaultButton(false);
            this.importButton.setDefaultButton(true);
            this.scanButton.setDefaultButton(false);
            this.filePane.setExpanded(true);
            this.resultPane.setExpanded(false);
        });
        this.viewModel.resultTableItems().addListener(observable -> {
            this.filePane.setExpanded(false);
            this.resultPane.setExpanded(true);
            this.resultPane.setDisable(false);
        });
        this.initDirectorySelection();
        this.initUnlinkedFilesList();
        this.initResultTable();
        this.initButtons();
    }

    private void initDirectorySelection() {
        this.validationVisualizer.setDecoration((ValidationDecoration)new IconValidationDecorator());
        this.directoryPathField.textProperty().bindBidirectional((Property)this.viewModel.directoryPathProperty());
        Platform.runLater(() -> this.validationVisualizer.initVisualization(this.viewModel.directoryPathValidationStatus(), (Control)this.directoryPathField));
        new ViewModelListCellFactory().withText(FileExtensionViewModel::getDescription).withIcon(FileExtensionViewModel::getIcon).install(this.fileTypeCombo);
        this.fileTypeCombo.setItems(this.viewModel.getFileFilters());
        this.fileTypeCombo.valueProperty().bindBidirectional(this.viewModel.selectedExtensionProperty());
        this.fileTypeCombo.getSelectionModel().selectFirst();
        new ViewModelListCellFactory().withText(DateRange::getDateRange).install(this.fileDateCombo);
        this.fileDateCombo.setItems(this.viewModel.getDateFilters());
        this.fileDateCombo.valueProperty().bindBidirectional(this.viewModel.selectedDateProperty());
        this.fileDateCombo.getSelectionModel().selectFirst();
        new ViewModelListCellFactory().withText(ExternalFileSorter::getSorter).install(this.fileSortCombo);
        this.fileSortCombo.setItems(this.viewModel.getSorters());
        this.fileSortCombo.valueProperty().bindBidirectional(this.viewModel.selectedSortProperty());
        this.fileSortCombo.getSelectionModel().selectFirst();
        this.directoryPathField.setText(this.bibDatabaseContext.getFirstExistingFileDir(this.preferencesService.getFilePreferences()).map(Path::toString).orElse(""));
    }

    private void initUnlinkedFilesList() {
        new ViewModelTreeCellFactory().withText(FileNodeViewModel::getDisplayTextWithEditDate).install((TreeView<FileNodeViewModel>)this.unlinkedFilesList);
        this.unlinkedFilesList.maxHeightProperty().bind((ObservableValue)((Control)this.filePane.contentProperty().get()).heightProperty());
        this.unlinkedFilesList.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.unlinkedFilesList.rootProperty().bind((ObservableValue)EasyBind.map(this.viewModel.treeRootProperty(), fileNode -> fileNode.map(fileNodeViewModel -> new RecursiveTreeItem<FileNodeViewModel>((FileNodeViewModel)fileNodeViewModel, FileNodeViewModel::getChildren)).orElse(null)));
        this.unlinkedFilesList.setContextMenu(this.createSearchContextMenu());
        EasyBind.subscribe((ObservableValue)this.unlinkedFilesList.rootProperty(), root -> {
            if (root != null) {
                ((CheckBoxTreeItem)root).setSelected(true);
                root.setExpanded(true);
                EasyBind.bindContent(this.viewModel.checkedFileListProperty(), (ObservableList)this.unlinkedFilesList.getCheckModel().getCheckedItems());
            } else {
                EasyBind.bindContent(this.viewModel.checkedFileListProperty(), (ObservableList)FXCollections.observableArrayList());
            }
        });
    }

    private void initResultTable() {
        this.colFile.setCellValueFactory(cellData -> ((ImportFilesResultItemViewModel)cellData.getValue()).file());
        new ValueTableCellFactory().withText(item -> item).withTooltip(item -> item).install(this.colFile);
        this.colMessage.setCellValueFactory(cellData -> ((ImportFilesResultItemViewModel)cellData.getValue()).message());
        new ValueTableCellFactory().withText(item -> item).withTooltip(item -> item).install(this.colMessage);
        this.colStatus.setCellValueFactory(cellData -> ((ImportFilesResultItemViewModel)cellData.getValue()).icon());
        this.colStatus.setCellFactory(new ValueTableCellFactory().withGraphic(JabRefIcon::getGraphicNode));
        this.importResultTable.setColumnResizePolicy(param -> true);
        this.importResultTable.setItems(this.viewModel.resultTableItems());
    }

    private void initButtons() {
        BooleanBinding noItemsChecked = Bindings.isNull((ObservableObjectValue)this.unlinkedFilesList.rootProperty()).or((ObservableBooleanValue)Bindings.isEmpty(this.viewModel.checkedFileListProperty()));
        this.exportButton.disableProperty().bind((ObservableValue)noItemsChecked);
        this.importButton.disableProperty().bind((ObservableValue)noItemsChecked);
        this.scanButton.setDefaultButton(true);
        this.scanButton.disableProperty().bind((ObservableValue)this.viewModel.taskActiveProperty().or((ObservableBooleanValue)this.viewModel.directoryPathValidationStatus().validProperty().not()));
    }

    @FXML
    void browseFileDirectory() {
        this.viewModel.browseFileDirectory();
    }

    @FXML
    void scanFiles() {
        this.viewModel.startSearch();
    }

    @FXML
    void startImport() {
        this.viewModel.startImport();
    }

    @FXML
    void exportSelected() {
        this.viewModel.startExport();
    }

    private void expandTree(TreeItem<?> item, boolean expand) {
        if (item != null && !item.isLeaf()) {
            item.setExpanded(expand);
            for (TreeItem child : item.getChildren()) {
                this.expandTree(child, expand);
            }
        }
    }

    private ContextMenu createSearchContextMenu() {
        ContextMenu contextMenu = new ContextMenu();
        ActionFactory factory = new ActionFactory();
        contextMenu.getItems().add((Object)factory.createMenuItem(StandardActions.SELECT_ALL, (Command)new SearchContextAction(StandardActions.SELECT_ALL)));
        contextMenu.getItems().add((Object)factory.createMenuItem(StandardActions.UNSELECT_ALL, (Command)new SearchContextAction(StandardActions.UNSELECT_ALL)));
        contextMenu.getItems().add((Object)factory.createMenuItem(StandardActions.EXPAND_ALL, (Command)new SearchContextAction(StandardActions.EXPAND_ALL)));
        contextMenu.getItems().add((Object)factory.createMenuItem(StandardActions.COLLAPSE_ALL, (Command)new SearchContextAction(StandardActions.COLLAPSE_ALL)));
        return contextMenu;
    }

    private class SearchContextAction
    extends SimpleCommand {
        private final StandardActions command;

        public SearchContextAction(StandardActions command) {
            this.command = command;
            this.executable.bind((ObservableValue)UnlinkedFilesDialogView.this.unlinkedFilesList.rootProperty().isNotNull());
        }

        public void execute() {
            switch (this.command) {
                case SELECT_ALL: {
                    UnlinkedFilesDialogView.this.unlinkedFilesList.getCheckModel().checkAll();
                    break;
                }
                case UNSELECT_ALL: {
                    UnlinkedFilesDialogView.this.unlinkedFilesList.getCheckModel().clearChecks();
                    break;
                }
                case EXPAND_ALL: {
                    UnlinkedFilesDialogView.this.expandTree(UnlinkedFilesDialogView.this.unlinkedFilesList.getRoot(), true);
                    break;
                }
                case COLLAPSE_ALL: {
                    UnlinkedFilesDialogView.this.expandTree(UnlinkedFilesDialogView.this.unlinkedFilesList.getRoot(), false);
                }
            }
        }
    }
}

