/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors;

import com.github.difflib.DiffUtils;
import com.github.difflib.patch.AbstractDelta;
import com.tobiasdiez.easybind.EasyBind;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.TextInputControl;
import javafx.scene.input.KeyEvent;
import org.jabref.gui.keyboard.KeyBinding;
import org.jabref.gui.keyboard.KeyBindingRepository;
import org.jabref.gui.undo.RedoAction;
import org.jabref.gui.undo.UndoAction;
import org.jabref.gui.util.UiTaskExecutor;
import org.jabref.model.entry.BibEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface FieldEditorFX {
    public void bindToEntry(BibEntry var1);

    default public void establishBinding(TextInputControl textInputControl, StringProperty viewModelTextProperty, KeyBindingRepository keyBindingRepository, UndoAction undoAction, RedoAction redoAction) {
        Logger logger = LoggerFactory.getLogger(FieldEditorFX.class);
        textInputControl.addEventFilter(KeyEvent.ANY, e -> {
            if (e.getEventType() == KeyEvent.KEY_PRESSED && e.isShortcutDown()) {
                if (keyBindingRepository.matches((KeyEvent)e, KeyBinding.UNDO)) {
                    undoAction.execute();
                    e.consume();
                } else if (keyBindingRepository.matches((KeyEvent)e, KeyBinding.REDO)) {
                    redoAction.execute();
                    e.consume();
                }
            }
        });
        EasyBind.subscribe((ObservableValue)viewModelTextProperty, newText -> {
            if (Platform.isFxApplicationThread()) {
                this.setTextAndUpdateCaretPosition(textInputControl, (String)newText, logger);
            } else {
                UiTaskExecutor.runInJavaFXThread(() -> this.setTextAndUpdateCaretPosition(textInputControl, (String)newText, logger));
            }
        });
        EasyBind.subscribe((ObservableValue)textInputControl.textProperty(), arg_0 -> ((StringProperty)viewModelTextProperty).set(arg_0));
    }

    private void setTextAndUpdateCaretPosition(TextInputControl textInputControl, String newText, Logger logger) {
        AbstractDelta delta;
        int lastCaretPosition = textInputControl.getCaretPosition();
        logger.trace("Caret at position {}", (Object)lastCaretPosition);
        String oldText = textInputControl.getText();
        textInputControl.setText(newText);
        logger.trace("listener triggered: '{}' -> '{}'", (Object)oldText, (Object)newText);
        if (oldText == null) {
            logger.trace("Empty field");
            return;
        }
        if (newText == null) {
            logger.trace("Field cleared");
            return;
        }
        if (oldText.equals(newText)) {
            logger.trace("No change, returned.");
            return;
        }
        logger.trace("Trying to adapt...");
        List<String> oldValueCharacters = Arrays.asList(oldText.split(""));
        List<String> newValueCharacters = Arrays.asList(newText.split(""));
        List deltaList = DiffUtils.diff(oldValueCharacters, newValueCharacters).getDeltas();
        logger.trace("Deltas: {}", (Object)deltaList);
        AbstractDelta lastDelta = null;
        Iterator iterator = deltaList.iterator();
        while (iterator.hasNext() && (delta = (AbstractDelta)iterator.next()).getSource().getPosition() <= lastCaretPosition) {
            lastDelta = delta;
        }
        if (lastDelta == null) {
            textInputControl.positionCaret(lastCaretPosition);
        } else {
            logger.trace("Last Delta: {}", lastDelta);
            logger.trace("Last Delta source: {}", (Object)lastDelta.getSource());
            logger.trace("Last Delta target: {}", (Object)lastDelta.getTarget());
            int offset = lastDelta.getTarget().getPosition() - lastDelta.getSource().getPosition();
            logger.trace("Offset before patching: {}", (Object)offset);
            switch (lastDelta.getType()) {
                case DELETE: {
                    offset -= lastDelta.getSource().size();
                    break;
                }
                case INSERT: {
                    offset += lastDelta.getTarget().size();
                    break;
                }
                case CHANGE: {
                    offset += lastDelta.getTarget().size() - lastDelta.getSource().size();
                    break;
                }
            }
            logger.trace("Offset after patching: {}", (Object)offset);
            int newCaretPosition = lastCaretPosition + offset;
            textInputControl.positionCaret(newCaretPosition);
            logger.trace("newCaretPosition: {}", (Object)newCaretPosition);
        }
    }

    public Parent getNode();

    default public void focus() {
        ((Node)this.getNode().getChildrenUnmodifiable().stream().findFirst().orElse(this.getNode())).requestFocus();
    }

    default public double getWeight() {
        return 1.0;
    }
}

