/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors;

import com.airhacks.afterburner.views.ViewLoader;
import jakarta.inject.Inject;
import java.util.Optional;
import javafx.fxml.FXML;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.TextInputControl;
import javafx.scene.layout.HBox;
import javax.swing.undo.UndoManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.StateManager;
import org.jabref.gui.autocompleter.SuggestionProvider;
import org.jabref.gui.fieldeditors.EditorTextArea;
import org.jabref.gui.fieldeditors.EditorValidator;
import org.jabref.gui.fieldeditors.FieldEditorFX;
import org.jabref.gui.fieldeditors.ISSNEditorViewModel;
import org.jabref.gui.fieldeditors.JournalInfoOptInDialogHelper;
import org.jabref.gui.fieldeditors.contextmenu.DefaultMenu;
import org.jabref.gui.keyboard.KeyBindingRepository;
import org.jabref.gui.undo.RedoAction;
import org.jabref.gui.undo.UndoAction;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.integrity.FieldCheckers;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.preferences.PreferencesService;

public class ISSNEditor
extends HBox
implements FieldEditorFX {
    @FXML
    private ISSNEditorViewModel viewModel;
    @FXML
    private EditorTextArea textArea;
    @FXML
    private Button journalInfoButton;
    @FXML
    private Button fetchInformationByIdentifierButton;
    @Inject
    private DialogService dialogService;
    @Inject
    private PreferencesService preferencesService;
    @Inject
    private KeyBindingRepository keyBindingRepository;
    @Inject
    private UndoManager undoManager;
    @Inject
    private TaskExecutor taskExecutor;
    @Inject
    private StateManager stateManager;
    private Optional<BibEntry> entry = Optional.empty();

    public ISSNEditor(Field field, SuggestionProvider<?> suggestionProvider, FieldCheckers fieldCheckers, UndoAction undoAction, RedoAction redoAction) {
        ViewLoader.view((Object)this).root((Object)this).load();
        this.viewModel = new ISSNEditorViewModel(field, suggestionProvider, fieldCheckers, this.taskExecutor, this.dialogService, this.undoManager, this.stateManager, this.preferencesService);
        this.establishBinding((TextInputControl)this.textArea, this.viewModel.textProperty(), this.keyBindingRepository, undoAction, redoAction);
        this.textArea.initContextMenu(new DefaultMenu((TextInputControl)this.textArea), this.keyBindingRepository);
        new EditorValidator(this.preferencesService).configureValidation(this.viewModel.getFieldValidator().getValidationStatus(), (TextInputControl)this.textArea);
    }

    public ISSNEditorViewModel getViewModel() {
        return this.viewModel;
    }

    @Override
    public void bindToEntry(BibEntry entry) {
        this.entry = Optional.of(entry);
        this.viewModel.bindToEntry(entry);
    }

    @Override
    public Parent getNode() {
        return this;
    }

    public void requestFocus() {
        this.textArea.requestFocus();
    }

    @FXML
    private void fetchInformationByIdentifier() {
        this.entry.ifPresent(this.viewModel::fetchBibliographyInformation);
    }

    @FXML
    private void showJournalInfo() {
        if (JournalInfoOptInDialogHelper.isJournalInfoEnabled(this.dialogService, this.preferencesService.getEntryEditorPreferences())) {
            this.viewModel.showJournalInfo(this.journalInfoButton);
        }
    }
}

