/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors;

import com.airhacks.afterburner.views.ViewLoader;
import jakarta.inject.Inject;
import javafx.fxml.FXML;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.TextInputControl;
import javafx.scene.layout.HBox;
import javax.swing.undo.UndoManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.autocompleter.AutoCompletionTextInputBinding;
import org.jabref.gui.autocompleter.SuggestionProvider;
import org.jabref.gui.fieldeditors.EditorTextField;
import org.jabref.gui.fieldeditors.EditorValidator;
import org.jabref.gui.fieldeditors.FieldEditorFX;
import org.jabref.gui.fieldeditors.JournalEditorViewModel;
import org.jabref.gui.fieldeditors.JournalInfoOptInDialogHelper;
import org.jabref.gui.fieldeditors.contextmenu.DefaultMenu;
import org.jabref.gui.keyboard.KeyBindingRepository;
import org.jabref.gui.undo.RedoAction;
import org.jabref.gui.undo.UndoAction;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.integrity.FieldCheckers;
import org.jabref.logic.journals.JournalAbbreviationRepository;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.preferences.PreferencesService;

public class JournalEditor
extends HBox
implements FieldEditorFX {
    @FXML
    private JournalEditorViewModel viewModel;
    @FXML
    private EditorTextField textField;
    @FXML
    private Button journalInfoButton;
    @Inject
    private DialogService dialogService;
    @Inject
    private PreferencesService preferencesService;
    @Inject
    private KeyBindingRepository keyBindingRepository;
    @Inject
    private TaskExecutor taskExecutor;
    @Inject
    private JournalAbbreviationRepository abbreviationRepository;
    @Inject
    private UndoManager undoManager;

    public JournalEditor(Field field, SuggestionProvider<?> suggestionProvider, FieldCheckers fieldCheckers, UndoAction undoAction, RedoAction redoAction) {
        ViewLoader.view((Object)this).root((Object)this).load();
        this.viewModel = new JournalEditorViewModel(field, suggestionProvider, this.abbreviationRepository, fieldCheckers, this.taskExecutor, this.dialogService, this.undoManager);
        this.establishBinding((TextInputControl)this.textField, this.viewModel.textProperty(), this.keyBindingRepository, undoAction, redoAction);
        this.textField.initContextMenu(new DefaultMenu((TextInputControl)this.textField), this.keyBindingRepository);
        AutoCompletionTextInputBinding.autoComplete((TextInputControl)this.textField, this.viewModel::complete);
        new EditorValidator(this.preferencesService).configureValidation(this.viewModel.getFieldValidator().getValidationStatus(), (TextInputControl)this.textField);
    }

    public JournalEditorViewModel getViewModel() {
        return this.viewModel;
    }

    @Override
    public void bindToEntry(BibEntry entry) {
        this.viewModel.bindToEntry(entry);
    }

    @Override
    public Parent getNode() {
        return this;
    }

    @FXML
    private void toggleAbbreviation() {
        this.viewModel.toggleAbbreviation();
    }

    @FXML
    private void showJournalInfo() {
        if (JournalInfoOptInDialogHelper.isJournalInfoEnabled(this.dialogService, this.preferencesService.getEntryEditorPreferences())) {
            this.viewModel.showJournalInfo(this.journalInfoButton);
        }
    }
}

