/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors;

import org.jabref.gui.DialogService;
import org.jabref.gui.entryeditor.EntryEditorPreferences;
import org.jabref.logic.l10n.Localization;

public class JournalInfoOptInDialogHelper {
    public static boolean isJournalInfoEnabled(DialogService dialogService, EntryEditorPreferences preferences) {
        if (preferences.shouldEnableJournalPopup() == EntryEditorPreferences.JournalPopupEnabled.ENABLED) {
            return true;
        }
        if (preferences.shouldEnableJournalPopup() == EntryEditorPreferences.JournalPopupEnabled.DISABLED) {
            boolean enableJournalPopup = dialogService.showConfirmationDialogAndWait(Localization.lang("Enable Journal Information Fetching?", new Object[0]), Localization.lang("Would you like to enable fetching of journal information? This can be changed later in %0 > %1.", Localization.lang("Preferences", new Object[0]), Localization.lang("Entry editor", new Object[0])), Localization.lang("Enable", new Object[0]), Localization.lang("Keep disabled", new Object[0]));
            preferences.setEnableJournalPopup(enableJournalPopup ? EntryEditorPreferences.JournalPopupEnabled.ENABLED : EntryEditorPreferences.JournalPopupEnabled.DISABLED);
            return enableJournalPopup;
        }
        boolean journalInfoEnabled = dialogService.showConfirmationDialogAndWait(Localization.lang("Remote services", new Object[0]), Localization.lang("Allow sending ISSN to a JabRef online service (SCimago) for fetching journal information", new Object[0]));
        preferences.setEnableJournalPopup(journalInfoEnabled ? EntryEditorPreferences.JournalPopupEnabled.ENABLED : EntryEditorPreferences.JournalPopupEnabled.DISABLED);
        return journalInfoEnabled;
    }
}

