/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors;

import com.airhacks.afterburner.views.ViewLoader;
import com.tobiasdiez.easybind.EasyBind;
import com.tobiasdiez.easybind.optional.ObservableOptionalValue;
import de.saxsys.mvvmfx.utils.commands.Command;
import de.saxsys.mvvmfx.utils.validation.ValidationStatus;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuItem;
import javafx.scene.control.OverrunStyle;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Tooltip;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.text.Text;
import javafx.util.Callback;
import javax.swing.undo.UndoManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.DragAndDropDataFormats;
import org.jabref.gui.actions.ActionFactory;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.actions.StandardActions;
import org.jabref.gui.autocompleter.SuggestionProvider;
import org.jabref.gui.copyfiles.CopySingleFileAction;
import org.jabref.gui.fieldeditors.FieldEditorFX;
import org.jabref.gui.fieldeditors.LinkedFileViewModel;
import org.jabref.gui.fieldeditors.LinkedFilesEditorViewModel;
import org.jabref.gui.fieldeditors.WriteMetadataToSinglePdfAction;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.icon.JabRefIconView;
import org.jabref.gui.importer.GrobidOptInDialogHelper;
import org.jabref.gui.keyboard.KeyBinding;
import org.jabref.gui.linkedfile.DeleteFileAction;
import org.jabref.gui.util.BindingsHelper;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.gui.util.ViewModelListCellFactory;
import org.jabref.gui.util.uithreadaware.UiThreadObservableList;
import org.jabref.logic.integrity.FieldCheckers;
import org.jabref.logic.journals.JournalAbbreviationRepository;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.model.entry.LinkedFile;
import org.jabref.model.entry.field.Field;
import org.jabref.preferences.PreferencesService;

public class LinkedFilesEditor
extends HBox
implements FieldEditorFX {
    @FXML
    private ListView<LinkedFileViewModel> listView;
    @FXML
    private JabRefIconView fulltextFetcher;
    @FXML
    private ProgressIndicator progressIndicator;
    private final Field field;
    private final BibDatabaseContext databaseContext;
    private final SuggestionProvider<?> suggestionProvider;
    private final FieldCheckers fieldCheckers;
    @Inject
    private DialogService dialogService;
    @Inject
    private PreferencesService preferencesService;
    @Inject
    private BibEntryTypesManager bibEntryTypesManager;
    @Inject
    private JournalAbbreviationRepository abbreviationRepository;
    @Inject
    private TaskExecutor taskExecutor;
    @Inject
    private UndoManager undoManager;
    private LinkedFilesEditorViewModel viewModel;
    private ObservableOptionalValue<BibEntry> bibEntry = EasyBind.wrapNullable((ObservableValue)new SimpleObjectProperty());
    private final UiThreadObservableList<LinkedFileViewModel> decoratedModelList;

    public LinkedFilesEditor(Field field, BibDatabaseContext databaseContext, SuggestionProvider<?> suggestionProvider, FieldCheckers fieldCheckers) {
        this.field = field;
        this.databaseContext = databaseContext;
        this.suggestionProvider = suggestionProvider;
        this.fieldCheckers = fieldCheckers;
        ViewLoader.view((Object)this).root((Object)this).load();
        this.decoratedModelList = new UiThreadObservableList<LinkedFileViewModel>((ObservableList<LinkedFileViewModel>)this.viewModel.filesProperty());
        Bindings.bindContentBidirectional((ObservableList)((ObservableList)this.listView.itemsProperty().get()), this.decoratedModelList);
    }

    @FXML
    private void initialize() {
        this.viewModel = new LinkedFilesEditorViewModel(this.field, this.suggestionProvider, this.dialogService, this.databaseContext, this.taskExecutor, this.fieldCheckers, this.preferencesService, this.undoManager);
        new ViewModelListCellFactory().withStringTooltip(LinkedFileViewModel::getDescriptionAndLink).withGraphic(this::createFileDisplay).withContextMenu(this::createContextMenuForFile).withOnMouseClickedEvent(this::handleItemMouseClick).setOnDragDetected(this::handleOnDragDetected).setOnDragDropped(this::handleOnDragDropped).setOnDragOver(this::handleOnDragOver).withValidation((Callback<LinkedFileViewModel, ValidationStatus>)((Callback)LinkedFileViewModel::fileExistsValidationStatus)).install(this.listView);
        this.listView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.fulltextFetcher.visibleProperty().bind((ObservableValue)this.viewModel.fulltextLookupInProgressProperty().not());
        this.progressIndicator.visibleProperty().bind((ObservableValue)this.viewModel.fulltextLookupInProgressProperty());
        this.setUpKeyBindings();
    }

    private void handleOnDragOver(LinkedFileViewModel originalItem, DragEvent event) {
        if (event.getGestureSource() != originalItem && event.getDragboard().hasContent(DragAndDropDataFormats.LINKED_FILE)) {
            event.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
        }
    }

    private void handleOnDragDetected(LinkedFileViewModel linkedFile, MouseEvent event) {
        LinkedFile selectedItem = ((LinkedFileViewModel)this.listView.getSelectionModel().getSelectedItem()).getFile();
        if (selectedItem != null) {
            ClipboardContent content = new ClipboardContent();
            Dragboard dragboard = this.listView.startDragAndDrop(new TransferMode[]{TransferMode.MOVE});
            content.put((Object)DragAndDropDataFormats.LINKED_FILE, (Object)selectedItem);
            dragboard.setContent((Map)content);
        }
        event.consume();
    }

    private void handleOnDragDropped(LinkedFileViewModel originalItem, DragEvent event) {
        Dragboard dragboard = event.getDragboard();
        boolean success = false;
        ObservableList items = (ObservableList)this.listView.itemsProperty().get();
        if (dragboard.hasContent(DragAndDropDataFormats.LINKED_FILE)) {
            LinkedFile linkedFile = (LinkedFile)dragboard.getContent(DragAndDropDataFormats.LINKED_FILE);
            LinkedFileViewModel transferredItem = null;
            int draggedIdx = 0;
            for (int i = 0; i < items.size(); ++i) {
                if (!((LinkedFileViewModel)items.get(i)).getFile().equals(linkedFile)) continue;
                draggedIdx = i;
                transferredItem = (LinkedFileViewModel)items.get(i);
                break;
            }
            int thisIdx = items.indexOf((Object)originalItem);
            items.set(draggedIdx, (Object)originalItem);
            items.set(thisIdx, transferredItem);
            success = true;
        }
        event.setDropCompleted(success);
        event.consume();
    }

    private Node createFileDisplay(LinkedFileViewModel linkedFile) {
        PseudoClass opacity = PseudoClass.getPseudoClass((String)"opacity");
        Node icon = linkedFile.getTypeIcon().getGraphicNode();
        icon.setOnMouseClicked(event -> linkedFile.open());
        Text link = new Text();
        link.textProperty().bind((ObservableValue)linkedFile.linkProperty());
        link.getStyleClass().setAll((Object[])new String[]{"file-row-text"});
        EasyBind.subscribe((ObservableValue)linkedFile.isAutomaticallyFoundProperty(), found -> link.pseudoClassStateChanged(opacity, found.booleanValue()));
        Text desc = new Text();
        desc.textProperty().bind((ObservableValue)linkedFile.descriptionProperty());
        desc.getStyleClass().setAll((Object[])new String[]{"file-row-text"});
        ProgressBar progressIndicator = new ProgressBar();
        progressIndicator.progressProperty().bind((ObservableValue)linkedFile.downloadProgressProperty());
        progressIndicator.visibleProperty().bind((ObservableValue)linkedFile.downloadOngoingProperty());
        Label label = new Label();
        label.graphicProperty().bind(linkedFile.typeIconProperty());
        label.textProperty().bind((ObservableValue)linkedFile.linkProperty());
        label.getStyleClass().setAll((Object[])new String[]{"file-row-text"});
        label.textOverrunProperty().setValue((Object)OverrunStyle.LEADING_ELLIPSIS);
        EasyBind.subscribe((ObservableValue)linkedFile.isAutomaticallyFoundProperty(), found -> label.pseudoClassStateChanged(opacity, found.booleanValue()));
        HBox info = new HBox(8.0);
        HBox.setHgrow((Node)info, (Priority)Priority.ALWAYS);
        info.setStyle("-fx-padding: 0.5em 0 0.5em 0;");
        info.getChildren().setAll((Object[])new Node[]{label, progressIndicator});
        Button acceptAutoLinkedFile = IconTheme.JabRefIcons.AUTO_LINKED_FILE.asButton();
        acceptAutoLinkedFile.setTooltip(new Tooltip(Localization.lang("This file was found automatically. Do you want to link it to this entry?", new Object[0])));
        acceptAutoLinkedFile.visibleProperty().bind((ObservableValue)linkedFile.isAutomaticallyFoundProperty());
        acceptAutoLinkedFile.managedProperty().bind((ObservableValue)linkedFile.isAutomaticallyFoundProperty());
        acceptAutoLinkedFile.setOnAction(event -> linkedFile.acceptAsLinked());
        acceptAutoLinkedFile.getStyleClass().setAll((Object[])new String[]{"icon-button"});
        Button writeMetadataToPdf = IconTheme.JabRefIcons.PDF_METADATA_WRITE.asButton();
        writeMetadataToPdf.setTooltip(new Tooltip(Localization.lang("Write BibTeXEntry metadata to PDF.", new Object[0])));
        writeMetadataToPdf.visibleProperty().bind((ObservableValue)linkedFile.isOfflinePdfProperty());
        writeMetadataToPdf.getStyleClass().setAll((Object[])new String[]{"icon-button"});
        WriteMetadataToSinglePdfAction writeMetadataToSinglePdfAction = new WriteMetadataToSinglePdfAction(linkedFile.getFile(), (BibEntry)this.bibEntry.getValueOrElse((Object)new BibEntry()), this.databaseContext, this.dialogService, this.preferencesService.getFieldPreferences(), this.preferencesService.getFilePreferences(), this.preferencesService.getXmpPreferences(), this.abbreviationRepository, this.bibEntryTypesManager, this.taskExecutor);
        writeMetadataToPdf.disableProperty().bind((ObservableValue)writeMetadataToSinglePdfAction.executableProperty().not());
        writeMetadataToPdf.setOnAction(event -> writeMetadataToSinglePdfAction.execute());
        Button parsePdfMetadata = IconTheme.JabRefIcons.PDF_METADATA_READ.asButton();
        parsePdfMetadata.setTooltip(new Tooltip(Localization.lang("Parse Metadata from PDF.", new Object[0])));
        parsePdfMetadata.visibleProperty().bind((ObservableValue)linkedFile.isOfflinePdfProperty());
        parsePdfMetadata.setOnAction(event -> {
            GrobidOptInDialogHelper.showAndWaitIfUserIsUndecided(this.dialogService, this.preferencesService.getGrobidPreferences());
            linkedFile.parsePdfMetadataAndShowMergeDialog();
        });
        parsePdfMetadata.getStyleClass().setAll((Object[])new String[]{"icon-button"});
        HBox container = new HBox(2.0);
        container.setPrefHeight(Double.NEGATIVE_INFINITY);
        container.maxWidthProperty().bind((ObservableValue)this.listView.widthProperty().subtract(20.0));
        container.getChildren().addAll((Object[])new Node[]{acceptAutoLinkedFile, info, writeMetadataToPdf, parsePdfMetadata});
        return container;
    }

    private void setUpKeyBindings() {
        this.listView.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            Optional<KeyBinding> keyBinding = this.preferencesService.getKeyBindingRepository().mapToKeyBinding((KeyEvent)event);
            if (keyBinding.isPresent()) {
                switch (keyBinding.get()) {
                    case DELETE_ENTRY: {
                        this.deleteAttachedFilesWithConfirmation();
                        event.consume();
                        break;
                    }
                }
            }
        });
    }

    private void deleteAttachedFilesWithConfirmation() {
        new DeleteFileAction(this.dialogService, this.preferencesService.getFilePreferences(), this.databaseContext, this.viewModel, (List<LinkedFileViewModel>)this.listView.getSelectionModel().getSelectedItems()).execute();
    }

    public LinkedFilesEditorViewModel getViewModel() {
        return this.viewModel;
    }

    @Override
    public void bindToEntry(BibEntry entry) {
        this.bibEntry = EasyBind.wrapNullable((ObservableValue)new SimpleObjectProperty((Object)entry));
        this.viewModel.bindToEntry(entry);
    }

    @Override
    public Parent getNode() {
        return this;
    }

    @FXML
    private void addNewFile() {
        this.viewModel.addNewFile();
    }

    @FXML
    private void fetchFulltext() {
        this.viewModel.fetchFulltext();
    }

    @FXML
    private void addFromURL() {
        this.viewModel.addFromURL();
    }

    private void handleItemMouseClick(LinkedFileViewModel linkedFile, MouseEvent event) {
        if (event.getButton() == MouseButton.PRIMARY && event.getClickCount() == 2) {
            linkedFile.open();
        }
    }

    @Override
    public double getWeight() {
        return 3.0;
    }

    private ContextMenu createContextMenuForFile(LinkedFileViewModel linkedFile) {
        ContextMenu menu = new ContextMenu();
        ActionFactory factory = new ActionFactory();
        menu.getItems().addAll((Object[])new MenuItem[]{factory.createMenuItem(StandardActions.EDIT_FILE_LINK, (Command)new ContextAction(StandardActions.EDIT_FILE_LINK, linkedFile, this.preferencesService)), new SeparatorMenuItem(), factory.createMenuItem(StandardActions.OPEN_FILE, (Command)new ContextAction(StandardActions.OPEN_FILE, linkedFile, this.preferencesService)), factory.createMenuItem(StandardActions.OPEN_FOLDER, (Command)new ContextAction(StandardActions.OPEN_FOLDER, linkedFile, this.preferencesService)), new SeparatorMenuItem(), factory.createMenuItem(StandardActions.DOWNLOAD_FILE, (Command)new ContextAction(StandardActions.DOWNLOAD_FILE, linkedFile, this.preferencesService)), factory.createMenuItem(StandardActions.RENAME_FILE_TO_PATTERN, (Command)new ContextAction(StandardActions.RENAME_FILE_TO_PATTERN, linkedFile, this.preferencesService)), factory.createMenuItem(StandardActions.RENAME_FILE_TO_NAME, (Command)new ContextAction(StandardActions.RENAME_FILE_TO_NAME, linkedFile, this.preferencesService)), factory.createMenuItem(StandardActions.MOVE_FILE_TO_FOLDER, (Command)new ContextAction(StandardActions.MOVE_FILE_TO_FOLDER, linkedFile, this.preferencesService)), factory.createMenuItem(StandardActions.MOVE_FILE_TO_FOLDER_AND_RENAME, (Command)new ContextAction(StandardActions.MOVE_FILE_TO_FOLDER_AND_RENAME, linkedFile, this.preferencesService)), factory.createMenuItem(StandardActions.COPY_FILE_TO_FOLDER, (Command)new CopySingleFileAction(linkedFile.getFile(), this.dialogService, this.databaseContext, this.preferencesService.getFilePreferences())), factory.createMenuItem(StandardActions.REDOWNLOAD_FILE, (Command)new ContextAction(StandardActions.REDOWNLOAD_FILE, linkedFile, this.preferencesService)), factory.createMenuItem(StandardActions.REMOVE_LINK, (Command)new ContextAction(StandardActions.REMOVE_LINK, linkedFile, this.preferencesService)), factory.createMenuItem(StandardActions.DELETE_FILE, (Command)new ContextAction(StandardActions.DELETE_FILE, linkedFile, this.preferencesService))});
        return menu;
    }

    private class ContextAction
    extends SimpleCommand {
        private final StandardActions command;
        private final LinkedFileViewModel linkedFile;

        public ContextAction(StandardActions command, LinkedFileViewModel linkedFile, PreferencesService preferencesService) {
            this.command = command;
            this.linkedFile = linkedFile;
            this.executable.bind(switch (command) {
                case StandardActions.RENAME_FILE_TO_PATTERN -> Bindings.createBooleanBinding(() -> !linkedFile.getFile().isOnlineLink() && linkedFile.getFile().findIn(LinkedFilesEditor.this.databaseContext, preferencesService.getFilePreferences()).isPresent() && !linkedFile.isGeneratedNameSameAsOriginal(), (Observable[])new Observable[]{linkedFile.getFile().linkProperty(), ((Optional)LinkedFilesEditor.this.bibEntry.getValue()).map(BibEntry::getFieldsObservable).orElse(null)});
                case StandardActions.MOVE_FILE_TO_FOLDER, StandardActions.MOVE_FILE_TO_FOLDER_AND_RENAME -> Bindings.createBooleanBinding(() -> !linkedFile.getFile().isOnlineLink() && linkedFile.getFile().findIn(LinkedFilesEditor.this.databaseContext, preferencesService.getFilePreferences()).isPresent() && !linkedFile.isGeneratedPathSameAsOriginal(), (Observable[])new Observable[]{linkedFile.getFile().linkProperty(), ((Optional)LinkedFilesEditor.this.bibEntry.getValue()).map(BibEntry::getFieldsObservable).orElse(null)});
                case StandardActions.DOWNLOAD_FILE -> Bindings.createBooleanBinding(() -> linkedFile.getFile().isOnlineLink(), (Observable[])new Observable[]{linkedFile.getFile().linkProperty(), ((Optional)LinkedFilesEditor.this.bibEntry.getValue()).map(BibEntry::getFieldsObservable).orElse(null)});
                case StandardActions.REDOWNLOAD_FILE -> Bindings.createBooleanBinding(() -> !linkedFile.getFile().getSourceUrl().isEmpty(), (Observable[])new Observable[]{linkedFile.getFile().sourceUrlProperty(), ((Optional)LinkedFilesEditor.this.bibEntry.getValue()).map(BibEntry::getFieldsObservable).orElse(null)});
                case StandardActions.OPEN_FILE, StandardActions.OPEN_FOLDER, StandardActions.RENAME_FILE_TO_NAME, StandardActions.DELETE_FILE -> Bindings.createBooleanBinding(() -> !linkedFile.getFile().isOnlineLink() && linkedFile.getFile().findIn(LinkedFilesEditor.this.databaseContext, preferencesService.getFilePreferences()).isPresent(), (Observable[])new Observable[]{linkedFile.getFile().linkProperty(), ((Optional)LinkedFilesEditor.this.bibEntry.getValue()).map(BibEntry::getFieldsObservable).orElse(null)});
                default -> BindingsHelper.constantOf(true);
            });
        }

        public void execute() {
            switch (this.command) {
                case EDIT_FILE_LINK: {
                    this.linkedFile.edit();
                    break;
                }
                case OPEN_FILE: {
                    this.linkedFile.open();
                    break;
                }
                case OPEN_FOLDER: {
                    this.linkedFile.openFolder();
                    break;
                }
                case DOWNLOAD_FILE: {
                    this.linkedFile.download(true);
                    break;
                }
                case REDOWNLOAD_FILE: {
                    this.linkedFile.redownload();
                    break;
                }
                case RENAME_FILE_TO_PATTERN: {
                    this.linkedFile.renameToSuggestion();
                    break;
                }
                case RENAME_FILE_TO_NAME: {
                    this.linkedFile.askForNameAndRename();
                    break;
                }
                case MOVE_FILE_TO_FOLDER: {
                    this.linkedFile.moveToDefaultDirectory();
                    break;
                }
                case MOVE_FILE_TO_FOLDER_AND_RENAME: {
                    this.linkedFile.moveToDefaultDirectoryAndRename();
                    break;
                }
                case DELETE_FILE: {
                    LinkedFilesEditor.this.viewModel.deleteFile(this.linkedFile);
                    break;
                }
                case REMOVE_LINK: {
                    LinkedFilesEditor.this.viewModel.removeFileLink(this.linkedFile);
                }
            }
        }
    }
}

