/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors;

import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.TextInputControl;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javax.swing.undo.UndoManager;
import org.jabref.gui.autocompleter.AutoCompletionTextInputBinding;
import org.jabref.gui.autocompleter.ContentSelectorSuggestionProvider;
import org.jabref.gui.autocompleter.SuggestionProvider;
import org.jabref.gui.fieldeditors.ContextMenuAddable;
import org.jabref.gui.fieldeditors.EditorTextArea;
import org.jabref.gui.fieldeditors.EditorTextField;
import org.jabref.gui.fieldeditors.EditorValidator;
import org.jabref.gui.fieldeditors.FieldEditorFX;
import org.jabref.gui.fieldeditors.SimpleEditorViewModel;
import org.jabref.gui.fieldeditors.contextmenu.DefaultMenu;
import org.jabref.gui.undo.RedoAction;
import org.jabref.gui.undo.UndoAction;
import org.jabref.logic.integrity.FieldCheckers;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.preferences.PreferencesService;

public class SimpleEditor
extends HBox
implements FieldEditorFX {
    private final SimpleEditorViewModel viewModel;
    private final TextInputControl textInput;
    private final boolean isMultiLine;

    public SimpleEditor(Field field, SuggestionProvider<?> suggestionProvider, FieldCheckers fieldCheckers, PreferencesService preferences, boolean isMultiLine, UndoManager undoManager, UndoAction undoAction, RedoAction redoAction) {
        this.viewModel = new SimpleEditorViewModel(field, suggestionProvider, fieldCheckers, undoManager);
        this.isMultiLine = isMultiLine;
        this.textInput = this.createTextInputControl();
        HBox.setHgrow((Node)this.textInput, (Priority)Priority.ALWAYS);
        this.establishBinding(this.textInput, this.viewModel.textProperty(), preferences.getKeyBindingRepository(), undoAction, redoAction);
        ((ContextMenuAddable)this.textInput).initContextMenu(new DefaultMenu(this.textInput), preferences.getKeyBindingRepository());
        this.getChildren().add((Object)this.textInput);
        if (!isMultiLine) {
            AutoCompletionTextInputBinding autoCompleter = AutoCompletionTextInputBinding.autoComplete(this.textInput, this.viewModel::complete, this.viewModel.getAutoCompletionStrategy());
            if (suggestionProvider instanceof ContentSelectorSuggestionProvider) {
                autoCompleter.setShowOnFocus(true);
            }
        }
        new EditorValidator(preferences).configureValidation(this.viewModel.getFieldValidator().getValidationStatus(), this.textInput);
    }

    protected TextInputControl createTextInputControl() {
        return this.isMultiLine ? new EditorTextArea() : new EditorTextField();
    }

    @Override
    public void bindToEntry(BibEntry entry) {
        this.viewModel.bindToEntry(entry);
    }

    @Override
    public Parent getNode() {
        return this;
    }

    public void requestFocus() {
        this.textInput.requestFocus();
    }
}

