/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors.contextmenu;

import com.airhacks.afterburner.injection.Injector;
import de.saxsys.mvvmfx.utils.commands.Command;
import java.util.Objects;
import java.util.Optional;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TextInputControl;
import org.jabref.gui.actions.Action;
import org.jabref.gui.actions.ActionFactory;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.icon.JabRefIcon;
import org.jabref.logic.cleanup.Formatter;
import org.jabref.logic.formatter.casechanger.ProtectTermsFormatter;
import org.jabref.logic.formatter.casechanger.UnprotectTermsFormatter;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.protectedterms.ProtectedTermsList;
import org.jabref.logic.protectedterms.ProtectedTermsLoader;

class ProtectedTermsMenu
extends Menu {
    private static Formatter FORMATTER;
    private final TextInputControl textInputControl;
    private final ActionFactory factory = new ActionFactory();
    private final Action protectSelectionActionInformation = new Action(this){

        @Override
        public String getText() {
            return Localization.lang("Protect selection", new Object[0]);
        }

        @Override
        public Optional<JabRefIcon> getIcon() {
            return Optional.of(IconTheme.JabRefIcons.PROTECT_STRING);
        }

        @Override
        public String getDescription() {
            return Localization.lang("Add {} around selected text", new Object[0]);
        }
    };
    private final Action unprotectSelectionActionInformation = new Action(this){

        @Override
        public String getText() {
            return Localization.lang("Unprotect selection", new Object[0]);
        }

        @Override
        public String getDescription() {
            return Localization.lang("Remove all {} in selected text", new Object[0]);
        }
    };

    public ProtectedTermsMenu(TextInputControl textInputControl) {
        super(Localization.lang("Protect terms", new Object[0]));
        this.textInputControl = textInputControl;
        FORMATTER = new ProtectTermsFormatter((ProtectedTermsLoader)Injector.instantiateModelOrService(ProtectedTermsLoader.class));
        this.getItems().addAll((Object[])new MenuItem[]{this.factory.createMenuItem(this.protectSelectionActionInformation, (Command)new ProtectSelectionAction()), this.getExternalFilesMenu(), new SeparatorMenuItem(), this.factory.createMenuItem(() -> Localization.lang("Format field", new Object[0]), (Command)new FormatFieldAction()), this.factory.createMenuItem(this.unprotectSelectionActionInformation, (Command)new UnprotectSelectionAction())});
    }

    private Menu getExternalFilesMenu() {
        Menu protectedTermsMenu = this.factory.createSubMenu(() -> Localization.lang("Add selected text to list", new Object[0]), new MenuItem[0]);
        ProtectedTermsLoader loader = (ProtectedTermsLoader)Injector.instantiateModelOrService(ProtectedTermsLoader.class);
        loader.getProtectedTermsLists().stream().filter(list -> !list.isInternalList()).forEach(list -> protectedTermsMenu.getItems().add((Object)this.factory.createMenuItem(list::getDescription, (Command)new AddToProtectedTermsAction((ProtectedTermsList)list))));
        if (protectedTermsMenu.getItems().isEmpty()) {
            MenuItem emptyItem = new MenuItem(Localization.lang("No list enabled", new Object[0]));
            emptyItem.setDisable(true);
            protectedTermsMenu.getItems().add((Object)emptyItem);
        }
        return protectedTermsMenu;
    }

    private class ProtectSelectionAction
    extends SimpleCommand {
        ProtectSelectionAction() {
            this.executable.bind((ObservableValue)ProtectedTermsMenu.this.textInputControl.selectedTextProperty().isNotEmpty());
        }

        public void execute() {
            String selectedText = ProtectedTermsMenu.this.textInputControl.getSelectedText();
            String firstStr = "{";
            String lastStr = "}";
            if (selectedText.startsWith(" ")) {
                firstStr = " {";
            }
            if (selectedText.endsWith(" ")) {
                lastStr = "} ";
            }
            ProtectedTermsMenu.this.textInputControl.replaceSelection(firstStr + selectedText.strip() + lastStr);
        }
    }

    private class FormatFieldAction
    extends SimpleCommand {
        FormatFieldAction() {
            this.executable.bind((ObservableValue)ProtectedTermsMenu.this.textInputControl.textProperty().isNotEmpty());
        }

        public void execute() {
            ProtectedTermsMenu.this.textInputControl.setText(FORMATTER.format(ProtectedTermsMenu.this.textInputControl.getText()));
        }
    }

    private class UnprotectSelectionAction
    extends SimpleCommand {
        public UnprotectSelectionAction() {
            this.executable.bind((ObservableValue)ProtectedTermsMenu.this.textInputControl.selectedTextProperty().isNotEmpty());
        }

        public void execute() {
            String selectedText = ProtectedTermsMenu.this.textInputControl.getSelectedText();
            String formattedString = new UnprotectTermsFormatter().format(selectedText);
            ProtectedTermsMenu.this.textInputControl.replaceSelection(formattedString);
        }
    }

    private class AddToProtectedTermsAction
    extends SimpleCommand {
        ProtectedTermsList list;

        public AddToProtectedTermsAction(ProtectedTermsList list) {
            Objects.requireNonNull(list);
            this.list = list;
            this.executable.bind((ObservableValue)ProtectedTermsMenu.this.textInputControl.focusedProperty());
        }

        public void execute() {
            if (ProtectedTermsMenu.this.textInputControl.getSelectedText().isEmpty()) {
                int beginIdx;
                int endIdx = ProtectedTermsMenu.this.textInputControl.getCaretPosition();
                String text = ProtectedTermsMenu.this.textInputControl.getText();
                for (beginIdx = ProtectedTermsMenu.this.textInputControl.getCaretPosition(); beginIdx > 0 && text.charAt(beginIdx - 1) != ' '; --beginIdx) {
                }
                while (endIdx < text.length() && text.charAt(endIdx) != ' ') {
                    ++endIdx;
                }
                this.list.addProtectedTerm(text.substring(beginIdx, endIdx));
            } else {
                this.list.addProtectedTerm(ProtectedTermsMenu.this.textInputControl.getSelectedText().strip());
            }
        }
    }
}

