/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors.identifier;

import java.util.Optional;
import javax.swing.undo.UndoManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.StateManager;
import org.jabref.gui.autocompleter.SuggestionProvider;
import org.jabref.gui.desktop.JabRefDesktop;
import org.jabref.gui.fieldeditors.identifier.BaseIdentifierEditorViewModel;
import org.jabref.gui.mergeentries.FetchAndMergeEntry;
import org.jabref.gui.util.BackgroundTask;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.importer.fetcher.CrossRef;
import org.jabref.logic.integrity.FieldCheckers;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.identifier.DOI;
import org.jabref.preferences.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoiIdentifierEditorViewModel
extends BaseIdentifierEditorViewModel<DOI> {
    public static final Logger LOGGER = LoggerFactory.getLogger(DoiIdentifierEditorViewModel.class);
    private final UndoManager undoManager;
    private final StateManager stateManager;

    public DoiIdentifierEditorViewModel(SuggestionProvider<?> suggestionProvider, FieldCheckers fieldCheckers, DialogService dialogService, TaskExecutor taskExecutor, PreferencesService preferences, UndoManager undoManager, StateManager stateManager) {
        super(StandardField.DOI, suggestionProvider, fieldCheckers, dialogService, taskExecutor, preferences, undoManager);
        this.undoManager = undoManager;
        this.stateManager = stateManager;
        this.configure(true, true);
    }

    @Override
    public void lookupIdentifier(BibEntry bibEntry) {
        CrossRef doiFetcher = new CrossRef();
        BackgroundTask.wrap(() -> doiFetcher.findIdentifier(this.entry)).onRunning(() -> this.identifierLookupInProgress.setValue(Boolean.valueOf(true))).onFinished(() -> this.identifierLookupInProgress.setValue(Boolean.valueOf(false))).onSuccess(identifier -> {
            if (identifier.isPresent()) {
                this.entry.setField(this.field, ((DOI)identifier.get()).getNormalized());
            } else {
                this.dialogService.notify(Localization.lang("No %0 found", this.field.getDisplayName()));
            }
        }).onFailure(e -> this.handleIdentifierFetchingError((Exception)e, doiFetcher)).executeWith(this.taskExecutor);
    }

    @Override
    public void fetchBibliographyInformation(BibEntry bibEntry) {
        this.stateManager.getActiveDatabase().ifPresentOrElse(databaseContext -> new FetchAndMergeEntry((BibDatabaseContext)databaseContext, this.taskExecutor, this.preferences, this.dialogService, this.undoManager).fetchAndMerge(this.entry, this.field), () -> this.dialogService.notify(Localization.lang("No library selected", new Object[0])));
    }

    @Override
    public void openExternalLink() {
        ((Optional)this.identifier.get()).map(DOI::getDOI).ifPresent(s -> JabRefDesktop.openCustomDoi(s, this.preferences, this.dialogService));
    }
}

