/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors.journalinfo;

import com.airhacks.afterburner.views.ViewLoader;
import java.util.Objects;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.chart.LineChart;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;
import org.jabref.gui.fieldeditors.journalinfo.JournalInfoViewModel;
import org.jabref.logic.importer.FetcherException;

public class JournalInfoView
extends VBox {
    @FXML
    private Label title;
    @FXML
    private Label categories;
    @FXML
    private Label publisher;
    @FXML
    private Label hIndex;
    @FXML
    private Label issn;
    @FXML
    private LineChart<String, Double> sjrChart;
    @FXML
    private LineChart<String, Double> citableDocsPrevious3YearsChart;
    @FXML
    private LineChart<String, Double> citesOutgoingChart;
    @FXML
    private LineChart<String, Double> citesOutgoingPerDocChart;
    @FXML
    private LineChart<String, Double> citesIncomingByRecentlyPublishedChart;
    @FXML
    private LineChart<String, Double> docsThisYearChart;
    private final JournalInfoViewModel viewModel = new JournalInfoViewModel();

    public JournalInfoView() {
        ViewLoader.view((Object)((Object)this)).root((Object)this).load();
        this.getStylesheets().add((Object)Objects.requireNonNull(JournalInfoView.class.getResource("JournalInfo.css")).toExternalForm());
        this.title.textProperty().bind((ObservableValue)this.viewModel.titleProperty());
        this.categories.textProperty().bind((ObservableValue)this.viewModel.categoriesProperty());
        this.publisher.textProperty().bind((ObservableValue)this.viewModel.publisherProperty());
        this.hIndex.textProperty().bind((ObservableValue)this.viewModel.hIndexProperty());
        this.issn.textProperty().bind((ObservableValue)this.viewModel.issnProperty());
        this.bindChartProperties();
    }

    public Node populateJournalInformation(String issn, String journalName) throws FetcherException {
        this.viewModel.populateJournalInformation(issn, journalName);
        return this;
    }

    public Node getNode() {
        return this;
    }

    private void bindChartProperties() {
        this.sjrChart.setData(this.viewModel.getSjrData());
        this.citableDocsPrevious3YearsChart.setData(this.viewModel.getCitableDocsPrevious3YearsData());
        this.citesOutgoingChart.setData(this.viewModel.getCitesOutgoingData());
        this.citesOutgoingPerDocChart.setData(this.viewModel.getCitesOutgoingPerDocData());
        this.citesIncomingByRecentlyPublishedChart.setData(this.viewModel.getCitesIncomingByRecentlyPublishedData());
        this.docsThisYearChart.setData(this.viewModel.getDocsThisYearData());
    }
}

