/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors.optioneditors;

import com.airhacks.afterburner.views.ViewLoader;
import javafx.beans.property.Property;
import javafx.fxml.FXML;
import javafx.scene.Parent;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.TextInputControl;
import javafx.scene.layout.HBox;
import org.jabref.gui.fieldeditors.FieldEditorFX;
import org.jabref.gui.fieldeditors.contextmenu.EditorContextAction;
import org.jabref.gui.fieldeditors.optioneditors.OptionEditorViewModel;
import org.jabref.gui.util.ViewModelListCellFactory;
import org.jabref.model.entry.BibEntry;

public class OptionEditor<T>
extends HBox
implements FieldEditorFX {
    @FXML
    private final OptionEditorViewModel<T> viewModel;
    @FXML
    private ComboBox<T> comboBox;

    public OptionEditor(OptionEditorViewModel<T> viewModel) {
        ViewLoader.view((Object)this).root((Object)this).load();
        this.viewModel = viewModel;
        this.comboBox.setConverter(viewModel.getStringConverter());
        this.comboBox.setCellFactory(new ViewModelListCellFactory().withText(viewModel::convertToDisplayText));
        this.comboBox.getItems().setAll(viewModel.getItems());
        this.comboBox.getEditor().textProperty().bindBidirectional((Property)viewModel.textProperty());
        this.comboBox.getEditor().setOnContextMenuRequested(event -> {
            ContextMenu contextMenu = new ContextMenu();
            contextMenu.getItems().setAll(EditorContextAction.getDefaultContextMenuItems((TextInputControl)this.comboBox.getEditor()));
            contextMenu.show(this.comboBox, event.getScreenX(), event.getScreenY());
        });
    }

    public OptionEditorViewModel<T> getViewModel() {
        return this.viewModel;
    }

    @Override
    public void bindToEntry(BibEntry entry) {
        this.viewModel.bindToEntry(entry);
    }

    @Override
    public Parent getNode() {
        return this;
    }
}

