/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.frame;

import com.airhacks.afterburner.injection.Injector;
import com.tobiasdiez.easybind.EasyBind;
import com.tobiasdiez.easybind.EasyObservableList;
import com.tobiasdiez.easybind.Subscription;
import de.saxsys.mvvmfx.utils.commands.Command;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.StringBinding;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.fxmisc.richtext.CodeArea;
import org.jabref.gui.ClipBoardManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.LibraryTab;
import org.jabref.gui.LibraryTabContainer;
import org.jabref.gui.StateManager;
import org.jabref.gui.actions.ActionFactory;
import org.jabref.gui.actions.ActionHelper;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.actions.StandardActions;
import org.jabref.gui.desktop.JabRefDesktop;
import org.jabref.gui.frame.FileHistoryMenu;
import org.jabref.gui.frame.FrameDndHandler;
import org.jabref.gui.frame.JabRefFrameViewModel;
import org.jabref.gui.frame.MainMenu;
import org.jabref.gui.frame.MainToolBar;
import org.jabref.gui.frame.OpenConsoleAction;
import org.jabref.gui.frame.UiMessageHandler;
import org.jabref.gui.importer.NewEntryAction;
import org.jabref.gui.importer.actions.OpenDatabaseAction;
import org.jabref.gui.keyboard.KeyBinding;
import org.jabref.gui.libraryproperties.LibraryPropertiesAction;
import org.jabref.gui.push.PushToApplicationCommand;
import org.jabref.gui.search.GlobalSearchBar;
import org.jabref.gui.search.SearchType;
import org.jabref.gui.sidepane.SidePane;
import org.jabref.gui.sidepane.SidePaneType;
import org.jabref.gui.undo.CountingUndoManager;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.UiCommand;
import org.jabref.logic.journals.JournalAbbreviationRepository;
import org.jabref.logic.search.SearchQuery;
import org.jabref.logic.util.OS;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.model.entry.types.StandardEntryType;
import org.jabref.model.util.FileUpdateMonitor;
import org.jabref.preferences.PreferencesService;
import org.jspecify.annotations.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JabRefFrame
extends BorderPane
implements LibraryTabContainer,
UiMessageHandler {
    public static final String FRAME_TITLE = "JabRef";
    private static final Logger LOGGER = LoggerFactory.getLogger(JabRefFrame.class);
    private final SplitPane splitPane = new SplitPane();
    private final PreferencesService prefs;
    private final GlobalSearchBar globalSearchBar;
    private final FileHistoryMenu fileHistory;
    private final FrameDndHandler frameDndHandler;
    private EasyObservableList<BibDatabaseContext> openDatabaseList;
    private final Stage mainStage;
    private final StateManager stateManager;
    private final CountingUndoManager undoManager;
    private final DialogService dialogService;
    private final FileUpdateMonitor fileUpdateMonitor;
    private final BibEntryTypesManager entryTypesManager;
    private final ClipBoardManager clipBoardManager;
    private final TaskExecutor taskExecutor;
    private final JabRefFrameViewModel viewModel;
    private final PushToApplicationCommand pushToApplicationCommand;
    private final SidePane sidePane;
    private final TabPane tabbedPane = new TabPane();
    private Subscription dividerSubscription;

    public JabRefFrame(Stage mainStage, DialogService dialogService, FileUpdateMonitor fileUpdateMonitor, PreferencesService preferencesService, StateManager stateManager, CountingUndoManager undoManager, BibEntryTypesManager entryTypesManager, ClipBoardManager clipBoardManager, TaskExecutor taskExecutor) {
        this.mainStage = mainStage;
        this.dialogService = dialogService;
        this.fileUpdateMonitor = fileUpdateMonitor;
        this.prefs = preferencesService;
        this.stateManager = stateManager;
        this.undoManager = undoManager;
        this.entryTypesManager = entryTypesManager;
        this.clipBoardManager = clipBoardManager;
        this.taskExecutor = taskExecutor;
        this.setId("frame");
        this.viewModel = new JabRefFrameViewModel(preferencesService, stateManager, dialogService, this, entryTypesManager, fileUpdateMonitor, undoManager, clipBoardManager, taskExecutor);
        Injector.setModelOrService(UiMessageHandler.class, (Object)this.viewModel);
        this.frameDndHandler = new FrameDndHandler(this.tabbedPane, () -> ((Stage)mainStage).getScene(), this::getOpenDatabaseAction, stateManager);
        this.globalSearchBar = new GlobalSearchBar(this, stateManager, this.prefs, undoManager, dialogService, SearchType.NORMAL_SEARCH);
        this.sidePane = new SidePane(this, this.prefs, (JournalAbbreviationRepository)Injector.instantiateModelOrService(JournalAbbreviationRepository.class), taskExecutor, dialogService, stateManager, fileUpdateMonitor, entryTypesManager, clipBoardManager, undoManager);
        this.pushToApplicationCommand = new PushToApplicationCommand(stateManager, dialogService, this.prefs, taskExecutor);
        this.fileHistory = new FileHistoryMenu(this.prefs.getGuiPreferences().getFileHistory(), dialogService, this.getOpenDatabaseAction());
        this.setOnKeyTyped(key -> {
            if (this.fileHistory.isShowing() && this.fileHistory.openFileByKey((KeyEvent)key)) {
                this.fileHistory.getParentMenu().hide();
            }
        });
        this.initLayout();
        this.initKeyBindings();
        this.frameDndHandler.initDragAndDrop();
        this.initBindings();
    }

    private void initLayout() {
        MainToolBar mainToolBar = new MainToolBar(this, this.pushToApplicationCommand, this.globalSearchBar, this.dialogService, this.stateManager, this.prefs, this.fileUpdateMonitor, this.taskExecutor, this.entryTypesManager, this.clipBoardManager, this.undoManager);
        MainMenu mainMenu = new MainMenu(this, this.fileHistory, this.sidePane, this.pushToApplicationCommand, this.prefs, this.stateManager, this.fileUpdateMonitor, this.taskExecutor, this.dialogService, (JournalAbbreviationRepository)Injector.instantiateModelOrService(JournalAbbreviationRepository.class), this.entryTypesManager, this.undoManager, this.clipBoardManager, this::getOpenDatabaseAction);
        VBox head = new VBox(new Node[]{mainMenu, mainToolBar});
        head.setSpacing(0.0);
        this.setTop((Node)head);
        this.splitPane.getItems().addAll((Object[])new Node[]{this.tabbedPane});
        SplitPane.setResizableWithParent((Node)this.sidePane, (Boolean)false);
        this.sidePane.widthProperty().addListener(c -> this.updateSidePane());
        this.sidePane.getChildren().addListener(c -> this.updateSidePane());
        this.updateSidePane();
        this.setCenter((Node)this.splitPane);
    }

    private void updateSidePane() {
        if (this.sidePane.getChildren().isEmpty()) {
            if (this.dividerSubscription != null) {
                this.dividerSubscription.unsubscribe();
            }
            this.splitPane.getItems().remove((Object)this.sidePane);
        } else if (!this.splitPane.getItems().contains((Object)this.sidePane)) {
            this.splitPane.getItems().addFirst((Object)this.sidePane);
            this.updateDividerPosition();
        }
    }

    public void updateDividerPosition() {
        if (this.mainStage.isShowing() && !this.sidePane.getChildren().isEmpty()) {
            this.splitPane.setDividerPositions(new double[]{this.prefs.getGuiPreferences().getSidePaneWidth() / this.splitPane.getWidth()});
            this.dividerSubscription = EasyBind.listen((ObservableValue)this.sidePane.widthProperty(), (obs, old, newVal) -> this.prefs.getGuiPreferences().setSidePaneWidth(newVal.doubleValue()));
        }
    }

    private void initKeyBindings() {
        this.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            Optional<KeyBinding> keyBinding = this.prefs.getKeyBindingRepository().mapToKeyBinding((KeyEvent)event);
            if (keyBinding.isPresent()) {
                switch (keyBinding.get()) {
                    case FOCUS_ENTRY_TABLE: {
                        this.getCurrentLibraryTab().getMainTable().requestFocus();
                        event.consume();
                        break;
                    }
                    case FOCUS_GROUP_LIST: {
                        this.sidePane.getSidePaneComponent(SidePaneType.GROUPS).requestFocus();
                        event.consume();
                        break;
                    }
                    case NEXT_LIBRARY: {
                        this.tabbedPane.getSelectionModel().selectNext();
                        event.consume();
                        break;
                    }
                    case PREVIOUS_LIBRARY: {
                        this.tabbedPane.getSelectionModel().selectPrevious();
                        event.consume();
                        break;
                    }
                    case SEARCH: {
                        this.globalSearchBar.focus();
                        break;
                    }
                    case NEW_ARTICLE: {
                        new NewEntryAction(this::getCurrentLibraryTab, StandardEntryType.Article, this.dialogService, this.prefs, this.stateManager).execute();
                        break;
                    }
                    case NEW_BOOK: {
                        new NewEntryAction(this::getCurrentLibraryTab, StandardEntryType.Book, this.dialogService, this.prefs, this.stateManager).execute();
                        break;
                    }
                    case NEW_INBOOK: {
                        new NewEntryAction(this::getCurrentLibraryTab, StandardEntryType.InBook, this.dialogService, this.prefs, this.stateManager).execute();
                        break;
                    }
                    case NEW_MASTERSTHESIS: {
                        new NewEntryAction(this::getCurrentLibraryTab, StandardEntryType.MastersThesis, this.dialogService, this.prefs, this.stateManager).execute();
                        break;
                    }
                    case NEW_PHDTHESIS: {
                        new NewEntryAction(this::getCurrentLibraryTab, StandardEntryType.PhdThesis, this.dialogService, this.prefs, this.stateManager).execute();
                        break;
                    }
                    case NEW_PROCEEDINGS: {
                        new NewEntryAction(this::getCurrentLibraryTab, StandardEntryType.Proceedings, this.dialogService, this.prefs, this.stateManager).execute();
                        break;
                    }
                    case NEW_TECHREPORT: {
                        new NewEntryAction(this::getCurrentLibraryTab, StandardEntryType.TechReport, this.dialogService, this.prefs, this.stateManager).execute();
                        break;
                    }
                    case NEW_UNPUBLISHED: {
                        new NewEntryAction(this::getCurrentLibraryTab, StandardEntryType.Unpublished, this.dialogService, this.prefs, this.stateManager).execute();
                        break;
                    }
                    case NEW_INPROCEEDINGS: {
                        new NewEntryAction(this::getCurrentLibraryTab, StandardEntryType.InProceedings, this.dialogService, this.prefs, this.stateManager).execute();
                        break;
                    }
                    case PASTE: {
                        if (!OS.OS_X || this.stateManager.getFocusOwner().isPresent() && this.stateManager.getFocusOwner().get() instanceof CodeArea) break;
                        event.consume();
                        break;
                    }
                }
            }
        });
    }

    private void initBindings() {
        FilteredList filteredTabs = new FilteredList(this.tabbedPane.getTabs());
        filteredTabs.setPredicate(LibraryTab.class::isInstance);
        this.openDatabaseList = EasyBind.map((ObservableList)filteredTabs, tab -> ((LibraryTab)((Object)tab)).getBibDatabaseContext());
        EasyBind.bindContent(this.stateManager.getOpenDatabases(), this.openDatabaseList);
        EasyBind.subscribe(this.stateManager.activeSearchQueryProperty(), query -> {
            if (this.prefs.getSearchPreferences().shouldKeepSearchString()) {
                for (LibraryTab tab : this.getLibraryTabs()) {
                    tab.setCurrentSearchQuery((Optional<SearchQuery>)query);
                }
            } else if (this.getCurrentLibraryTab() != null) {
                this.getCurrentLibraryTab().setCurrentSearchQuery((Optional<SearchQuery>)query);
            }
        });
        Platform.runLater(() -> this.stateManager.focusOwnerProperty().bind((ObservableValue)EasyBind.map((ObservableValue)this.mainStage.getScene().focusOwnerProperty(), Optional::ofNullable)));
        EasyBind.subscribe((ObservableValue)this.tabbedPane.getSelectionModel().selectedItemProperty(), selectedTab -> {
            if (selectedTab instanceof LibraryTab) {
                LibraryTab libraryTab = (LibraryTab)((Object)selectedTab);
                this.stateManager.setActiveDatabase(libraryTab.getBibDatabaseContext());
                this.stateManager.activeTabProperty().set(Optional.of(libraryTab));
            } else if (selectedTab == null) {
                this.stateManager.setActiveDatabase(null);
                this.stateManager.activeTabProperty().set(Optional.empty());
            }
        });
        EasyBind.subscribe((ObservableValue)this.tabbedPane.getSelectionModel().selectedItemProperty(), tab -> {
            if (!(tab instanceof LibraryTab)) {
                this.stateManager.setSelectedEntries(Collections.emptyList());
                this.mainStage.titleProperty().unbind();
                this.mainStage.setTitle(FRAME_TITLE);
                return;
            }
            LibraryTab libraryTab = (LibraryTab)((Object)tab);
            this.stateManager.setSelectedEntries(libraryTab.getSelectedEntries());
            if (this.prefs.getSearchPreferences().shouldKeepSearchString() && libraryTab.getCurrentSearchQuery().isEmpty() && ((Optional)this.stateManager.activeSearchQueryProperty().get()).isPresent()) {
                libraryTab.setCurrentSearchQuery((Optional)this.stateManager.activeSearchQueryProperty().get());
            } else {
                this.stateManager.activeSearchQueryProperty().set(libraryTab.getCurrentSearchQuery());
            }
            this.globalSearchBar.setAutoCompleter(libraryTab.getAutoCompleter());
            libraryTab.getMainTable().requestFocus();
            StringBinding windowTitle = Bindings.createStringBinding(() -> libraryTab.textProperty().getValue() + " \u2013 JabRef", (Observable[])new Observable[]{libraryTab.textProperty()});
            this.mainStage.titleProperty().bind((ObservableValue)windowTitle);
        });
    }

    @Override
    public @NonNull List<LibraryTab> getLibraryTabs() {
        return this.tabbedPane.getTabs().stream().filter(LibraryTab.class::isInstance).map(LibraryTab.class::cast).toList();
    }

    @Override
    public LibraryTab getCurrentLibraryTab() {
        if (this.tabbedPane.getSelectionModel().getSelectedItem() == null) {
            return null;
        }
        return (LibraryTab)((Object)this.tabbedPane.getSelectionModel().getSelectedItem());
    }

    @Override
    public void showLibraryTab(@NonNull LibraryTab libraryTab) {
        this.tabbedPane.getSelectionModel().select((Object)libraryTab);
    }

    @Override
    public void addTab(@NonNull BibDatabaseContext databaseContext, boolean raisePanel) {
        Objects.requireNonNull(databaseContext);
        LibraryTab libraryTab = LibraryTab.createLibraryTab(databaseContext, this, this.dialogService, this.prefs, this.stateManager, this.fileUpdateMonitor, this.entryTypesManager, this.undoManager, this.clipBoardManager, this.taskExecutor);
        this.addTab(libraryTab, raisePanel);
    }

    @Override
    public void addTab(@NonNull LibraryTab libraryTab, boolean raisePanel) {
        this.tabbedPane.getTabs().add((Object)libraryTab);
        if (raisePanel) {
            this.tabbedPane.getSelectionModel().select((Object)libraryTab);
            this.tabbedPane.requestFocus();
        }
        libraryTab.setContextMenu(this.createTabContextMenuFor(libraryTab));
    }

    private ContextMenu createTabContextMenuFor(LibraryTab tab) {
        ContextMenu contextMenu = new ContextMenu();
        ActionFactory factory = new ActionFactory();
        Object[] objectArray = new MenuItem[7];
        objectArray[0] = factory.createMenuItem(StandardActions.LIBRARY_PROPERTIES, (Command)new LibraryPropertiesAction(tab::getBibDatabaseContext, this.stateManager));
        objectArray[1] = factory.createMenuItem(StandardActions.OPEN_DATABASE_FOLDER, (Command)new OpenDatabaseFolder(tab::getBibDatabaseContext));
        objectArray[2] = factory.createMenuItem(StandardActions.OPEN_CONSOLE, (Command)new OpenConsoleAction(tab::getBibDatabaseContext, this.stateManager, this.prefs, this.dialogService));
        objectArray[3] = new SeparatorMenuItem();
        objectArray[4] = factory.createMenuItem(StandardActions.CLOSE_LIBRARY, (Command)new CloseDatabaseAction(this, tab, this.stateManager));
        objectArray[5] = factory.createMenuItem(StandardActions.CLOSE_OTHER_LIBRARIES, (Command)new CloseOthersDatabaseAction(tab));
        objectArray[6] = factory.createMenuItem(StandardActions.CLOSE_ALL_LIBRARIES, (Command)new CloseAllDatabaseAction());
        contextMenu.getItems().addAll(objectArray);
        return contextMenu;
    }

    public boolean close() {
        return this.viewModel.close();
    }

    @Override
    public boolean closeTab(LibraryTab tab) {
        return this.closeTabs(List.of(tab));
    }

    @Override
    public boolean closeTabs(@NonNull List<LibraryTab> tabs) {
        List<LibraryTab> toClose = tabs.stream().distinct().filter(this.getLibraryTabs()::contains).toList();
        if (toClose.isEmpty()) {
            return true;
        }
        for (LibraryTab libraryTab : toClose) {
            if (libraryTab.requestClose()) continue;
            return false;
        }
        for (LibraryTab libraryTab : toClose) {
            this.tabbedPane.getTabs().remove((Object)libraryTab);
            Event.fireEvent((EventTarget)libraryTab, (Event)new Event((Object)this, (EventTarget)libraryTab, Tab.CLOSED_EVENT));
        }
        return true;
    }

    private OpenDatabaseAction getOpenDatabaseAction() {
        return new OpenDatabaseAction(this, this.prefs, this.dialogService, this.stateManager, this.fileUpdateMonitor, this.entryTypesManager, this.undoManager, this.clipBoardManager, this.taskExecutor);
    }

    @Override
    public void refresh() {
        this.globalSearchBar.updateHintVisibility();
        this.getLibraryTabs().forEach(LibraryTab::setupMainPanel);
        this.getLibraryTabs().forEach(tab -> tab.getMainTable().getTableModel().resetFieldFormatter());
    }

    public void openLastEditedDatabases() {
        ObservableList<Path> lastFiles = this.prefs.getGuiPreferences().getLastFilesOpened();
        if (lastFiles.isEmpty()) {
            return;
        }
        this.getOpenDatabaseAction().openFiles((List<Path>)lastFiles);
    }

    public Stage getMainStage() {
        return this.mainStage;
    }

    @Override
    public void handleUiCommands(List<UiCommand> uiCommands) {
        this.viewModel.handleUiCommands(uiCommands);
    }

    private class OpenDatabaseFolder
    extends SimpleCommand {
        private final Supplier<BibDatabaseContext> databaseContext;

        public OpenDatabaseFolder(Supplier<BibDatabaseContext> databaseContext) {
            this.databaseContext = databaseContext;
        }

        public void execute() {
            Optional.of(this.databaseContext.get()).flatMap(BibDatabaseContext::getDatabasePath).ifPresent(path -> {
                try {
                    JabRefDesktop.openFolderAndSelectFile(path, JabRefFrame.this.prefs.getExternalApplicationsPreferences(), JabRefFrame.this.dialogService);
                }
                catch (IOException e) {
                    LOGGER.info("Could not open folder", (Throwable)e);
                }
            });
        }
    }

    protected static class CloseDatabaseAction
    extends SimpleCommand {
        private final LibraryTabContainer tabContainer;
        private final LibraryTab libraryTab;

        public CloseDatabaseAction(LibraryTabContainer tabContainer, LibraryTab libraryTab, StateManager stateManager) {
            this.tabContainer = tabContainer;
            this.libraryTab = libraryTab;
            this.executable.bind((ObservableValue)ActionHelper.needsDatabase(stateManager));
        }

        public CloseDatabaseAction(LibraryTabContainer tabContainer, StateManager stateManager) {
            this(tabContainer, null, stateManager);
        }

        public void execute() {
            Platform.runLater(() -> {
                if (this.libraryTab == null) {
                    if (this.tabContainer.getCurrentLibraryTab() == null) {
                        LOGGER.error("No library tab to close");
                        return;
                    }
                    this.tabContainer.closeTab(this.tabContainer.getCurrentLibraryTab());
                } else {
                    this.tabContainer.closeTab(this.libraryTab);
                }
            });
        }
    }

    private class CloseOthersDatabaseAction
    extends SimpleCommand {
        private final LibraryTab libraryTab;

        public CloseOthersDatabaseAction(LibraryTab libraryTab) {
            this.libraryTab = libraryTab;
            this.executable.bind((ObservableValue)ActionHelper.needsMultipleDatabases(JabRefFrame.this.tabbedPane));
        }

        public void execute() {
            LibraryTab toKeepLibraryTab = Optional.of(this.libraryTab).get();
            for (Tab tab : JabRefFrame.this.tabbedPane.getTabs()) {
                LibraryTab libraryTab = (LibraryTab)tab;
                if (libraryTab == toKeepLibraryTab) continue;
                Platform.runLater(() -> JabRefFrame.this.closeTab(libraryTab));
            }
        }
    }

    private class CloseAllDatabaseAction
    extends SimpleCommand {
        private CloseAllDatabaseAction() {
        }

        public void execute() {
            for (Tab tab : JabRefFrame.this.tabbedPane.getTabs()) {
                Platform.runLater(() -> JabRefFrame.this.closeTab((LibraryTab)tab));
            }
        }
    }

    protected static class CloseAction
    extends SimpleCommand {
        private final JabRefFrame frame;

        public CloseAction(JabRefFrame frame) {
            this.frame = frame;
        }

        public void execute() {
            if (this.frame.viewModel.close()) {
                this.frame.mainStage.close();
            }
        }
    }
}

