/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.frame;

import com.tobiasdiez.easybind.EasyBind;
import de.saxsys.mvvmfx.utils.commands.Command;
import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Orientation;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.Separator;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.shape.Rectangle;
import org.controlsfx.control.PopOver;
import org.controlsfx.control.TaskProgressView;
import org.jabref.gui.ClipBoardManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.LibraryTabContainer;
import org.jabref.gui.StateManager;
import org.jabref.gui.actions.ActionFactory;
import org.jabref.gui.actions.ActionHelper;
import org.jabref.gui.actions.StandardActions;
import org.jabref.gui.bibtexextractor.ExtractBibtexAction;
import org.jabref.gui.citationkeypattern.GenerateCitationKeyAction;
import org.jabref.gui.cleanup.CleanupAction;
import org.jabref.gui.edit.EditAction;
import org.jabref.gui.edit.OpenBrowserAction;
import org.jabref.gui.exporter.SaveAction;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.importer.GenerateEntryFromIdDialog;
import org.jabref.gui.importer.NewDatabaseAction;
import org.jabref.gui.importer.NewEntryAction;
import org.jabref.gui.importer.actions.OpenDatabaseAction;
import org.jabref.gui.push.PushToApplicationCommand;
import org.jabref.gui.search.GlobalSearchBar;
import org.jabref.gui.undo.CountingUndoManager;
import org.jabref.gui.undo.RedoAction;
import org.jabref.gui.undo.UndoAction;
import org.jabref.gui.util.BackgroundTask;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.model.entry.types.StandardEntryType;
import org.jabref.model.util.FileUpdateMonitor;
import org.jabref.preferences.PreferencesService;

public class MainToolBar
extends ToolBar {
    private final LibraryTabContainer frame;
    private final PushToApplicationCommand pushToApplicationCommand;
    private final GlobalSearchBar globalSearchBar;
    private final DialogService dialogService;
    private final StateManager stateManager;
    private final PreferencesService preferencesService;
    private final FileUpdateMonitor fileUpdateMonitor;
    private final TaskExecutor taskExecutor;
    private final BibEntryTypesManager entryTypesManager;
    private final ClipBoardManager clipBoardManager;
    private final CountingUndoManager undoManager;
    private PopOver entryFromIdPopOver;
    private PopOver progressViewPopOver;

    public MainToolBar(LibraryTabContainer tabContainer, PushToApplicationCommand pushToApplicationCommand, GlobalSearchBar globalSearchBar, DialogService dialogService, StateManager stateManager, PreferencesService preferencesService, FileUpdateMonitor fileUpdateMonitor, TaskExecutor taskExecutor, BibEntryTypesManager entryTypesManager, ClipBoardManager clipBoardManager, CountingUndoManager undoManager) {
        this.frame = tabContainer;
        this.pushToApplicationCommand = pushToApplicationCommand;
        this.globalSearchBar = globalSearchBar;
        this.dialogService = dialogService;
        this.stateManager = stateManager;
        this.preferencesService = preferencesService;
        this.fileUpdateMonitor = fileUpdateMonitor;
        this.taskExecutor = taskExecutor;
        this.entryTypesManager = entryTypesManager;
        this.clipBoardManager = clipBoardManager;
        this.undoManager = undoManager;
        this.createToolBar();
    }

    private void createToolBar() {
        ActionFactory factory = new ActionFactory();
        Region leftSpacer = new Region();
        Region rightSpacer = new Region();
        Button pushToApplicationButton = factory.createIconButton(this.pushToApplicationCommand.getAction(), (Command)this.pushToApplicationCommand);
        this.pushToApplicationCommand.registerReconfigurable(pushToApplicationButton);
        Object[] objectArray = new Node[13];
        Node[] nodeArray = new Node[3];
        nodeArray[0] = factory.createIconButton(StandardActions.NEW_LIBRARY, (Command)new NewDatabaseAction(this.frame, this.preferencesService));
        nodeArray[1] = factory.createIconButton(StandardActions.OPEN_LIBRARY, (Command)new OpenDatabaseAction(this.frame, this.preferencesService, this.dialogService, this.stateManager, this.fileUpdateMonitor, this.entryTypesManager, this.undoManager, this.clipBoardManager, this.taskExecutor));
        nodeArray[2] = factory.createIconButton(StandardActions.SAVE_LIBRARY, (Command)new SaveAction(SaveAction.SaveMethod.SAVE, this.frame::getCurrentLibraryTab, this.dialogService, this.preferencesService, this.stateManager));
        objectArray[0] = new HBox(nodeArray);
        objectArray[1] = leftSpacer;
        objectArray[2] = this.globalSearchBar;
        objectArray[3] = rightSpacer;
        Node[] nodeArray2 = new Node[5];
        nodeArray2[0] = factory.createIconButton(StandardActions.NEW_ARTICLE, (Command)new NewEntryAction(this.frame::getCurrentLibraryTab, StandardEntryType.Article, this.dialogService, this.preferencesService, this.stateManager));
        nodeArray2[1] = factory.createIconButton(StandardActions.NEW_ENTRY, (Command)new NewEntryAction(this.frame::getCurrentLibraryTab, this.dialogService, this.preferencesService, this.stateManager));
        nodeArray2[2] = this.createNewEntryFromIdButton();
        nodeArray2[3] = factory.createIconButton(StandardActions.NEW_ENTRY_FROM_PLAIN_TEXT, (Command)new ExtractBibtexAction(this.dialogService, this.preferencesService, this.stateManager));
        nodeArray2[4] = factory.createIconButton(StandardActions.DELETE_ENTRY, (Command)new EditAction(StandardActions.DELETE_ENTRY, this.frame::getCurrentLibraryTab, this.stateManager, this.undoManager));
        objectArray[4] = new HBox(nodeArray2);
        objectArray[5] = new Separator(Orientation.VERTICAL);
        Node[] nodeArray3 = new Node[5];
        nodeArray3[0] = factory.createIconButton(StandardActions.UNDO, (Command)new UndoAction(this.frame::getCurrentLibraryTab, this.dialogService, this.stateManager));
        nodeArray3[1] = factory.createIconButton(StandardActions.REDO, (Command)new RedoAction(this.frame::getCurrentLibraryTab, this.dialogService, this.stateManager));
        nodeArray3[2] = factory.createIconButton(StandardActions.CUT, (Command)new EditAction(StandardActions.CUT, this.frame::getCurrentLibraryTab, this.stateManager, this.undoManager));
        nodeArray3[3] = factory.createIconButton(StandardActions.COPY, (Command)new EditAction(StandardActions.COPY, this.frame::getCurrentLibraryTab, this.stateManager, this.undoManager));
        nodeArray3[4] = factory.createIconButton(StandardActions.PASTE, (Command)new EditAction(StandardActions.PASTE, this.frame::getCurrentLibraryTab, this.stateManager, this.undoManager));
        objectArray[6] = new HBox(nodeArray3);
        objectArray[7] = new Separator(Orientation.VERTICAL);
        Node[] nodeArray4 = new Node[3];
        nodeArray4[0] = pushToApplicationButton;
        nodeArray4[1] = factory.createIconButton(StandardActions.GENERATE_CITE_KEYS, (Command)new GenerateCitationKeyAction(this.frame::getCurrentLibraryTab, this.dialogService, this.stateManager, this.taskExecutor, this.preferencesService, this.undoManager));
        nodeArray4[2] = factory.createIconButton(StandardActions.CLEANUP_ENTRIES, (Command)new CleanupAction(this.frame::getCurrentLibraryTab, this.preferencesService, this.dialogService, this.stateManager, this.taskExecutor, this.undoManager));
        objectArray[8] = new HBox(nodeArray4);
        objectArray[9] = new Separator(Orientation.VERTICAL);
        objectArray[10] = new HBox(new Node[]{this.createTaskIndicator()});
        objectArray[11] = new Separator(Orientation.VERTICAL);
        objectArray[12] = new HBox(new Node[]{factory.createIconButton(StandardActions.OPEN_GITHUB, (Command)new OpenBrowserAction("https://github.com/JabRef/jabref", this.dialogService, this.preferencesService.getFilePreferences()))});
        this.getItems().addAll(objectArray);
        leftSpacer.setPrefWidth(50.0);
        leftSpacer.setMinWidth(Double.NEGATIVE_INFINITY);
        leftSpacer.setMaxWidth(Double.NEGATIVE_INFINITY);
        HBox.setHgrow((Node)this.globalSearchBar, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)rightSpacer, (Priority)Priority.SOMETIMES);
        this.getStyleClass().add((Object)"mainToolbar");
    }

    Button createNewEntryFromIdButton() {
        Button newEntryFromIdButton = new Button();
        newEntryFromIdButton.setGraphic(IconTheme.JabRefIcons.IMPORT.getGraphicNode());
        newEntryFromIdButton.getStyleClass().setAll((Object[])new String[]{"icon-button"});
        newEntryFromIdButton.setFocusTraversable(false);
        newEntryFromIdButton.disableProperty().bind((ObservableValue)ActionHelper.needsDatabase(this.stateManager).not());
        newEntryFromIdButton.setOnMouseClicked(event -> {
            GenerateEntryFromIdDialog entryFromId = new GenerateEntryFromIdDialog(this.frame.getCurrentLibraryTab(), this.dialogService, this.preferencesService, this.taskExecutor, this.stateManager);
            if (this.entryFromIdPopOver == null) {
                this.entryFromIdPopOver = new PopOver((Node)entryFromId.getDialogPane());
                this.entryFromIdPopOver.setTitle(Localization.lang("Import by ID", new Object[0]));
                this.entryFromIdPopOver.setArrowLocation(PopOver.ArrowLocation.TOP_CENTER);
                this.entryFromIdPopOver.setContentNode((Node)entryFromId.getDialogPane());
                this.entryFromIdPopOver.show((Node)newEntryFromIdButton);
                entryFromId.setEntryFromIdPopOver(this.entryFromIdPopOver);
            } else if (this.entryFromIdPopOver.isShowing()) {
                this.entryFromIdPopOver.hide();
            } else {
                this.entryFromIdPopOver.setContentNode((Node)entryFromId.getDialogPane());
                this.entryFromIdPopOver.show((Node)newEntryFromIdButton);
                entryFromId.setEntryFromIdPopOver(this.entryFromIdPopOver);
            }
        });
        newEntryFromIdButton.setTooltip(new Tooltip(Localization.lang("Import by ID", new Object[0])));
        return newEntryFromIdButton;
    }

    Group createTaskIndicator() {
        ProgressIndicator indicator = new ProgressIndicator();
        indicator.getStyleClass().add((Object)"progress-indicatorToolbar");
        indicator.progressProperty().bind(this.stateManager.getTasksProgress());
        Tooltip someTasksRunning = new Tooltip(Localization.lang("Background Tasks are running", new Object[0]));
        Tooltip noTasksRunning = new Tooltip(Localization.lang("Background Tasks are done", new Object[0]));
        indicator.setTooltip(noTasksRunning);
        this.stateManager.getAnyTaskRunning().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                indicator.setTooltip(someTasksRunning);
            } else {
                indicator.setTooltip(noTasksRunning);
            }
        });
        indicator.widthProperty().addListener((observable, oldValue, newValue) -> {
            if (!indicator.isIndeterminate()) {
                indicator.setPrefWidth(newValue.doubleValue());
            }
            if (newValue.doubleValue() > 0.0) {
                Rectangle clip = new Rectangle(newValue.doubleValue(), newValue.doubleValue());
                indicator.setClip((Node)clip);
            }
        });
        indicator.setOnMouseClicked(event -> {
            TaskProgressView taskProgressView = new TaskProgressView();
            EasyBind.bindContent((List)taskProgressView.getTasks(), this.stateManager.getBackgroundTasks());
            taskProgressView.setRetainTasks(true);
            taskProgressView.setGraphicFactory(BackgroundTask::getIcon);
            if (this.progressViewPopOver == null) {
                this.progressViewPopOver = new PopOver((Node)taskProgressView);
                this.progressViewPopOver.setTitle(Localization.lang("Background Tasks", new Object[0]));
                this.progressViewPopOver.setArrowLocation(PopOver.ArrowLocation.RIGHT_TOP);
                this.progressViewPopOver.setContentNode((Node)taskProgressView);
                this.progressViewPopOver.show((Node)indicator);
            } else if (this.progressViewPopOver.isShowing()) {
                this.progressViewPopOver.hide();
            } else {
                this.progressViewPopOver.setContentNode((Node)taskProgressView);
                this.progressViewPopOver.show((Node)indicator);
            }
        });
        return new Group(new Node[]{indicator});
    }
}

