/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.frame;

import java.util.List;
import javafx.concurrent.Task;
import org.jabref.gui.DialogService;
import org.jabref.gui.LibraryTab;
import org.jabref.gui.util.UiTaskExecutor;
import org.jabref.logic.l10n.Localization;

public class ProcessingLibraryDialog {
    private final DialogService dialogService;

    public ProcessingLibraryDialog(DialogService dialogService) {
        this.dialogService = dialogService;
    }

    public void showAndWait(final List<LibraryTab> libraryTabs) {
        if (libraryTabs.stream().anyMatch(tab -> tab.isSaving())) {
            Task<Void> waitForSaveFinished = new Task<Void>(this){

                protected Void call() throws Exception {
                    while (libraryTabs.stream().anyMatch(tab -> tab.isSaving())) {
                        if (this.isCancelled()) {
                            return null;
                        }
                        Thread.sleep(100L);
                    }
                    return null;
                }
            };
            UiTaskExecutor.runInJavaFXThread((Runnable)waitForSaveFinished);
            this.dialogService.showProgressDialogAndWait(Localization.lang("Please wait...", new Object[0]), Localization.lang("Waiting for save operation to finish...", new Object[0]), waitForSaveFinished);
        }
    }
}

