/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.frame;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import javafx.collections.ObservableList;
import org.jabref.architecture.AllowedToUseAwt;
import org.jabref.gui.DialogService;
import org.jabref.gui.StateManager;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.desktop.JabRefDesktop;
import org.jabref.gui.util.BackgroundTask;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.io.FileUtil;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.preferences.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AllowedToUseAwt(value="Requires AWT to send an email")
public abstract class SendAsEMailAction
extends SimpleCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(SendAsEMailAction.class);
    private final DialogService dialogService;
    private final PreferencesService preferencesService;
    private final StateManager stateManager;
    private final TaskExecutor taskExecutor;

    public SendAsEMailAction(DialogService dialogService, PreferencesService preferencesService, StateManager stateManager, TaskExecutor taskExecutor) {
        this.dialogService = dialogService;
        this.preferencesService = preferencesService;
        this.stateManager = stateManager;
        this.taskExecutor = taskExecutor;
    }

    public void execute() {
        BackgroundTask.wrap(this::sendEmail).onSuccess(this.dialogService::notify).onFailure(e -> {
            String message = Localization.lang("Error creating email", new Object[0]);
            LOGGER.warn(message, (Throwable)e);
            this.dialogService.notify(message);
        }).executeWith(this.taskExecutor);
    }

    private String sendEmail() throws Exception {
        if (!Desktop.isDesktopSupported() || this.stateManager.getActiveDatabase().isEmpty()) {
            return Localization.lang("Error creating email", new Object[0]);
        }
        if (this.stateManager.getSelectedEntries().isEmpty()) {
            return Localization.lang("This operation requires one or more entries to be selected.", new Object[0]);
        }
        ObservableList<BibEntry> entries = this.stateManager.getSelectedEntries();
        URI uriMailTo = this.getUriMailTo((List<BibEntry>)entries);
        Desktop desktop = Desktop.getDesktop();
        desktop.mail(uriMailTo);
        return "%s: %d".formatted(Localization.lang("Entries added to an email", new Object[0]), entries.size());
    }

    private URI getUriMailTo(List<BibEntry> entries) throws URISyntaxException {
        StringBuilder mailTo = new StringBuilder();
        mailTo.append(this.getEmailAddress());
        mailTo.append("?Body=").append(this.getBody());
        mailTo.append("&Subject=").append(this.getSubject());
        List<String> attachments = this.getAttachments(entries);
        for (String path : attachments) {
            mailTo.append("&Attachment=\"").append(path);
            mailTo.append("\"");
        }
        return new URI("mailto", mailTo.toString(), null);
    }

    private List<String> getAttachments(List<BibEntry> entries) {
        boolean openFolders = this.preferencesService.getExternalApplicationsPreferences().shouldAutoOpenEmailAttachmentsFolder();
        BibDatabaseContext databaseContext = this.stateManager.getActiveDatabase().get();
        List<Path> fileList = FileUtil.getListOfLinkedFiles(entries, databaseContext.getFileDirectories(this.preferencesService.getFilePreferences()));
        ArrayList<String> attachments = new ArrayList<String>();
        for (Path path : fileList) {
            attachments.add(path.toAbsolutePath().toString());
            if (!openFolders) continue;
            try {
                JabRefDesktop.openFolderAndSelectFile(path.toAbsolutePath(), this.preferencesService.getExternalApplicationsPreferences(), this.dialogService);
            }
            catch (IOException e) {
                LOGGER.debug("Cannot open file", (Throwable)e);
            }
        }
        return attachments;
    }

    protected abstract String getEmailAddress();

    protected abstract String getSubject();

    protected abstract String getBody();
}

