/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.groups;

import com.tobiasdiez.easybind.EasyBind;
import de.saxsys.mvvmfx.utils.commands.Command;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableRow;
import javafx.scene.control.TreeTableView;
import javafx.scene.image.Image;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Text;
import javafx.util.Callback;
import org.controlsfx.control.textfield.CustomTextField;
import org.controlsfx.control.textfield.TextFields;
import org.jabref.gui.DialogService;
import org.jabref.gui.DragAndDropDataFormats;
import org.jabref.gui.StateManager;
import org.jabref.gui.actions.ActionFactory;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.actions.StandardActions;
import org.jabref.gui.groups.GroupDialogHeader;
import org.jabref.gui.groups.GroupNodeViewModel;
import org.jabref.gui.groups.GroupTreeViewModel;
import org.jabref.gui.search.SearchTextField;
import org.jabref.gui.util.BindingsHelper;
import org.jabref.gui.util.ControlHelper;
import org.jabref.gui.util.CustomLocalDragboard;
import org.jabref.gui.util.RecursiveTreeItem;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.gui.util.ViewModelTreeTableCellFactory;
import org.jabref.gui.util.ViewModelTreeTableRowFactory;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.groups.AllEntriesGroup;
import org.jabref.preferences.PreferencesService;
import org.reactfx.util.FxTimer;
import org.reactfx.util.Timer;
import org.reactfx.util.TriConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupTreeView
extends BorderPane {
    private static final Logger LOGGER = LoggerFactory.getLogger(GroupTreeView.class);
    private static final PseudoClass PSEUDOCLASS_ANYSELECTED = PseudoClass.getPseudoClass((String)"any-selected");
    private static final PseudoClass PSEUDOCLASS_ALLSELECTED = PseudoClass.getPseudoClass((String)"all-selected");
    private static final PseudoClass PSEUDOCLASS_ROOTELEMENT = PseudoClass.getPseudoClass((String)"root");
    private static final PseudoClass PSEUDOCLASS_SUBELEMENT = PseudoClass.getPseudoClass((String)"sub");
    private static final double SCROLL_SPEED_UP = 3.0;
    private TreeTableView<GroupNodeViewModel> groupTree;
    private TreeTableColumn<GroupNodeViewModel, GroupNodeViewModel> mainColumn;
    private TreeTableColumn<GroupNodeViewModel, GroupNodeViewModel> numberColumn;
    private TreeTableColumn<GroupNodeViewModel, GroupNodeViewModel> expansionNodeColumn;
    private CustomTextField searchField;
    private final StateManager stateManager;
    private final DialogService dialogService;
    private final TaskExecutor taskExecutor;
    private final PreferencesService preferencesService;
    private GroupTreeViewModel viewModel;
    private CustomLocalDragboard localDragboard;
    private DragExpansionHandler dragExpansionHandler;
    private Timer scrollTimer;
    private double scrollVelocity = 0.0;
    private double scrollableAreaHeight;
    private double upperBorder;
    private double lowerBorder;
    private double baseFactor;

    public GroupTreeView(TaskExecutor taskExecutor, StateManager stateManager, PreferencesService preferencesService, DialogService dialogService) {
        this.taskExecutor = taskExecutor;
        this.stateManager = stateManager;
        this.preferencesService = preferencesService;
        this.dialogService = dialogService;
        this.createNodes();
        this.getStylesheets().add((Object)Objects.requireNonNull(GroupTreeView.class.getResource("GroupTree.css")).toExternalForm());
        this.initialize();
    }

    private void createNodes() {
        this.searchField = SearchTextField.create(this.preferencesService.getKeyBindingRepository());
        this.searchField.setPromptText(Localization.lang("Filter groups...", new Object[0]));
        this.setTop((Node)this.searchField);
        this.mainColumn = new TreeTableColumn();
        this.mainColumn.setId("mainColumn");
        this.mainColumn.setResizable(true);
        this.numberColumn = new TreeTableColumn();
        this.numberColumn.getStyleClass().add((Object)"numberColumn");
        this.numberColumn.setMinWidth(60.0);
        this.numberColumn.setMaxWidth(60.0);
        this.numberColumn.setPrefWidth(60.0);
        this.numberColumn.setResizable(false);
        this.expansionNodeColumn = new TreeTableColumn();
        this.expansionNodeColumn.getStyleClass().add((Object)"expansionNodeColumn");
        this.expansionNodeColumn.setMaxWidth(20.0);
        this.expansionNodeColumn.setMinWidth(20.0);
        this.expansionNodeColumn.setPrefWidth(20.0);
        this.expansionNodeColumn.setResizable(false);
        this.groupTree = new TreeTableView();
        this.groupTree.setId("groupTree");
        this.groupTree.setColumnResizePolicy(TreeTableView.CONSTRAINED_RESIZE_POLICY_FLEX_LAST_COLUMN);
        this.groupTree.getColumns().addAll(List.of(this.mainColumn, this.numberColumn, this.expansionNodeColumn));
        this.setCenter((Node)this.groupTree);
        this.mainColumn.prefWidthProperty().bind((ObservableValue)this.groupTree.widthProperty().subtract(80.0).subtract(15.0));
        Button addNewGroup = new Button(Localization.lang("Add group", new Object[0]));
        addNewGroup.setId("addNewGroup");
        addNewGroup.setMaxWidth(Double.MAX_VALUE);
        HBox.setHgrow((Node)addNewGroup, (Priority)Priority.ALWAYS);
        addNewGroup.setTooltip(new Tooltip(Localization.lang("New group", new Object[0])));
        addNewGroup.setOnAction(event -> this.addNewGroup());
        HBox groupBar = new HBox(new Node[]{addNewGroup});
        groupBar.setId("groupBar");
        this.setBottom((Node)groupBar);
    }

    private void initialize() {
        this.localDragboard = this.stateManager.getLocalDragboard();
        this.viewModel = new GroupTreeViewModel(this.stateManager, this.dialogService, this.preferencesService, this.taskExecutor, this.localDragboard);
        this.groupTree.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.dragExpansionHandler = new DragExpansionHandler();
        Platform.runLater(() -> BindingsHelper.bindContentBidirectional(this.groupTree.getSelectionModel().getSelectedItems(), this.viewModel.selectedGroupsProperty(), newSelectedGroups -> {
            this.groupTree.getSelectionModel().clearSelection();
            newSelectedGroups.forEach(this::selectNode);
        }, this::updateSelection));
        Timer searchTask = FxTimer.create((Duration)Duration.ofMillis(400L), () -> {
            LOGGER.debug("Run group search {}", (Object)this.searchField.getText());
            this.viewModel.filterTextProperty().setValue(this.searchField.textProperty().getValue());
        });
        this.searchField.textProperty().addListener((observable, oldValue, newValue) -> searchTask.restart());
        this.groupTree.rootProperty().bind((ObservableValue)EasyBind.map(this.viewModel.rootGroupProperty(), group -> {
            if (group == null) {
                return null;
            }
            return new RecursiveTreeItem<GroupNodeViewModel>((GroupNodeViewModel)group, (Callback<GroupNodeViewModel, ObservableList<GroupNodeViewModel>>)((Callback)GroupNodeViewModel::getChildren), (Callback<GroupNodeViewModel, BooleanProperty>)((Callback)GroupNodeViewModel::expandedProperty), (ObservableValue<Predicate<GroupNodeViewModel>>)this.viewModel.filterPredicateProperty());
        }));
        new ViewModelTreeTableCellFactory().withText(GroupNodeViewModel::getDisplayName).withIcon(GroupNodeViewModel::getIcon).withTooltip(GroupNodeViewModel::getDescription).install(this.mainColumn);
        new ViewModelTreeTableCellFactory().withGraphic(this::createNumberCell).install(this.numberColumn);
        new ViewModelTreeTableCellFactory().withGraphic(this::getArrowCell).withOnMouseClickedEvent(group -> event -> {
            group.toggleExpansion();
            event.consume();
        }).install(this.expansionNodeColumn);
        new ViewModelTreeTableRowFactory<GroupNodeViewModel>().withContextMenu(this::createContextMenuForGroup).withEventFilter((EventType<Event>)MouseEvent.MOUSE_PRESSED, (row, event) -> {
            if (((MouseEvent)event).getButton() == MouseButton.SECONDARY && !this.stateManager.getSelectedEntries().isEmpty()) {
                event.consume();
            } else {
                StackPane pane;
                EventTarget patt0$temp = event.getTarget();
                if (patt0$temp instanceof StackPane && ((pane = (StackPane)patt0$temp).getStyleClass().contains((Object)"arrow") || pane.getStyleClass().contains((Object)"tree-disclosure-node"))) {
                    event.consume();
                }
            }
        }).withCustomInitializer(row -> {
            row.setDisclosureNode(null);
            row.disclosureNodeProperty().addListener((observable, oldValue, newValue) -> row.setDisclosureNode(null));
        }).setOnDragDetected((TriConsumer<TreeTableRow<GroupNodeViewModel>, GroupNodeViewModel, MouseEvent>)((TriConsumer)this::handleOnDragDetected)).setOnDragDropped((TriConsumer<TreeTableRow<GroupNodeViewModel>, GroupNodeViewModel, DragEvent>)((TriConsumer)this::handleOnDragDropped)).setOnDragExited((TriConsumer<TreeTableRow<GroupNodeViewModel>, GroupNodeViewModel, DragEvent>)((TriConsumer)this::handleOnDragExited)).setOnDragOver((TriConsumer<TreeTableRow<GroupNodeViewModel>, GroupNodeViewModel, DragEvent>)((TriConsumer)this::handleOnDragOver)).withPseudoClass(PSEUDOCLASS_ROOTELEMENT, (Callback<TreeTableRow<GroupNodeViewModel>, ObservableValue<Boolean>>)((Callback)row -> Bindings.createBooleanBinding(() -> row != null && this.groupTree.getRoot() != null && row.getItem() == this.groupTree.getRoot().getValue(), (Observable[])new Observable[]{row.treeItemProperty()}))).withPseudoClass(PSEUDOCLASS_SUBELEMENT, (Callback<TreeTableRow<GroupNodeViewModel>, ObservableValue<Boolean>>)((Callback)row -> Bindings.createBooleanBinding(() -> row != null && this.groupTree.getTreeItemLevel(row.getTreeItem()) > 1, (Observable[])new Observable[]{row.treeItemProperty()}))).install(this.groupTree);
        this.setupDragScrolling();
        this.setupClearButtonField(this.searchField);
    }

    private StackPane getArrowCell(GroupNodeViewModel viewModel) {
        StackPane disclosureNode = new StackPane();
        disclosureNode.visibleProperty().bind((ObservableValue)viewModel.hasChildrenProperty());
        disclosureNode.getStyleClass().setAll((Object[])new String[]{"tree-disclosure-node"});
        StackPane disclosureNodeArrow = new StackPane();
        disclosureNodeArrow.getStyleClass().setAll((Object[])new String[]{"arrow"});
        disclosureNode.getChildren().add((Object)disclosureNodeArrow);
        return disclosureNode;
    }

    private StackPane createNumberCell(GroupNodeViewModel group) {
        StackPane node = new StackPane();
        node.getStyleClass().add((Object)"hits");
        if (!group.isRoot()) {
            BindingsHelper.includePseudoClassWhen((Node)node, PSEUDOCLASS_ANYSELECTED, (ObservableValue<? extends Boolean>)group.anySelectedEntriesMatchedProperty());
            BindingsHelper.includePseudoClassWhen((Node)node, PSEUDOCLASS_ALLSELECTED, (ObservableValue<? extends Boolean>)group.allSelectedEntriesMatchedProperty());
        }
        Text text = new Text();
        EasyBind.subscribe((ObservableValue)this.preferencesService.getGroupsPreferences().displayGroupCountProperty(), shouldDisplayGroupCount -> {
            if (text.textProperty().isBound()) {
                text.textProperty().unbind();
                text.setText("");
            }
            if (shouldDisplayGroupCount.booleanValue()) {
                text.textProperty().bind(group.getHits().map(Number::intValue).map(this::getFormattedNumber));
                Tooltip tooltip = new Tooltip();
                tooltip.textProperty().bind((ObservableValue)group.getHits().asString());
                Tooltip.install((Node)text, (Tooltip)tooltip);
            }
        });
        text.getStyleClass().setAll((Object[])new String[]{"text"});
        text.styleProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
            double font_size = this.preferencesService.getWorkspacePreferences().getMainFontSize();
            double reducedFontSize = font_size > 26.0 ? 0.25 : (font_size > 22.0 ? 0.35 : (font_size > 18.0 ? 0.55 : 0.75));
            return "-fx-font-size: %fem;".formatted(reducedFontSize);
        }, (Observable[])new Observable[]{this.preferencesService.getWorkspacePreferences().mainFontSizeProperty()}));
        node.getChildren().add((Object)text);
        node.setMaxWidth(Double.NEGATIVE_INFINITY);
        return node;
    }

    private void handleOnDragExited(TreeTableRow<GroupNodeViewModel> row, GroupNodeViewModel fieldViewModel, DragEvent dragEvent) {
        ControlHelper.removeDroppingPseudoClasses(row);
    }

    private void handleOnDragDetected(TreeTableRow<GroupNodeViewModel> row, GroupNodeViewModel groupViewModel, MouseEvent event) {
        ArrayList<String> groupsToMove = new ArrayList<String>();
        for (TreeItem selectedItem : row.getTreeTableView().getSelectionModel().getSelectedItems()) {
            if (selectedItem == null || selectedItem.getValue() == null) continue;
            groupsToMove.add(((GroupNodeViewModel)selectedItem.getValue()).getPath());
        }
        if (!groupsToMove.isEmpty()) {
            this.localDragboard.clearAll();
        }
        Dragboard dragboard = row.startDragAndDrop(new TransferMode[]{TransferMode.MOVE});
        dragboard.setDragView((Image)row.snapshot(null, null));
        ClipboardContent content = new ClipboardContent();
        content.put((Object)DragAndDropDataFormats.GROUP, groupsToMove);
        dragboard.setContent((Map)content);
        event.consume();
    }

    private void handleOnDragDropped(TreeTableRow<GroupNodeViewModel> row, GroupNodeViewModel originalItem, DragEvent event) {
        Dragboard dragboard = event.getDragboard();
        boolean success = false;
        if (dragboard.hasContent(DragAndDropDataFormats.GROUP) && ((GroupNodeViewModel)row.getItem()).canAddGroupsIn()) {
            List pathToSources = (List)dragboard.getContent(DragAndDropDataFormats.GROUP);
            LinkedList<GroupNodeViewModel> changedGroups = new LinkedList<GroupNodeViewModel>();
            for (String pathToSource : pathToSources) {
                Optional<GroupNodeViewModel> source = ((GroupNodeViewModel)this.viewModel.rootGroupProperty().get()).getChildByPath(pathToSource);
                if (!source.isPresent() || !source.get().canBeDragged()) continue;
                source.get().draggedOn((GroupNodeViewModel)row.getItem(), ControlHelper.getDroppingMouseLocation(row, event));
                changedGroups.add(source.get());
                success = true;
            }
            this.groupTree.getSelectionModel().clearSelection();
            changedGroups.forEach(value -> this.selectNode((GroupNodeViewModel)value, true));
            if (success) {
                this.viewModel.writeGroupChangesToMetaData();
            }
        }
        if (this.localDragboard.hasBibEntries()) {
            List<BibEntry> entries = this.localDragboard.getBibEntries();
            ((GroupNodeViewModel)row.getItem()).addEntriesToGroup(entries);
            success = true;
        }
        event.setDropCompleted(success);
        event.consume();
    }

    private void handleOnDragOver(TreeTableRow<GroupNodeViewModel> row, GroupNodeViewModel originalItem, DragEvent event) {
        Dragboard dragboard = event.getDragboard();
        if (event.getGestureSource() != row && row.getItem() != null && ((GroupNodeViewModel)row.getItem()).acceptableDrop(dragboard)) {
            event.acceptTransferModes(new TransferMode[]{TransferMode.MOVE, TransferMode.LINK});
            this.dragExpansionHandler.expandGroup((TreeItem<GroupNodeViewModel>)row.getTreeItem());
            if (this.localDragboard.hasBibEntries()) {
                ControlHelper.setDroppingPseudoClasses(row);
            } else {
                ControlHelper.setDroppingPseudoClasses(row, event);
            }
        }
    }

    private void updateSelection(List<TreeItem<GroupNodeViewModel>> newSelectedGroups) {
        if (newSelectedGroups == null || newSelectedGroups.isEmpty()) {
            this.viewModel.selectedGroupsProperty().clear();
        } else {
            List list = newSelectedGroups.stream().filter(model -> model != null && !(((GroupNodeViewModel)model.getValue()).getGroupNode().getGroup() instanceof AllEntriesGroup)).map(TreeItem::getValue).collect(Collectors.toList());
            this.viewModel.selectedGroupsProperty().setAll(list);
        }
    }

    private void selectNode(GroupNodeViewModel value) {
        this.selectNode(value, false);
    }

    private void selectNode(GroupNodeViewModel value, boolean expandParents) {
        this.getTreeItemByValue(value).ifPresent(treeItem -> {
            if (expandParents) {
                for (TreeItem parent = treeItem.getParent(); parent != null; parent = parent.getParent()) {
                    parent.setExpanded(true);
                }
            }
            this.groupTree.getSelectionModel().select(treeItem);
        });
    }

    private Optional<TreeItem<GroupNodeViewModel>> getTreeItemByValue(GroupNodeViewModel value) {
        return this.getTreeItemByValue((TreeItem<GroupNodeViewModel>)this.groupTree.getRoot(), value);
    }

    private Optional<TreeItem<GroupNodeViewModel>> getTreeItemByValue(TreeItem<GroupNodeViewModel> root, GroupNodeViewModel value) {
        TreeItem child;
        if (root == null) {
            return Optional.empty();
        }
        if (((GroupNodeViewModel)root.getValue()).equals(value)) {
            return Optional.of(root);
        }
        Optional<TreeItem<GroupNodeViewModel>> node = Optional.empty();
        Iterator iterator = root.getChildren().iterator();
        while (iterator.hasNext() && !(node = this.getTreeItemByValue((TreeItem<GroupNodeViewModel>)(child = (TreeItem)iterator.next()), value)).isPresent()) {
        }
        return node;
    }

    private void setupDragScrolling() {
        this.scrollTimer = FxTimer.createPeriodic((Duration)Duration.ofMillis(100L), () -> this.getVerticalScrollbar().ifPresent(scrollBar -> {
            double newValue = scrollBar.getValue() + this.scrollVelocity;
            newValue = Math.min(newValue, 1.0);
            newValue = Math.max(newValue, 0.0);
            scrollBar.setValue(newValue);
        }));
        this.groupTree.setOnDragEntered(event -> {
            this.initScrolling();
            this.scrollTimer.restart();
        });
        this.groupTree.setOnDragOver(event -> {
            boolean scrollingDown;
            boolean scrollingUp = event.getY() < this.upperBorder;
            boolean bl = scrollingDown = event.getY() > this.lowerBorder;
            if (!scrollingUp && !scrollingDown) {
                this.scrollVelocity = 0.0;
                return;
            }
            double distanceFromNonScrollableInsideArea = scrollingUp ? this.scrollableAreaHeight - event.getY() : this.scrollableAreaHeight - (this.groupTree.getHeight() - event.getY());
            this.scrollVelocity = this.baseFactor * (1.0 + distanceFromNonScrollableInsideArea) / 10.0;
            if (scrollingUp) {
                this.scrollVelocity = -this.scrollVelocity;
            }
        });
        this.groupTree.setOnScroll(event -> this.scrollTimer.stop());
        this.groupTree.setOnDragDone(event -> this.scrollTimer.stop());
        this.groupTree.setOnDragDropped(event -> this.scrollTimer.stop());
        this.groupTree.setOnDragExited(event -> this.scrollTimer.stop());
    }

    private void initScrolling() {
        int numberOfShownGroups = this.groupTree.getExpandedItemCount();
        if (numberOfShownGroups == 0) {
            this.scrollVelocity = 0.0;
            return;
        }
        double heightOfOneNode = ((Node)this.groupTree.getChildrenUnmodifiable().getFirst()).getLayoutBounds().getHeight();
        this.upperBorder = this.scrollableAreaHeight = Math.min((heightOfOneNode *= 2.0) * 3.0, this.groupTree.getHeight() / 3.0);
        this.lowerBorder = this.groupTree.getHeight() - this.scrollableAreaHeight;
        double totalHeight = heightOfOneNode * (double)numberOfShownGroups;
        this.baseFactor = 20.0 * (1.0 / totalHeight);
    }

    private Optional<ScrollBar> getVerticalScrollbar() {
        for (Node node : this.groupTree.lookupAll(".scroll-bar")) {
            ScrollBar scrollbar;
            if (!(node instanceof ScrollBar) || (scrollbar = (ScrollBar)node).getOrientation() != Orientation.VERTICAL) continue;
            return Optional.of(scrollbar);
        }
        return Optional.empty();
    }

    private ContextMenu createContextMenuForGroup(GroupNodeViewModel group) {
        if (group == null) {
            return null;
        }
        ContextMenu contextMenu = new ContextMenu();
        ActionFactory factory = new ActionFactory();
        Object removeGroup = group.hasSubgroups() && group.canAddGroupsIn() && !group.isRoot() ? new Menu(Localization.lang("Remove group", new Object[0]), null, new MenuItem[]{factory.createMenuItem(StandardActions.GROUP_REMOVE_KEEP_SUBGROUPS, (Command)new ContextAction(StandardActions.GROUP_REMOVE_KEEP_SUBGROUPS, group)), factory.createMenuItem(StandardActions.GROUP_REMOVE_WITH_SUBGROUPS, (Command)new ContextAction(StandardActions.GROUP_REMOVE_WITH_SUBGROUPS, group))}) : factory.createMenuItem(StandardActions.GROUP_REMOVE, (Command)new ContextAction(StandardActions.GROUP_REMOVE, group));
        contextMenu.getItems().addAll((Object[])new MenuItem[]{factory.createMenuItem(StandardActions.GROUP_EDIT, (Command)new ContextAction(StandardActions.GROUP_EDIT, group)), removeGroup, new SeparatorMenuItem(), factory.createMenuItem(StandardActions.GROUP_SUBGROUP_ADD, (Command)new ContextAction(StandardActions.GROUP_SUBGROUP_ADD, group)), factory.createMenuItem(StandardActions.GROUP_SUBGROUP_REMOVE, (Command)new ContextAction(StandardActions.GROUP_SUBGROUP_REMOVE, group)), factory.createMenuItem(StandardActions.GROUP_SUBGROUP_SORT, (Command)new ContextAction(StandardActions.GROUP_SUBGROUP_SORT, group)), factory.createMenuItem(StandardActions.GROUP_SUBGROUP_SORT_REVERSE, (Command)new ContextAction(StandardActions.GROUP_SUBGROUP_SORT_REVERSE, group)), factory.createMenuItem(StandardActions.GROUP_SUBGROUP_SORT_ENTRIES, (Command)new ContextAction(StandardActions.GROUP_SUBGROUP_SORT_ENTRIES, group)), factory.createMenuItem(StandardActions.GROUP_SUBGROUP_SORT_ENTRIES_REVERSE, (Command)new ContextAction(StandardActions.GROUP_SUBGROUP_SORT_ENTRIES_REVERSE, group)), new SeparatorMenuItem(), factory.createMenuItem(StandardActions.GROUP_ENTRIES_ADD, (Command)new ContextAction(StandardActions.GROUP_ENTRIES_ADD, group)), factory.createMenuItem(StandardActions.GROUP_ENTRIES_REMOVE, (Command)new ContextAction(StandardActions.GROUP_ENTRIES_REMOVE, group))});
        contextMenu.getItems().forEach(item -> item.setGraphic(null));
        contextMenu.getStyleClass().add((Object)"context-menu");
        return contextMenu;
    }

    private void addNewGroup() {
        this.viewModel.addNewGroupToRoot();
    }

    private String getFormattedNumber(int hits) {
        if (hits >= 1000000) {
            double millions = (double)hits / 1000000.0;
            return new DecimalFormat("#,##0.#").format(millions) + "m";
        }
        if (hits >= 1000) {
            double thousands = (double)hits / 1000.0;
            return new DecimalFormat("#,##0.#").format(thousands) + "k";
        }
        return Integer.toString(hits);
    }

    private void setupClearButtonField(CustomTextField customTextField) {
        try {
            Method m = TextFields.class.getDeclaredMethod("setupClearButtonField", TextField.class, ObjectProperty.class);
            m.setAccessible(true);
            m.invoke(null, customTextField, customTextField.rightProperty());
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            LOGGER.error("Failed to decorate text field with clear button", (Throwable)ex);
        }
    }

    public void requestFocusGroupTree() {
        this.groupTree.requestFocus();
    }

    private static class DragExpansionHandler {
        private static final long DRAG_TIME_BEFORE_EXPANDING_MS = 1000L;
        private TreeItem<GroupNodeViewModel> draggedItem;
        private long dragStarted;

        private DragExpansionHandler() {
        }

        public void expandGroup(TreeItem<GroupNodeViewModel> treeItem) {
            if (!treeItem.equals(this.draggedItem)) {
                this.draggedItem = treeItem;
                this.dragStarted = System.currentTimeMillis();
                this.draggedItem.setExpanded(this.draggedItem.isExpanded());
                return;
            }
            if (System.currentTimeMillis() - this.dragStarted > 1000L) {
                this.dragStarted = System.currentTimeMillis();
                this.draggedItem.setExpanded(!this.draggedItem.isExpanded());
            } else {
                this.draggedItem.setExpanded(this.draggedItem.isExpanded());
            }
        }
    }

    private class ContextAction
    extends SimpleCommand {
        private final StandardActions command;
        private final GroupNodeViewModel group;

        public ContextAction(StandardActions command, GroupNodeViewModel group) {
            this.command = command;
            this.group = group;
            this.executable.bind(BindingsHelper.constantOf(switch (command) {
                case StandardActions.GROUP_EDIT -> group.isEditable();
                case StandardActions.GROUP_REMOVE, StandardActions.GROUP_REMOVE_WITH_SUBGROUPS, StandardActions.GROUP_REMOVE_KEEP_SUBGROUPS -> {
                    if (group.isEditable() && group.canRemove()) {
                        yield true;
                    }
                    yield false;
                }
                case StandardActions.GROUP_SUBGROUP_ADD -> {
                    if (group.isEditable() && group.canAddGroupsIn() || group.isRoot()) {
                        yield true;
                    }
                    yield false;
                }
                case StandardActions.GROUP_SUBGROUP_REMOVE -> {
                    if (group.isEditable() && group.hasSubgroups() && group.canRemove() || group.isRoot()) {
                        yield true;
                    }
                    yield false;
                }
                case StandardActions.GROUP_SUBGROUP_SORT -> {
                    if (group.isEditable() && group.hasSubgroups() && group.canAddEntriesIn() || group.isRoot()) {
                        yield true;
                    }
                    yield false;
                }
                case StandardActions.GROUP_ENTRIES_ADD, StandardActions.GROUP_ENTRIES_REMOVE -> group.canAddEntriesIn();
                default -> true;
            }));
        }

        public void execute() {
            switch (this.command) {
                case GROUP_REMOVE: {
                    GroupTreeView.this.viewModel.removeGroupNoSubgroups(this.group);
                    break;
                }
                case GROUP_REMOVE_KEEP_SUBGROUPS: {
                    GroupTreeView.this.viewModel.removeGroupKeepSubgroups(this.group);
                    break;
                }
                case GROUP_REMOVE_WITH_SUBGROUPS: {
                    GroupTreeView.this.viewModel.removeGroupAndSubgroups(this.group);
                    break;
                }
                case GROUP_EDIT: {
                    GroupTreeView.this.viewModel.editGroup(this.group);
                    GroupTreeView.this.groupTree.refresh();
                    break;
                }
                case GROUP_SUBGROUP_ADD: {
                    GroupTreeView.this.viewModel.addNewSubgroup(this.group, GroupDialogHeader.SUBGROUP);
                    break;
                }
                case GROUP_SUBGROUP_REMOVE: {
                    GroupTreeView.this.viewModel.removeSubgroups(this.group);
                    break;
                }
                case GROUP_SUBGROUP_SORT: {
                    GroupTreeView.this.viewModel.sortAlphabeticallyRecursive(this.group.getGroupNode());
                    break;
                }
                case GROUP_SUBGROUP_SORT_REVERSE: {
                    GroupTreeView.this.viewModel.sortReverseAlphabeticallyRecursive(this.group.getGroupNode());
                    break;
                }
                case GROUP_SUBGROUP_SORT_ENTRIES: {
                    GroupTreeView.this.viewModel.sortEntriesRecursive(this.group.getGroupNode());
                    break;
                }
                case GROUP_SUBGROUP_SORT_ENTRIES_REVERSE: {
                    GroupTreeView.this.viewModel.sortReverseEntriesRecursive(this.group.getGroupNode());
                    break;
                }
                case GROUP_ENTRIES_ADD: {
                    GroupTreeView.this.viewModel.addSelectedEntries(this.group);
                    break;
                }
                case GROUP_ENTRIES_REMOVE: {
                    GroupTreeView.this.viewModel.removeSelectedEntries(this.group);
                }
            }
        }
    }
}

