/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.help;

import com.airhacks.afterburner.views.ViewLoader;
import jakarta.inject.Inject;
import javafx.fxml.FXML;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.TextArea;
import org.jabref.gui.ClipBoardManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.help.AboutDialogViewModel;
import org.jabref.gui.util.BaseDialog;
import org.jabref.gui.util.ControlHelper;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.BuildInfo;
import org.jabref.preferences.PreferencesService;

public class AboutDialogView
extends BaseDialog<Void> {
    @FXML
    private ButtonType copyVersionButton;
    @FXML
    private TextArea textAreaVersions;
    @Inject
    private DialogService dialogService;
    @Inject
    private PreferencesService preferencesService;
    @Inject
    private ClipBoardManager clipBoardManager;
    @Inject
    private BuildInfo buildInfo;
    private AboutDialogViewModel viewModel;

    public AboutDialogView() {
        this.setTitle(Localization.lang("About JabRef", new Object[0]));
        ViewLoader.view((Object)((Object)this)).load().setAsDialogPane((Dialog)this);
        ControlHelper.setAction(this.copyVersionButton, this.getDialogPane(), event -> this.copyVersionToClipboard());
    }

    public AboutDialogViewModel getViewModel() {
        return this.viewModel;
    }

    @FXML
    private void initialize() {
        this.viewModel = new AboutDialogViewModel(this.dialogService, this.preferencesService, this.clipBoardManager, this.buildInfo);
        this.textAreaVersions.setText(this.viewModel.getVersionInfo());
        this.setResizable(false);
    }

    @FXML
    private void copyVersionToClipboard() {
        this.viewModel.copyVersionToClipboard();
    }

    @FXML
    private void openJabrefWebsite() {
        this.viewModel.openJabrefWebsite();
    }

    @FXML
    private void openExternalLibrariesWebsite() {
        this.viewModel.openExternalLibrariesWebsite();
    }

    @FXML
    private void openGithub() {
        this.viewModel.openGithub();
    }

    @FXML
    public void openChangeLog() {
        this.viewModel.openChangeLog();
    }

    @FXML
    public void openLicense() {
        this.viewModel.openLicense();
    }

    @FXML
    public void openContributors() {
        this.viewModel.openContributors();
    }

    @FXML
    public void openDonation() {
        this.viewModel.openDonation();
    }

    public void openPrivacyPolicy() {
        this.viewModel.openPrivacyPolicy();
    }
}

