/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.importer;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import javafx.beans.value.ObservableValue;
import javafx.stage.FileChooser;
import org.jabref.gui.DialogService;
import org.jabref.gui.LibraryTabContainer;
import org.jabref.gui.StateManager;
import org.jabref.gui.actions.ActionHelper;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.importer.GrobidOptInDialogHelper;
import org.jabref.gui.importer.ImportEntriesDialog;
import org.jabref.gui.util.BackgroundTask;
import org.jabref.gui.util.FileDialogConfiguration;
import org.jabref.gui.util.FileFilterConverter;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.gui.util.UiTaskExecutor;
import org.jabref.logic.database.DatabaseMerger;
import org.jabref.logic.importer.ImportException;
import org.jabref.logic.importer.ImportFormatReader;
import org.jabref.logic.importer.Importer;
import org.jabref.logic.importer.ParserResult;
import org.jabref.logic.importer.fileformat.PdfGrobidImporter;
import org.jabref.logic.importer.fileformat.PdfMergeMetadataImporter;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.UpdateField;
import org.jabref.logic.util.io.FileUtil;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.util.FileUpdateMonitor;
import org.jabref.preferences.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportCommand
extends SimpleCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImportCommand.class);
    private final LibraryTabContainer tabContainer;
    private final ImportMethod importMethod;
    private final DialogService dialogService;
    private final PreferencesService preferencesService;
    private final FileUpdateMonitor fileUpdateMonitor;
    private final TaskExecutor taskExecutor;

    public ImportCommand(LibraryTabContainer tabContainer, ImportMethod importMethod, PreferencesService preferencesService, StateManager stateManager, FileUpdateMonitor fileUpdateMonitor, TaskExecutor taskExecutor, DialogService dialogService) {
        this.tabContainer = tabContainer;
        this.importMethod = importMethod;
        this.preferencesService = preferencesService;
        this.fileUpdateMonitor = fileUpdateMonitor;
        this.taskExecutor = taskExecutor;
        this.dialogService = dialogService;
        if (importMethod == ImportMethod.TO_EXISTING) {
            this.executable.bind((ObservableValue)ActionHelper.needsDatabase(stateManager));
        }
    }

    public void execute() {
        ImportFormatReader importFormatReader = new ImportFormatReader(this.preferencesService.getImporterPreferences(), this.preferencesService.getImportFormatPreferences(), this.preferencesService.getCitationKeyPatternPreferences(), this.fileUpdateMonitor);
        SortedSet<Importer> importers = importFormatReader.getImportFormats();
        FileDialogConfiguration fileDialogConfiguration = new FileDialogConfiguration.Builder().addExtensionFilter(FileFilterConverter.ANY_FILE).addExtensionFilter(FileFilterConverter.forAllImporters(importers)).addExtensionFilter(FileFilterConverter.importerToExtensionFilter(importers)).withInitialDirectory(this.preferencesService.getImporterPreferences().getImportWorkingDirectory()).build();
        this.dialogService.showFileOpenDialog(fileDialogConfiguration).ifPresent(path -> this.importSingleFile((Path)path, importers, fileDialogConfiguration.getSelectedExtensionFilter()));
    }

    private void importSingleFile(Path file, SortedSet<Importer> importers, FileChooser.ExtensionFilter selectedExtensionFilter) {
        if (!Files.exists(file, new LinkOption[0])) {
            this.dialogService.showErrorDialogAndWait(Localization.lang("Import", new Object[0]), Localization.lang("File not found", new Object[0]) + ": '" + String.valueOf(file.getFileName()) + "'.");
            return;
        }
        Optional<Importer> format = FileFilterConverter.getImporter(selectedExtensionFilter, importers);
        BackgroundTask<ParserResult> task = BackgroundTask.wrap(() -> this.doImport(Collections.singletonList(file), format.orElse(null)));
        if (this.importMethod == ImportMethod.AS_NEW) {
            task.onSuccess(parserResult -> {
                this.tabContainer.addTab(parserResult.getDatabaseContext(), true);
                this.dialogService.notify(Localization.lang("Imported entries", new Object[0]) + ": " + parserResult.getDatabase().getEntries().size());
            }).onFailure(ex -> {
                LOGGER.error("Error importing", (Throwable)ex);
                this.dialogService.notify(Localization.lang("Error importing. See the error log for details.", new Object[0]));
            }).executeWith(this.taskExecutor);
        } else {
            ImportEntriesDialog dialog = new ImportEntriesDialog(this.tabContainer.getCurrentLibraryTab().getBibDatabaseContext(), task);
            dialog.setTitle(Localization.lang("Import", new Object[0]));
            this.dialogService.showCustomDialogAndWait(dialog);
        }
        this.preferencesService.getImporterPreferences().setImportWorkingDirectory(file.getParent());
    }

    private ParserResult doImport(List<Path> files, Importer importFormat) throws IOException {
        Optional<Importer> importer = Optional.ofNullable(importFormat);
        ArrayList<ImportFormatReader.UnknownFormatImport> imports = new ArrayList<ImportFormatReader.UnknownFormatImport>();
        ImportFormatReader importFormatReader = new ImportFormatReader(this.preferencesService.getImporterPreferences(), this.preferencesService.getImportFormatPreferences(), this.preferencesService.getCitationKeyPatternPreferences(), this.fileUpdateMonitor);
        for (Path filename : files) {
            try {
                if (importer.isEmpty()) {
                    UiTaskExecutor.runAndWaitInJavaFXThread(() -> {
                        if (FileUtil.isPDFFile(filename) && GrobidOptInDialogHelper.showAndWaitIfUserIsUndecided(this.dialogService, this.preferencesService.getGrobidPreferences())) {
                            importFormatReader.reset();
                        }
                        this.dialogService.notify(Localization.lang("Importing file %0 as unknown format", filename.getFileName().toString()));
                    });
                    imports.add(importFormatReader.importUnknownFormat(filename, this.fileUpdateMonitor));
                    continue;
                }
                UiTaskExecutor.runAndWaitInJavaFXThread(() -> {
                    if ((importer.get() instanceof PdfGrobidImporter || importer.get() instanceof PdfMergeMetadataImporter) && GrobidOptInDialogHelper.showAndWaitIfUserIsUndecided(this.dialogService, this.preferencesService.getGrobidPreferences())) {
                        importFormatReader.reset();
                    }
                    this.dialogService.notify(Localization.lang("Importing in %0 format", ((Importer)importer.get()).getName()) + "...");
                });
                ParserResult pr = importer.get().importDatabase(filename);
                imports.add(new ImportFormatReader.UnknownFormatImport(importer.get().getName(), pr));
            }
            catch (ImportException ex) {
                UiTaskExecutor.runAndWaitInJavaFXThread(() -> this.dialogService.showWarningDialogAndWait(Localization.lang("Import error", new Object[0]), Localization.lang("Please check your library file for wrong syntax.", new Object[0]) + "\n\n" + ex.getLocalizedMessage()));
            }
        }
        if (imports.isEmpty()) {
            UiTaskExecutor.runAndWaitInJavaFXThread(() -> this.dialogService.showWarningDialogAndWait(Localization.lang("Import error", new Object[0]), Localization.lang("No entries found. Please make sure you are using the correct import filter.", new Object[0])));
            return new ParserResult();
        }
        return this.mergeImportResults(imports);
    }

    public ParserResult mergeImportResults(List<ImportFormatReader.UnknownFormatImport> imports) {
        BibDatabase resultDatabase = new BibDatabase();
        ParserResult result = new ParserResult(resultDatabase);
        for (ImportFormatReader.UnknownFormatImport importResult : imports) {
            if (importResult == null) continue;
            ParserResult parserResult = importResult.parserResult();
            resultDatabase.insertEntries((List<BibEntry>)parserResult.getDatabase().getEntries());
            if (!"BibTeX".equals(importResult.format())) continue;
            new DatabaseMerger(this.preferencesService.getBibEntryPreferences().getKeywordSeparator().charValue()).mergeMetaData(result.getMetaData(), parserResult.getMetaData(), importResult.parserResult().getPath().map(path -> path.getFileName().toString()).orElse("unknown"), (List<BibEntry>)parserResult.getDatabase().getEntries());
        }
        UpdateField.setAutomaticFields(resultDatabase.getEntries(), this.preferencesService.getOwnerPreferences(), this.preferencesService.getTimestampPreferences());
        return result;
    }

    public static enum ImportMethod {
        AS_NEW,
        TO_EXISTING;

    }
}

