/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.importer;

import com.airhacks.afterburner.injection.Injector;
import java.util.List;
import java.util.Optional;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.jabref.gui.importer.BibEntryTypePrefsAndFileViewModel;
import org.jabref.model.database.BibDatabaseMode;
import org.jabref.model.entry.BibEntryType;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.model.entry.types.EntryTypeFactory;
import org.jabref.preferences.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportCustomEntryTypesDialogViewModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImportCustomEntryTypesDialogViewModel.class);
    private final BibDatabaseMode mode;
    private final PreferencesService preferencesService;
    private final ObservableList<BibEntryType> newTypes = FXCollections.observableArrayList();
    private final ObservableList<BibEntryTypePrefsAndFileViewModel> differentCustomizationTypes = FXCollections.observableArrayList();

    public ImportCustomEntryTypesDialogViewModel(BibDatabaseMode mode, List<BibEntryType> entryTypes, PreferencesService preferencesService) {
        this.mode = mode;
        this.preferencesService = preferencesService;
        BibEntryTypesManager entryTypesManager = (BibEntryTypesManager)Injector.instantiateModelOrService(BibEntryTypesManager.class);
        for (BibEntryType customType : entryTypes) {
            Optional<BibEntryType> currentlyStoredType = entryTypesManager.enrich(customType.getType(), mode);
            if (currentlyStoredType.isEmpty()) {
                this.newTypes.add((Object)customType);
                continue;
            }
            if (EntryTypeFactory.nameAndFieldsAreEqual(customType, currentlyStoredType.get())) continue;
            LOGGER.info("currently stored type:    {}", (Object)currentlyStoredType.get());
            LOGGER.info("type provided by library: {}", (Object)customType);
            this.differentCustomizationTypes.add((Object)new BibEntryTypePrefsAndFileViewModel(currentlyStoredType.get(), customType));
        }
    }

    public ObservableList<BibEntryType> newTypes() {
        return this.newTypes;
    }

    public ObservableList<BibEntryTypePrefsAndFileViewModel> differentCustomizations() {
        return this.differentCustomizationTypes;
    }

    public void importBibEntryTypes(List<BibEntryType> checkedUnknownEntryTypes, List<BibEntryType> checkedDifferentEntryTypes) {
        BibEntryTypesManager entryTypesManager = (BibEntryTypesManager)Injector.instantiateModelOrService(BibEntryTypesManager.class);
        if (!checkedUnknownEntryTypes.isEmpty()) {
            checkedUnknownEntryTypes.forEach(type -> entryTypesManager.addCustomOrModifiedType((BibEntryType)type, this.mode));
            this.preferencesService.storeCustomEntryTypesRepository(entryTypesManager);
        }
        if (!checkedDifferentEntryTypes.isEmpty()) {
            checkedUnknownEntryTypes.forEach(type -> entryTypesManager.addCustomOrModifiedType((BibEntryType)type, this.mode));
            this.preferencesService.storeCustomEntryTypesRepository(entryTypesManager);
        }
    }
}

