/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.importer;

import java.io.IOException;
import java.io.StringWriter;
import java.util.List;
import java.util.Optional;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.swing.undo.UndoManager;
import org.jabref.gui.AbstractViewModel;
import org.jabref.gui.DialogService;
import org.jabref.gui.StateManager;
import org.jabref.gui.externalfiles.ImportHandler;
import org.jabref.gui.util.BackgroundTask;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.bibtex.BibEntryWriter;
import org.jabref.logic.bibtex.FieldWriter;
import org.jabref.logic.database.DatabaseMerger;
import org.jabref.logic.database.DuplicateCheck;
import org.jabref.logic.exporter.BibWriter;
import org.jabref.logic.importer.ParserResult;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.OS;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.model.util.FileUpdateMonitor;
import org.jabref.preferences.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportEntriesViewModel
extends AbstractViewModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImportEntriesViewModel.class);
    private final StringProperty message;
    private final TaskExecutor taskExecutor;
    private final BibDatabaseContext databaseContext;
    private final DialogService dialogService;
    private final UndoManager undoManager;
    private final StateManager stateManager;
    private final FileUpdateMonitor fileUpdateMonitor;
    private ParserResult parserResult = null;
    private final ObservableList<BibEntry> entries;
    private final PreferencesService preferences;
    private final BibEntryTypesManager entryTypesManager;
    private final ObjectProperty<BibDatabaseContext> selectedDb;

    public ImportEntriesViewModel(BackgroundTask<ParserResult> task, TaskExecutor taskExecutor, BibDatabaseContext databaseContext, DialogService dialogService, UndoManager undoManager, PreferencesService preferences, StateManager stateManager, BibEntryTypesManager entryTypesManager, FileUpdateMonitor fileUpdateMonitor) {
        this.taskExecutor = taskExecutor;
        this.databaseContext = databaseContext;
        this.dialogService = dialogService;
        this.undoManager = undoManager;
        this.preferences = preferences;
        this.stateManager = stateManager;
        this.entryTypesManager = entryTypesManager;
        this.fileUpdateMonitor = fileUpdateMonitor;
        this.entries = FXCollections.observableArrayList();
        this.message = new SimpleStringProperty();
        this.message.bind((ObservableValue)task.messageProperty());
        this.selectedDb = new SimpleObjectProperty();
        task.onSuccess(parserResult -> {
            this.parserResult = parserResult;
            this.entries.addAll(parserResult.getDatabase().getEntries());
            if (this.entries.isEmpty()) {
                task.updateMessage(Localization.lang("No entries corresponding to given query", new Object[0]));
            }
        }).onFailure(ex -> {
            LOGGER.error("Error importing", (Throwable)ex);
            dialogService.showErrorDialogAndWait((Exception)ex);
        }).executeWith(taskExecutor);
    }

    public String getMessage() {
        return (String)this.message.get();
    }

    public StringProperty messageProperty() {
        return this.message;
    }

    public ObjectProperty<BibDatabaseContext> selectedDbProperty() {
        return this.selectedDb;
    }

    public BibDatabaseContext getSelectedDb() {
        return (BibDatabaseContext)this.selectedDb.get();
    }

    public ObservableList<BibEntry> getEntries() {
        return this.entries;
    }

    public boolean hasDuplicate(BibEntry entry) {
        return this.findInternalDuplicate(entry).isPresent() || new DuplicateCheck(this.entryTypesManager).containsDuplicate(((BibDatabaseContext)this.selectedDb.getValue()).getDatabase(), entry, ((BibDatabaseContext)this.selectedDb.getValue()).getMode()).isPresent();
    }

    public String getSourceString(BibEntry entry) {
        StringWriter writer = new StringWriter();
        BibWriter bibWriter = new BibWriter(writer, OS.NEWLINE);
        FieldWriter fieldWriter = FieldWriter.buildIgnoreHashes(this.preferences.getFieldPreferences());
        try {
            new BibEntryWriter(fieldWriter, this.entryTypesManager).write(entry, bibWriter, ((BibDatabaseContext)this.selectedDb.getValue()).getMode());
        }
        catch (IOException ioException) {
            return "";
        }
        return writer.toString();
    }

    public void importEntries(List<BibEntry> entriesToImport, boolean shouldDownloadFiles) {
        this.preferences.getFilePreferences().setDownloadLinkedFiles(shouldDownloadFiles);
        new DatabaseMerger(this.preferences.getBibEntryPreferences().getKeywordSeparator().charValue()).mergeStrings(this.databaseContext.getDatabase(), this.parserResult.getDatabase());
        new DatabaseMerger(this.preferences.getBibEntryPreferences().getKeywordSeparator().charValue()).mergeMetaData(this.databaseContext.getMetaData(), this.parserResult.getMetaData(), this.parserResult.getPath().map(path -> path.getFileName().toString()).orElse("unknown"), (List<BibEntry>)this.parserResult.getDatabase().getEntries());
        this.buildImportHandlerThenImportEntries(entriesToImport);
    }

    private void buildImportHandlerThenImportEntries(List<BibEntry> entriesToImport) {
        ImportHandler importHandler = new ImportHandler((BibDatabaseContext)this.selectedDb.getValue(), this.preferences, this.fileUpdateMonitor, this.undoManager, this.stateManager, this.dialogService, this.taskExecutor);
        importHandler.importEntriesWithDuplicateCheck((BibDatabaseContext)this.selectedDb.getValue(), entriesToImport);
    }

    private Optional<BibEntry> findInternalDuplicate(BibEntry entry) {
        for (BibEntry othEntry : this.entries) {
            if (othEntry.equals(entry) || !new DuplicateCheck(this.entryTypesManager).isDuplicate(entry, othEntry, this.databaseContext.getMode())) continue;
            return Optional.of(othEntry);
        }
        return Optional.empty();
    }
}

