/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.importer;

import java.util.List;
import java.util.Objects;
import org.jabref.gui.DialogService;
import org.jabref.logic.importer.ParserResult;
import org.jabref.logic.l10n.Localization;

public class ParserResultWarningDialog {
    private ParserResultWarningDialog() {
    }

    public static void showParserResultWarningDialog(ParserResult parserResult, DialogService dialogService) {
        Objects.requireNonNull(parserResult);
        if (!parserResult.hasWarnings()) {
            return;
        }
        List<String> warnings = parserResult.warnings();
        StringBuilder dialogContent = new StringBuilder();
        int warningCount = 1;
        for (String warning : warnings) {
            dialogContent.append("%d. %s%n".formatted(warningCount++, warning));
        }
        dialogContent.deleteCharAt(dialogContent.length() - 1);
        Object dialogTitle = parserResult.getPath().isEmpty() ? Localization.lang("Warnings", new Object[0]) : Localization.lang("Warnings", new Object[0]) + " (" + String.valueOf(parserResult.getPath().get().getFileName()) + ")";
        dialogService.showWarningDialogAndWait((String)dialogTitle, dialogContent.toString());
    }
}

