/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.importer.actions;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.swing.undo.UndoManager;
import org.jabref.gui.ClipBoardManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.LibraryTab;
import org.jabref.gui.LibraryTabContainer;
import org.jabref.gui.StateManager;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.autosaveandbackup.BackupManager;
import org.jabref.gui.dialogs.BackupUIManager;
import org.jabref.gui.importer.actions.CheckForNewEntryTypesAction;
import org.jabref.gui.importer.actions.GUIPostOpenAction;
import org.jabref.gui.importer.actions.MergeReviewIntoCommentAction;
import org.jabref.gui.shared.SharedDatabaseUIManager;
import org.jabref.gui.undo.CountingUndoManager;
import org.jabref.gui.util.BackgroundTask;
import org.jabref.gui.util.FileDialogConfiguration;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.gui.util.UiTaskExecutor;
import org.jabref.logic.importer.OpenDatabase;
import org.jabref.logic.importer.ParserResult;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.shared.DatabaseNotSupportedException;
import org.jabref.logic.shared.exception.InvalidDBMSConnectionPropertiesException;
import org.jabref.logic.shared.exception.NotASharedDatabaseException;
import org.jabref.logic.util.StandardFileType;
import org.jabref.logic.util.io.FileHistory;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.model.util.FileUpdateMonitor;
import org.jabref.preferences.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenDatabaseAction
extends SimpleCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenDatabaseAction.class);
    private static final List<GUIPostOpenAction> POST_OPEN_ACTIONS = List.of(new MergeReviewIntoCommentAction(), new CheckForNewEntryTypesAction());
    private final LibraryTabContainer tabContainer;
    private final PreferencesService preferencesService;
    private final StateManager stateManager;
    private final FileUpdateMonitor fileUpdateMonitor;
    private final DialogService dialogService;
    private final BibEntryTypesManager entryTypesManager;
    private final CountingUndoManager undoManager;
    private final ClipBoardManager clipboardManager;
    private final TaskExecutor taskExecutor;

    public OpenDatabaseAction(LibraryTabContainer tabContainer, PreferencesService preferencesService, DialogService dialogService, StateManager stateManager, FileUpdateMonitor fileUpdateMonitor, BibEntryTypesManager entryTypesManager, CountingUndoManager undoManager, ClipBoardManager clipBoardManager, TaskExecutor taskExecutor) {
        this.tabContainer = tabContainer;
        this.preferencesService = preferencesService;
        this.dialogService = dialogService;
        this.stateManager = stateManager;
        this.fileUpdateMonitor = fileUpdateMonitor;
        this.entryTypesManager = entryTypesManager;
        this.undoManager = undoManager;
        this.clipboardManager = clipBoardManager;
        this.taskExecutor = taskExecutor;
    }

    public static void performPostOpenActions(ParserResult result, DialogService dialogService, PreferencesService preferencesService) {
        for (GUIPostOpenAction action : POST_OPEN_ACTIONS) {
            if (!action.isActionNecessary(result, preferencesService)) continue;
            action.performAction(result, dialogService, preferencesService);
        }
    }

    public void execute() {
        FileDialogConfiguration fileDialogConfiguration = new FileDialogConfiguration.Builder().addExtensionFilter(StandardFileType.BIBTEX_DB).withDefaultExtension(StandardFileType.BIBTEX_DB).withInitialDirectory(this.getInitialDirectory()).build();
        List<Path> filesToOpen = this.dialogService.showFileOpenDialogAndGetMultipleFiles(fileDialogConfiguration);
        this.openFiles(filesToOpen);
    }

    private Path getInitialDirectory() {
        if (this.tabContainer.getLibraryTabs().isEmpty()) {
            return this.preferencesService.getFilePreferences().getWorkingDirectory();
        }
        Optional<Path> databasePath = this.tabContainer.getCurrentLibraryTab().getBibDatabaseContext().getDatabasePath();
        return databasePath.map(Path::getParent).orElse(this.preferencesService.getFilePreferences().getWorkingDirectory());
    }

    public void openFile(Path file) {
        this.openFiles(new ArrayList<Path>(List.of(file)));
    }

    public void openFiles(List<Path> filesToOpen) {
        LibraryTab toRaise = null;
        int initialCount = filesToOpen.size();
        int removed = 0;
        Iterator<Path> iterator = filesToOpen.iterator();
        block0: while (iterator.hasNext()) {
            Path file = iterator.next();
            for (LibraryTab libraryTab : this.tabContainer.getLibraryTabs()) {
                if (!libraryTab.getBibDatabaseContext().getDatabasePath().isPresent() || !libraryTab.getBibDatabaseContext().getDatabasePath().get().equals(file)) continue;
                iterator.remove();
                if (++removed != initialCount) continue block0;
                toRaise = libraryTab;
                continue block0;
            }
        }
        if (!filesToOpen.isEmpty()) {
            FileHistory fileHistory = this.preferencesService.getGuiPreferences().getFileHistory();
            filesToOpen.forEach(theFile -> {
                this.openTheFile((Path)theFile);
                fileHistory.newFile((Path)theFile);
            });
        } else if (toRaise != null && this.tabContainer.getCurrentLibraryTab() == null) {
            this.tabContainer.showLibraryTab(toRaise);
        }
    }

    private void openTheFile(Path file) {
        Objects.requireNonNull(file);
        if (!Files.exists(file, new LinkOption[0])) {
            return;
        }
        BackgroundTask<ParserResult> backgroundTask = BackgroundTask.wrap(() -> this.loadDatabase(file));
        LibraryTab newTab = LibraryTab.createLibraryTab(backgroundTask, file, this.dialogService, this.preferencesService, this.stateManager, this.tabContainer, this.fileUpdateMonitor, this.entryTypesManager, this.undoManager, this.clipboardManager, this.taskExecutor);
        this.tabContainer.addTab(newTab, true);
    }

    private ParserResult loadDatabase(Path file) throws Exception {
        Path fileToLoad = file.toAbsolutePath();
        this.dialogService.notify(Localization.lang("Opening", new Object[0]) + ": '" + String.valueOf(file) + "'");
        this.preferencesService.getFilePreferences().setWorkingDirectory(fileToLoad.getParent());
        Path backupDir = this.preferencesService.getFilePreferences().getBackupDirectory();
        ParserResult parserResult = null;
        if (BackupManager.backupFileDiffers(fileToLoad, backupDir)) {
            parserResult = BackupUIManager.showRestoreBackupDialog(this.dialogService, fileToLoad, this.preferencesService, this.fileUpdateMonitor, this.undoManager, this.stateManager).orElse(null);
        }
        try {
            if (parserResult == null) {
                parserResult = OpenDatabase.loadDatabase(fileToLoad, this.preferencesService.getImportFormatPreferences(), this.fileUpdateMonitor);
            }
            if (parserResult.hasWarnings()) {
                String content = Localization.lang("Please check your library file for wrong syntax.", new Object[0]) + "\n\n" + parserResult.getErrorMessage();
                UiTaskExecutor.runInJavaFXThread(() -> this.dialogService.showWarningDialogAndWait(Localization.lang("Open library error", new Object[0]), content));
            }
        }
        catch (IOException e) {
            parserResult = ParserResult.fromError(e);
            LOGGER.error("Error opening file '{}'", (Object)fileToLoad, (Object)e);
        }
        if (parserResult.getDatabase().isShared()) {
            OpenDatabaseAction.openSharedDatabase(parserResult, this.tabContainer, this.dialogService, this.preferencesService, this.stateManager, this.entryTypesManager, this.fileUpdateMonitor, this.undoManager, this.clipboardManager, this.taskExecutor);
        }
        return parserResult;
    }

    public static void openSharedDatabase(ParserResult parserResult, LibraryTabContainer tabContainer, DialogService dialogService, PreferencesService preferencesService, StateManager stateManager, BibEntryTypesManager entryTypesManager, FileUpdateMonitor fileUpdateMonitor, UndoManager undoManager, ClipBoardManager clipBoardManager, TaskExecutor taskExecutor) throws SQLException, DatabaseNotSupportedException, InvalidDBMSConnectionPropertiesException, NotASharedDatabaseException {
        try {
            new SharedDatabaseUIManager(tabContainer, dialogService, preferencesService, stateManager, entryTypesManager, fileUpdateMonitor, undoManager, clipBoardManager, taskExecutor).openSharedDatabaseFromParserResult(parserResult);
        }
        catch (SQLException | DatabaseNotSupportedException | InvalidDBMSConnectionPropertiesException | NotASharedDatabaseException e) {
            parserResult.getDatabaseContext().clearDatabasePath();
            parserResult.getDatabase().clearSharedDatabaseID();
            throw e;
        }
    }
}

