/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.importer.fetcher;

import com.tobiasdiez.easybind.EasyBind;
import de.saxsys.mvvmfx.utils.validation.FunctionBasedValidator;
import de.saxsys.mvvmfx.utils.validation.ValidationMessage;
import de.saxsys.mvvmfx.utils.validation.ValidationStatus;
import de.saxsys.mvvmfx.utils.validation.Validator;
import java.util.concurrent.Callable;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.apache.lucene.queryparser.flexible.core.QueryNodeParseException;
import org.apache.lucene.queryparser.flexible.core.parser.SyntaxParser;
import org.apache.lucene.queryparser.flexible.standard.parser.ParseException;
import org.apache.lucene.queryparser.flexible.standard.parser.StandardSyntaxParser;
import org.jabref.gui.DialogService;
import org.jabref.gui.StateManager;
import org.jabref.gui.importer.ImportEntriesDialog;
import org.jabref.gui.util.BackgroundTask;
import org.jabref.logic.importer.CompositeIdFetcher;
import org.jabref.logic.importer.ParserResult;
import org.jabref.logic.importer.SearchBasedFetcher;
import org.jabref.logic.importer.WebFetchers;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.strings.StringUtil;
import org.jabref.model.util.OptionalUtil;
import org.jabref.preferences.PreferencesService;
import org.jabref.preferences.SidePanePreferences;

public class WebSearchPaneViewModel {
    private final ObjectProperty<SearchBasedFetcher> selectedFetcher = new SimpleObjectProperty();
    private final ListProperty<SearchBasedFetcher> fetchers = new SimpleListProperty(FXCollections.observableArrayList());
    private final StringProperty query = new SimpleStringProperty();
    private final DialogService dialogService;
    private final PreferencesService preferencesService;
    private final StateManager stateManager;
    private final Validator searchQueryValidator;
    private final SyntaxParser parser = new StandardSyntaxParser();

    public WebSearchPaneViewModel(PreferencesService preferencesService, DialogService dialogService, StateManager stateManager) {
        this.dialogService = dialogService;
        this.stateManager = stateManager;
        this.preferencesService = preferencesService;
        this.fetchers.setAll(WebFetchers.getSearchBasedFetchers(preferencesService.getImportFormatPreferences(), preferencesService.getImporterPreferences()));
        SidePanePreferences sidePanePreferences = preferencesService.getSidePanePreferences();
        int defaultFetcherIndex = sidePanePreferences.getWebSearchFetcherSelected();
        if (defaultFetcherIndex <= 0 || defaultFetcherIndex >= this.fetchers.size()) {
            this.selectedFetcherProperty().setValue((Object)((SearchBasedFetcher)this.fetchers.getFirst()));
        } else {
            this.selectedFetcherProperty().setValue((Object)((SearchBasedFetcher)this.fetchers.get(defaultFetcherIndex)));
        }
        EasyBind.subscribe(this.selectedFetcherProperty(), newFetcher -> {
            int newIndex = this.fetchers.indexOf(newFetcher);
            sidePanePreferences.setWebSearchFetcherSelected(newIndex);
        });
        this.searchQueryValidator = new FunctionBasedValidator((ObservableValue)this.query, queryText -> {
            if (StringUtil.isBlank(queryText)) {
                return null;
            }
            if (CompositeIdFetcher.containsValidId(queryText)) {
                return null;
            }
            try {
                this.parser.parse((CharSequence)queryText, (CharSequence)"default");
                return null;
            }
            catch (ParseException e) {
                String element = e.currentToken.image;
                int position = e.currentToken.beginColumn;
                if (element == null) {
                    return ValidationMessage.error((String)Localization.lang("Invalid query. Check position %0.", position));
                }
                return ValidationMessage.error((String)Localization.lang("Invalid query element '%0' at position %1", element, position));
            }
            catch (QueryNodeParseException e) {
                return ValidationMessage.error((String)"");
            }
        });
    }

    public ObservableList<SearchBasedFetcher> getFetchers() {
        return (ObservableList)this.fetchers.get();
    }

    public ListProperty<SearchBasedFetcher> fetchersProperty() {
        return this.fetchers;
    }

    public SearchBasedFetcher getSelectedFetcher() {
        return (SearchBasedFetcher)this.selectedFetcher.get();
    }

    public ObjectProperty<SearchBasedFetcher> selectedFetcherProperty() {
        return this.selectedFetcher;
    }

    public String getQuery() {
        return (String)this.query.get();
    }

    public StringProperty queryProperty() {
        return this.query;
    }

    public void search() {
        if (!this.preferencesService.getImporterPreferences().areImporterEnabled() && !this.preferencesService.getImporterPreferences().areImporterEnabled()) {
            this.dialogService.notify(Localization.lang("Web search disabled", new Object[0]));
            return;
        }
        String query = this.getQuery().trim();
        if (StringUtil.isBlank(query)) {
            this.dialogService.notify(Localization.lang("Please enter a search string", new Object[0]));
            return;
        }
        if (this.stateManager.getActiveDatabase().isEmpty()) {
            this.dialogService.notify(Localization.lang("Please open or start a new library before searching", new Object[0]));
            return;
        }
        SearchBasedFetcher activeFetcher = this.getSelectedFetcher();
        Callable<ParserResult> parserResultCallable = () -> new ParserResult(activeFetcher.performSearch(query));
        String fetcherName = activeFetcher.getName();
        if (CompositeIdFetcher.containsValidId(query)) {
            CompositeIdFetcher compositeIdFetcher = new CompositeIdFetcher(this.preferencesService.getImportFormatPreferences());
            parserResultCallable = () -> new ParserResult(OptionalUtil.toList(compositeIdFetcher.performSearchById(query)));
            fetcherName = Localization.lang("Identifier-based Web Search", new Object[0]);
        }
        BackgroundTask<ParserResult> task = BackgroundTask.wrap(parserResultCallable).withInitialMessage(Localization.lang("Processing %0", query));
        task.onFailure(this.dialogService::showErrorDialogAndWait);
        ImportEntriesDialog dialog = new ImportEntriesDialog(this.stateManager.getActiveDatabase().get(), task);
        dialog.setTitle(fetcherName);
        this.dialogService.showCustomDialogAndWait(dialog);
    }

    public ValidationStatus queryValidationStatus() {
        return this.searchQueryValidator.getValidationStatus();
    }
}

