/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.integrity;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import org.jabref.gui.DialogService;
import org.jabref.gui.LibraryTab;
import org.jabref.gui.StateManager;
import org.jabref.gui.actions.ActionHelper;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.integrity.IntegrityCheckDialog;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.integrity.IntegrityCheck;
import org.jabref.logic.integrity.IntegrityMessage;
import org.jabref.logic.journals.JournalAbbreviationRepository;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.preferences.PreferencesService;

public class IntegrityCheckAction
extends SimpleCommand {
    private final TaskExecutor taskExecutor;
    private final DialogService dialogService;
    private final Supplier<LibraryTab> tabSupplier;
    private final PreferencesService preferencesService;
    private final StateManager stateManager;
    private final JournalAbbreviationRepository abbreviationRepository;

    public IntegrityCheckAction(Supplier<LibraryTab> tabSupplier, PreferencesService preferencesService, DialogService dialogService, StateManager stateManager, TaskExecutor taskExecutor, JournalAbbreviationRepository abbreviationRepository) {
        this.tabSupplier = tabSupplier;
        this.stateManager = stateManager;
        this.taskExecutor = taskExecutor;
        this.preferencesService = preferencesService;
        this.dialogService = dialogService;
        this.abbreviationRepository = abbreviationRepository;
        this.executable.bind((ObservableValue)ActionHelper.needsDatabase(this.stateManager));
    }

    public void execute() {
        final BibDatabaseContext database = this.stateManager.getActiveDatabase().orElseThrow(() -> new NullPointerException("Database null"));
        final IntegrityCheck check = new IntegrityCheck(database, this.preferencesService.getFilePreferences(), this.preferencesService.getCitationKeyPatternPreferences(), this.abbreviationRepository, this.preferencesService.getEntryEditorPreferences().shouldAllowIntegerEditionBibtex());
        Task<List<IntegrityMessage>> task = new Task<List<IntegrityMessage>>(this){

            protected List<IntegrityMessage> call() {
                ObservableList<BibEntry> entries = database.getDatabase().getEntries();
                ArrayList<IntegrityMessage> result = new ArrayList<IntegrityMessage>(check.checkDatabase(database.getDatabase()));
                for (int i = 0; i < entries.size() && !this.isCancelled(); ++i) {
                    BibEntry entry = (BibEntry)entries.get(i);
                    result.addAll(check.checkEntry(entry));
                    this.updateProgress(i, entries.size());
                }
                return result;
            }
        };
        task.setOnSucceeded(arg_0 -> this.lambda$execute$1((Task)task, arg_0));
        task.setOnFailed(arg_0 -> this.lambda$execute$2((Task)task, arg_0));
        this.dialogService.showProgressDialog(Localization.lang("Checking integrity...", new Object[0]), Localization.lang("Checking integrity...", new Object[0]), task);
        this.taskExecutor.execute(task);
    }

    private /* synthetic */ void lambda$execute$2(Task task, WorkerStateEvent event) {
        this.dialogService.showErrorDialogAndWait("Integrity check failed.", task.getException());
    }

    private /* synthetic */ void lambda$execute$1(Task task, WorkerStateEvent value) {
        List messages = (List)task.getValue();
        if (messages.isEmpty()) {
            this.dialogService.notify(Localization.lang("No problems found.", new Object[0]));
        } else {
            this.dialogService.showCustomDialogAndWait(new IntegrityCheckDialog(messages, this.tabSupplier.get()));
        }
    }
}

