/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.integrity;

import com.airhacks.afterburner.views.ViewLoader;
import jakarta.inject.Inject;
import java.util.List;
import java.util.function.Function;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.collections.ListChangeListener;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Dialog;
import javafx.scene.control.MenuButton;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.input.MouseButton;
import javafx.stage.Modality;
import org.controlsfx.control.table.TableFilter;
import org.jabref.gui.LibraryTab;
import org.jabref.gui.integrity.IntegrityCheckDialogViewModel;
import org.jabref.gui.theme.ThemeManager;
import org.jabref.gui.util.BaseDialog;
import org.jabref.gui.util.ValueTableCellFactory;
import org.jabref.logic.integrity.IntegrityMessage;
import org.jabref.logic.l10n.Localization;

public class IntegrityCheckDialog
extends BaseDialog<Void> {
    @FXML
    private TableView<IntegrityMessage> messagesTable;
    @FXML
    private TableColumn<IntegrityMessage, String> keyColumn;
    @FXML
    private TableColumn<IntegrityMessage, String> fieldColumn;
    @FXML
    private TableColumn<IntegrityMessage, String> messageColumn;
    @FXML
    private MenuButton keyFilterButton;
    @FXML
    private MenuButton fieldFilterButton;
    @FXML
    private MenuButton messageFilterButton;
    @Inject
    private ThemeManager themeManager;
    private final List<IntegrityMessage> messages;
    private final LibraryTab libraryTab;
    private IntegrityCheckDialogViewModel viewModel;
    private TableFilter<IntegrityMessage> tableFilter;

    public IntegrityCheckDialog(List<IntegrityMessage> messages, LibraryTab libraryTab) {
        this.messages = messages;
        this.libraryTab = libraryTab;
        this.setTitle(Localization.lang("Check integrity", new Object[0]));
        this.initModality(Modality.NONE);
        ViewLoader.view((Object)((Object)this)).load().setAsDialogPane((Dialog)this);
        this.themeManager.updateFontStyle(this.getDialogPane().getScene());
    }

    private void onSelectionChanged(ListChangeListener.Change<? extends IntegrityMessage> change) {
        if (change.next()) {
            change.getAddedSubList().stream().findFirst().ifPresent(message -> this.libraryTab.editEntryAndFocusField(message.getEntry(), message.getField()));
        }
    }

    public IntegrityCheckDialogViewModel getViewModel() {
        return this.viewModel;
    }

    @FXML
    private void initialize() {
        this.viewModel = new IntegrityCheckDialogViewModel(this.messages);
        this.messagesTable.getSelectionModel().getSelectedItems().addListener(this::onSelectionChanged);
        this.messagesTable.setItems(this.viewModel.getMessages());
        this.keyColumn.setCellValueFactory(row -> new ReadOnlyStringWrapper(((IntegrityMessage)row.getValue()).getEntry().getCitationKey().orElse("")));
        this.fieldColumn.setCellValueFactory(row -> new ReadOnlyStringWrapper(((IntegrityMessage)row.getValue()).getField().getDisplayName()));
        this.messageColumn.setCellValueFactory(row -> new ReadOnlyStringWrapper(((IntegrityMessage)row.getValue()).getMessage()));
        new ValueTableCellFactory().withText(Function.identity()).withTooltip(Function.identity()).install(this.messageColumn);
        this.tableFilter = TableFilter.forTableView(this.messagesTable).apply();
        this.tableFilter.getColumnFilter(this.keyColumn).ifPresent(columnFilter -> {
            ContextMenu keyContextMenu = this.keyColumn.getContextMenu();
            if (keyContextMenu != null) {
                this.keyFilterButton.setContextMenu(keyContextMenu);
                this.keyFilterButton.setOnMouseClicked(event -> {
                    if (event.getButton() == MouseButton.PRIMARY) {
                        if (keyContextMenu.isShowing()) {
                            keyContextMenu.setX(event.getScreenX());
                            keyContextMenu.setY(event.getScreenY());
                        } else {
                            keyContextMenu.show((Node)this.keyFilterButton, event.getScreenX(), event.getScreenY());
                        }
                    }
                });
            }
        });
        this.tableFilter.getColumnFilter(this.fieldColumn).ifPresent(columnFilter -> {
            ContextMenu fieldContextMenu = this.fieldColumn.getContextMenu();
            if (fieldContextMenu != null) {
                this.fieldFilterButton.setContextMenu(fieldContextMenu);
                this.fieldFilterButton.setOnMouseClicked(event -> {
                    if (event.getButton() == MouseButton.PRIMARY) {
                        if (fieldContextMenu.isShowing()) {
                            fieldContextMenu.setX(event.getScreenX());
                            fieldContextMenu.setY(event.getScreenY());
                        } else {
                            fieldContextMenu.show((Node)this.fieldFilterButton, event.getScreenX(), event.getScreenY());
                        }
                    }
                });
            }
        });
        this.tableFilter.getColumnFilter(this.messageColumn).ifPresent(columnFilter -> {
            ContextMenu messageContextMenu = this.messageColumn.getContextMenu();
            if (messageContextMenu != null) {
                this.messageFilterButton.setContextMenu(messageContextMenu);
                this.messageFilterButton.setOnMouseClicked(event -> {
                    if (event.getButton() == MouseButton.PRIMARY) {
                        if (messageContextMenu.isShowing()) {
                            messageContextMenu.setX(event.getScreenX());
                            messageContextMenu.setY(event.getScreenY());
                        } else {
                            messageContextMenu.show((Node)this.messageFilterButton, event.getScreenX(), event.getScreenY());
                        }
                    }
                });
            }
        });
    }

    public void clearFilters() {
        if (this.tableFilter != null) {
            this.tableFilter.resetFilter();
            this.messagesTable.getColumns().forEach(column -> {
                this.tableFilter.selectAllValues(column);
                column.setGraphic(null);
            });
        }
    }
}

