/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.libraryproperties.constants;

import com.airhacks.afterburner.views.ViewLoader;
import jakarta.inject.Inject;
import java.util.Optional;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.util.StringConverter;
import javafx.util.converter.DefaultStringConverter;
import org.jabref.gui.DialogService;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.libraryproperties.AbstractPropertiesTabView;
import org.jabref.gui.libraryproperties.PropertiesTab;
import org.jabref.gui.libraryproperties.constants.ConstantsItemModel;
import org.jabref.gui.libraryproperties.constants.ConstantsPropertiesViewModel;
import org.jabref.gui.util.ValueTableCellFactory;
import org.jabref.gui.util.ViewModelTextFieldTableCellVisualizationFactory;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.preferences.PreferencesService;

public class ConstantsPropertiesView
extends AbstractPropertiesTabView<ConstantsPropertiesViewModel>
implements PropertiesTab {
    @FXML
    private TableView<ConstantsItemModel> stringsList;
    @FXML
    private TableColumn<ConstantsItemModel, String> labelColumn;
    @FXML
    private TableColumn<ConstantsItemModel, String> contentColumn;
    @FXML
    private TableColumn<ConstantsItemModel, String> actionsColumn;
    @FXML
    private Button addStringButton;
    @FXML
    private ButtonType saveButton;
    @Inject
    private PreferencesService preferencesService;
    @Inject
    private DialogService dialogService;

    public ConstantsPropertiesView(BibDatabaseContext databaseContext) {
        this.databaseContext = databaseContext;
        ViewLoader.view((Object)this).root((Object)this).load();
    }

    @Override
    public String getTabName() {
        return Localization.lang("String constants", new Object[0]);
    }

    public void initialize() {
        this.viewModel = new ConstantsPropertiesViewModel(this.databaseContext, this.dialogService, this.preferencesService.getFilePreferences());
        this.addStringButton.setTooltip(new Tooltip(Localization.lang("New string", new Object[0])));
        this.labelColumn.setSortable(true);
        this.labelColumn.setReorderable(false);
        this.labelColumn.setCellValueFactory(cellData -> ((ConstantsItemModel)cellData.getValue()).labelProperty());
        new ViewModelTextFieldTableCellVisualizationFactory().withValidation(ConstantsItemModel::labelValidation).install(this.labelColumn, (StringConverter<String>)new DefaultStringConverter());
        this.labelColumn.setOnEditCommit(cellEvent -> {
            TableView tableView = cellEvent.getTableView();
            ConstantsItemModel cellItem = (ConstantsItemModel)tableView.getItems().get(cellEvent.getTablePosition().getRow());
            Optional<ConstantsItemModel> existingItem = ((ConstantsPropertiesViewModel)this.viewModel).labelAlreadyExists((String)cellEvent.getNewValue());
            if (existingItem.isPresent() && !existingItem.get().equals(cellItem)) {
                this.dialogService.showErrorDialogAndWait(Localization.lang("A string with the label '%0' already exists.", cellEvent.getNewValue()));
                cellItem.setLabel((String)cellEvent.getOldValue());
            } else {
                cellItem.setLabel((String)cellEvent.getNewValue());
            }
            ((ConstantsPropertiesViewModel)this.viewModel).resortStrings();
            TableView.TableViewSelectionModel selectionModel = tableView.getSelectionModel();
            selectionModel.select((Object)cellItem);
            selectionModel.focus(selectionModel.getSelectedIndex());
            tableView.refresh();
            tableView.scrollTo((Object)cellItem);
        });
        this.contentColumn.setSortable(true);
        this.contentColumn.setReorderable(false);
        this.contentColumn.setCellValueFactory(cellData -> ((ConstantsItemModel)cellData.getValue()).contentProperty());
        new ViewModelTextFieldTableCellVisualizationFactory().withValidation(ConstantsItemModel::contentValidation).install(this.contentColumn, (StringConverter<String>)new DefaultStringConverter());
        this.contentColumn.setOnEditCommit(cell -> ((ConstantsItemModel)cell.getRowValue()).setContent((String)cell.getNewValue()));
        this.actionsColumn.setSortable(false);
        this.actionsColumn.setReorderable(false);
        this.actionsColumn.setCellValueFactory(cellData -> ((ConstantsItemModel)cellData.getValue()).labelProperty());
        new ValueTableCellFactory().withGraphic(label -> IconTheme.JabRefIcons.DELETE_ENTRY.getGraphicNode()).withTooltip(label -> Localization.lang("Remove string %0", label)).withOnMouseClickedEvent(item -> evt -> ((ConstantsPropertiesViewModel)this.viewModel).removeString((ConstantsItemModel)this.stringsList.getFocusModel().getFocusedItem())).install(this.actionsColumn);
        this.stringsList.itemsProperty().bindBidirectional(((ConstantsPropertiesViewModel)this.viewModel).stringsListProperty());
        this.stringsList.setEditable(true);
    }

    @FXML
    private void addString() {
        ((ConstantsPropertiesViewModel)this.viewModel).addNewString();
        this.stringsList.edit(this.stringsList.getItems().size() - 1, this.labelColumn);
    }

    @FXML
    private void openHelp() {
        ((ConstantsPropertiesViewModel)this.viewModel).openHelpPage();
    }
}

