/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.libraryproperties.general;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import org.jabref.gui.DialogService;
import org.jabref.gui.libraryproperties.PropertiesTabViewModel;
import org.jabref.gui.util.DirectoryDialogConfiguration;
import org.jabref.logic.l10n.Encodings;
import org.jabref.logic.shared.DatabaseLocation;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.database.BibDatabaseMode;
import org.jabref.model.metadata.MetaData;
import org.jabref.preferences.PreferencesService;

public class GeneralPropertiesViewModel
implements PropertiesTabViewModel {
    private final BooleanProperty encodingDisableProperty = new SimpleBooleanProperty();
    private final ListProperty<Charset> encodingsProperty = new SimpleListProperty(FXCollections.observableArrayList(Encodings.getCharsets()));
    private final ObjectProperty<Charset> selectedEncodingProperty = new SimpleObjectProperty((Object)Encodings.getCharsets().getFirst());
    private final ListProperty<BibDatabaseMode> databaseModesProperty = new SimpleListProperty(FXCollections.observableArrayList((Object[])BibDatabaseMode.values()));
    private final SimpleObjectProperty<BibDatabaseMode> selectedDatabaseModeProperty = new SimpleObjectProperty((Object)BibDatabaseMode.BIBLATEX);
    private final StringProperty generalFileDirectoryProperty = new SimpleStringProperty("");
    private final StringProperty userSpecificFileDirectoryProperty = new SimpleStringProperty("");
    private final StringProperty laTexFileDirectoryProperty = new SimpleStringProperty("");
    private final DialogService dialogService;
    private final PreferencesService preferencesService;
    private final BibDatabaseContext databaseContext;
    private final MetaData metaData;
    private final DirectoryDialogConfiguration directoryDialogConfiguration;

    GeneralPropertiesViewModel(BibDatabaseContext databaseContext, DialogService dialogService, PreferencesService preferencesService) {
        this.dialogService = dialogService;
        this.preferencesService = preferencesService;
        this.databaseContext = databaseContext;
        this.metaData = databaseContext.getMetaData();
        this.directoryDialogConfiguration = new DirectoryDialogConfiguration.Builder().withInitialDirectory(preferencesService.getFilePreferences().getWorkingDirectory()).build();
    }

    @Override
    public void setValues() {
        boolean isShared = this.databaseContext.getLocation() == DatabaseLocation.SHARED;
        this.encodingDisableProperty.setValue(Boolean.valueOf(isShared));
        this.selectedEncodingProperty.setValue((Object)this.metaData.getEncoding().orElse(StandardCharsets.UTF_8));
        this.selectedDatabaseModeProperty.setValue((Object)this.metaData.getMode().orElse(BibDatabaseMode.BIBLATEX));
        this.generalFileDirectoryProperty.setValue(this.metaData.getDefaultFileDirectory().orElse("").trim());
        this.userSpecificFileDirectoryProperty.setValue(this.metaData.getUserFileDirectory(this.preferencesService.getFilePreferences().getUserAndHost()).orElse("").trim());
        this.laTexFileDirectoryProperty.setValue(this.metaData.getLatexFileDirectory(this.preferencesService.getFilePreferences().getUserAndHost()).map(Path::toString).orElse(""));
    }

    @Override
    public void storeSettings() {
        MetaData newMetaData = this.databaseContext.getMetaData();
        newMetaData.setEncoding((Charset)this.selectedEncodingProperty.getValue());
        newMetaData.setMode((BibDatabaseMode)((Object)this.selectedDatabaseModeProperty.getValue()));
        String generalFileDirectory = this.generalFileDirectoryProperty.getValue().trim();
        if (generalFileDirectory.isEmpty()) {
            newMetaData.clearDefaultFileDirectory();
        } else {
            newMetaData.setDefaultFileDirectory(generalFileDirectory);
        }
        String userSpecificFileDirectory = this.userSpecificFileDirectoryProperty.getValue();
        if (userSpecificFileDirectory.isEmpty()) {
            newMetaData.clearUserFileDirectory(this.preferencesService.getFilePreferences().getUserAndHost());
        } else {
            newMetaData.setUserFileDirectory(this.preferencesService.getFilePreferences().getUserAndHost(), userSpecificFileDirectory);
        }
        String latexFileDirectory = this.laTexFileDirectoryProperty.getValue();
        if (latexFileDirectory.isEmpty()) {
            newMetaData.clearLatexFileDirectory(this.preferencesService.getFilePreferences().getUserAndHost());
        } else {
            newMetaData.setLatexFileDirectory(this.preferencesService.getFilePreferences().getUserAndHost(), Path.of(latexFileDirectory, new String[0]));
        }
        this.databaseContext.setMetaData(newMetaData);
    }

    public void browseGeneralDir() {
        this.dialogService.showDirectorySelectionDialog(this.directoryDialogConfiguration).ifPresent(dir -> this.generalFileDirectoryProperty.setValue(dir.toAbsolutePath().toString()));
    }

    public void browseUserDir() {
        this.dialogService.showDirectorySelectionDialog(this.directoryDialogConfiguration).ifPresent(dir -> this.userSpecificFileDirectoryProperty.setValue(dir.toAbsolutePath().toString()));
    }

    public void browseLatexDir() {
        this.dialogService.showDirectorySelectionDialog(this.directoryDialogConfiguration).ifPresent(dir -> this.laTexFileDirectoryProperty.setValue(dir.toAbsolutePath().toString()));
    }

    public BooleanProperty encodingDisableProperty() {
        return this.encodingDisableProperty;
    }

    public ListProperty<Charset> encodingsProperty() {
        return this.encodingsProperty;
    }

    public ObjectProperty<Charset> selectedEncodingProperty() {
        return this.selectedEncodingProperty;
    }

    public ListProperty<BibDatabaseMode> databaseModesProperty() {
        return this.databaseModesProperty;
    }

    public SimpleObjectProperty<BibDatabaseMode> selectedDatabaseModeProperty() {
        return this.selectedDatabaseModeProperty;
    }

    public StringProperty generalFileDirectoryPropertyProperty() {
        return this.generalFileDirectoryProperty;
    }

    public StringProperty userSpecificFileDirectoryProperty() {
        return this.userSpecificFileDirectoryProperty;
    }

    public StringProperty laTexFileDirectoryProperty() {
        return this.laTexFileDirectoryProperty;
    }
}

