/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.linkedfile;

import java.nio.file.Path;
import java.util.Optional;
import javafx.beans.value.ObservableValue;
import org.jabref.gui.DialogService;
import org.jabref.gui.LibraryTab;
import org.jabref.gui.StateManager;
import org.jabref.gui.actions.ActionHelper;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.fieldeditors.LinkedFilesEditorViewModel;
import org.jabref.gui.linkedfile.LinkedFileEditDialogView;
import org.jabref.gui.undo.UndoableFieldChange;
import org.jabref.gui.util.FileDialogConfiguration;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.FieldChange;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.LinkedFile;
import org.jabref.preferences.FilePreferences;

public class AttachFileAction
extends SimpleCommand {
    private final LibraryTab libraryTab;
    private final StateManager stateManager;
    private final DialogService dialogService;
    private final FilePreferences filePreferences;

    public AttachFileAction(LibraryTab libraryTab, DialogService dialogService, StateManager stateManager, FilePreferences filePreferences) {
        this.libraryTab = libraryTab;
        this.stateManager = stateManager;
        this.dialogService = dialogService;
        this.filePreferences = filePreferences;
        this.executable.bind((ObservableValue)ActionHelper.needsEntriesSelected(1, stateManager));
    }

    public void execute() {
        if (this.stateManager.getActiveDatabase().isEmpty()) {
            this.dialogService.notify(Localization.lang("This operation requires an open library.", new Object[0]));
            return;
        }
        if (this.stateManager.getSelectedEntries().size() != 1) {
            this.dialogService.notify(Localization.lang("This operation requires exactly one item to be selected.", new Object[0]));
            return;
        }
        BibDatabaseContext databaseContext = this.stateManager.getActiveDatabase().get();
        BibEntry entry = (BibEntry)this.stateManager.getSelectedEntries().getFirst();
        Path workingDirectory = databaseContext.getFirstExistingFileDir(this.filePreferences).orElse(this.filePreferences.getWorkingDirectory());
        FileDialogConfiguration fileDialogConfiguration = new FileDialogConfiguration.Builder().withInitialDirectory(workingDirectory).build();
        this.dialogService.showFileOpenDialog(fileDialogConfiguration).ifPresent(newFile -> {
            LinkedFile linkedFile = LinkedFilesEditorViewModel.fromFile(newFile, databaseContext.getFileDirectories(this.filePreferences), this.filePreferences);
            LinkedFileEditDialogView dialog = new LinkedFileEditDialogView(linkedFile);
            this.dialogService.showCustomDialogAndWait(dialog).ifPresent(editedLinkedFile -> {
                Optional<FieldChange> fieldChange = entry.addFile((LinkedFile)editedLinkedFile);
                fieldChange.ifPresent(change -> {
                    UndoableFieldChange ce = new UndoableFieldChange((FieldChange)change);
                    this.libraryTab.getUndoManager().addEdit(ce);
                    this.libraryTab.markBaseChanged();
                });
            });
        });
    }
}

