/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.linkedfile;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import javafx.collections.FXCollections;
import javafx.scene.Node;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.layout.VBox;
import org.jabref.gui.DialogService;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.desktop.JabRefDesktop;
import org.jabref.gui.fieldeditors.LinkedFileViewModel;
import org.jabref.gui.fieldeditors.LinkedFilesEditorViewModel;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.icon.JabRefIconView;
import org.jabref.gui.util.ViewModelListCellFactory;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.LinkedFile;
import org.jabref.preferences.FilePreferences;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NullMarked
public class DeleteFileAction
extends SimpleCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeleteFileAction.class);
    private final DialogService dialogService;
    private final FilePreferences filePreferences;
    private final BibDatabaseContext databaseContext;
    private final @Nullable LinkedFilesEditorViewModel viewModel;
    private final List<LinkedFileViewModel> filesToDelete;
    private boolean success = false;

    public DeleteFileAction(DialogService dialogService, FilePreferences filePreferences, BibDatabaseContext databaseContext, @Nullable LinkedFilesEditorViewModel viewModel, List<LinkedFileViewModel> filesToDelete) {
        this.dialogService = dialogService;
        this.filePreferences = filePreferences;
        this.databaseContext = databaseContext;
        this.viewModel = viewModel;
        this.filesToDelete = List.copyOf(filesToDelete);
    }

    public DeleteFileAction(DialogService dialogService, FilePreferences filePreferences, BibDatabaseContext databaseContext, List<LinkedFileViewModel> filesToDelete) {
        this(dialogService, filePreferences, databaseContext, null, filesToDelete);
    }

    private boolean deletionOfCompleteEntry() {
        return this.viewModel == null;
    }

    public void execute() {
        String dialogTitle;
        if (this.filesToDelete.isEmpty()) {
            this.dialogService.notify(Localization.lang("This operation requires selected linked files.", new Object[0]));
            return;
        }
        if (!this.filePreferences.confirmDeleteLinkedFile()) {
            LOGGER.info("Deleting {} files without confirmation.", (Object)this.filesToDelete.size());
            this.deleteFiles(true);
            return;
        }
        int numberOfLinkedFiles = this.filesToDelete.size();
        String dialogDescription = Localization.lang("How should these files be handled?", new Object[0]);
        if (numberOfLinkedFiles != 1) {
            dialogTitle = Localization.lang("Delete %0 files", numberOfLinkedFiles);
        } else {
            LinkedFile linkedFile = this.filesToDelete.getFirst().getFile();
            Optional<Path> file = linkedFile.findIn(this.databaseContext, this.filePreferences);
            if (file.isPresent()) {
                Path path = file.get();
                dialogTitle = Localization.lang("Delete '%0'", path.getFileName().toString());
            } else {
                this.dialogService.notify(Localization.lang("Error accessing file '%0'.", linkedFile.getLink()));
                this.success = true;
                return;
            }
        }
        DialogPane dialogPane = this.createDeleteFilesDialog(dialogDescription);
        String label = this.filePreferences.moveToTrash() ? Localization.lang("Move file(s) to trash", new Object[0]) : Localization.lang("Delete from disk", new Object[0]);
        ButtonType deleteFromDisk = new ButtonType(label);
        ButtonType removeFromEntry = new ButtonType(Localization.lang("Keep file(s)", new Object[0]), ButtonBar.ButtonData.YES);
        Optional<ButtonType> buttonType = this.dialogService.showCustomDialogAndWait(dialogTitle, dialogPane, removeFromEntry, deleteFromDisk, ButtonType.CANCEL);
        if (buttonType.isPresent()) {
            ButtonType theButtonType = buttonType.get();
            if (theButtonType.equals(removeFromEntry)) {
                this.deleteFiles(false);
            } else if (theButtonType.equals(deleteFromDisk)) {
                this.deleteFiles(true);
            }
        }
    }

    private DialogPane createDeleteFilesDialog(String description) {
        JabRefIconView warning = new JabRefIconView(IconTheme.JabRefIcons.WARNING);
        warning.setGlyphSize(24.0);
        Label header = new Label(description, (Node)warning);
        header.setWrapText(true);
        header.setStyle("-fx-padding: 10px;\n-fx-background-color: -fx-background;");
        ListView filesToDeleteList = new ListView(FXCollections.observableArrayList(this.filesToDelete));
        new ViewModelListCellFactory().withText(item -> item.getFile().getLink()).install(filesToDeleteList);
        VBox content = new VBox(new Node[]{header, filesToDeleteList});
        DialogPane dialogPane = new DialogPane();
        dialogPane.setHeader((Node)header);
        dialogPane.setContent((Node)content);
        return dialogPane;
    }

    private void deleteFiles(boolean deleteFromDisk) {
        this.success = true;
        for (LinkedFileViewModel fileViewModel : this.filesToDelete) {
            if (!fileViewModel.getFile().isOnlineLink() && deleteFromDisk) {
                this.deleteFileHelper(this.databaseContext, fileViewModel.getFile());
            }
            if (this.viewModel == null) continue;
            this.viewModel.removeFileLink(fileViewModel);
        }
    }

    private void deleteFileHelper(BibDatabaseContext databaseContext, LinkedFile linkedFile) {
        Optional<Path> file = linkedFile.findIn(databaseContext, this.filePreferences);
        if (file.isEmpty()) {
            LOGGER.warn("Could not find file {}", (Object)linkedFile.getLink());
            this.dialogService.notify(Localization.lang("Error accessing file '%0'.", linkedFile.getLink()));
            this.success = true;
            return;
        }
        Path theFile = file.get();
        try {
            boolean preferencesMoveToTrash = this.filePreferences.moveToTrash();
            LOGGER.debug("filePreferences.moveToTrash() = {}", (Object)preferencesMoveToTrash);
            if (preferencesMoveToTrash) {
                LOGGER.debug("Moving to trash: {}", (Object)theFile);
                JabRefDesktop.moveToTrash(theFile);
            } else {
                LOGGER.debug("Deleting: {}", (Object)theFile);
                Files.delete(theFile);
            }
            this.success = true;
        }
        catch (IOException ex) {
            this.success = false;
            this.dialogService.showErrorDialogAndWait(Localization.lang("Cannot delete file '%0'", theFile), Localization.lang("File permission error", new Object[0]));
            LOGGER.warn("Error while deleting: {}", (Object)linkedFile, (Object)ex);
        }
    }

    public boolean isSuccess() {
        return this.success;
    }
}

