/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.maintable;

import java.util.HashMap;
import java.util.Map;
import javafx.scene.Node;
import javax.swing.undo.UndoManager;
import org.jabref.gui.externalfiletype.ExternalFileType;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.icon.JabRefIcon;
import org.jabref.gui.specialfields.SpecialFieldViewModel;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.SpecialField;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.field.UnknownField;
import org.jabref.preferences.PreferencesService;

public class CellFactory {
    private final Map<Field, JabRefIcon> TABLE_ICONS = new HashMap<Field, JabRefIcon>();

    public CellFactory(PreferencesService preferencesService, UndoManager undoManager) {
        JabRefIcon icon = IconTheme.JabRefIcons.PDF_FILE;
        this.TABLE_ICONS.put(StandardField.PDF, icon);
        icon = IconTheme.JabRefIcons.WWW;
        this.TABLE_ICONS.put(StandardField.URL, icon);
        icon = IconTheme.JabRefIcons.WWW;
        this.TABLE_ICONS.put(new UnknownField("citeseerurl"), icon);
        icon = IconTheme.JabRefIcons.WWW;
        this.TABLE_ICONS.put(StandardField.EPRINT, icon);
        icon = IconTheme.JabRefIcons.DOI;
        this.TABLE_ICONS.put(StandardField.DOI, icon);
        icon = IconTheme.JabRefIcons.FILE;
        this.TABLE_ICONS.put(StandardField.PS, icon);
        icon = IconTheme.JabRefIcons.FOLDER;
        this.TABLE_ICONS.put(StandardField.FOLDER, icon);
        icon = IconTheme.JabRefIcons.FILE;
        this.TABLE_ICONS.put(StandardField.FILE, icon);
        for (ExternalFileType fileType : preferencesService.getFilePreferences().getExternalFileTypes()) {
            icon = fileType.getIcon();
            this.TABLE_ICONS.put(fileType.getField(), icon);
        }
        SpecialFieldViewModel relevanceViewModel = new SpecialFieldViewModel(SpecialField.RELEVANCE, preferencesService, undoManager);
        icon = relevanceViewModel.getIcon();
        this.TABLE_ICONS.put(SpecialField.RELEVANCE, icon);
        SpecialFieldViewModel qualityViewModel = new SpecialFieldViewModel(SpecialField.QUALITY, preferencesService, undoManager);
        icon = qualityViewModel.getIcon();
        this.TABLE_ICONS.put(SpecialField.QUALITY, icon);
        SpecialFieldViewModel rankViewModel = new SpecialFieldViewModel(SpecialField.RANKING, preferencesService, undoManager);
        icon = rankViewModel.getIcon();
        this.TABLE_ICONS.put(SpecialField.RANKING, icon);
        SpecialFieldViewModel priorityViewModel = new SpecialFieldViewModel(SpecialField.PRIORITY, preferencesService, undoManager);
        icon = priorityViewModel.getIcon();
        this.TABLE_ICONS.put(SpecialField.PRIORITY, icon);
        SpecialFieldViewModel readViewModel = new SpecialFieldViewModel(SpecialField.READ_STATUS, preferencesService, undoManager);
        icon = readViewModel.getIcon();
        this.TABLE_ICONS.put(SpecialField.READ_STATUS, icon);
        SpecialFieldViewModel printedViewModel = new SpecialFieldViewModel(SpecialField.PRINTED, preferencesService, undoManager);
        icon = printedViewModel.getIcon();
        this.TABLE_ICONS.put(SpecialField.PRINTED, icon);
    }

    public Node getTableIcon(Field field) {
        JabRefIcon icon = this.TABLE_ICONS.get(field);
        if (icon == null) {
            return null;
        }
        return icon.getGraphicNode();
    }
}

